/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.common;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.fuzzyjoin.similarity.SimilarityMetricEditDistance;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.common.OrderedListIterator;
import org.apache.asterix.runtime.exceptions.IncompatibleTypeException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.asterix.runtime.exceptions.UnsupportedItemTypeException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.data.std.util.ISequenceIterator;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class EditDistanceEvaluator
implements IScalarEvaluator {
    protected final int typeIndicatorSize = 1;
    protected final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    protected final DataOutput out = this.resultStorage.getDataOutput();
    protected final IPointable argPtr1 = new VoidPointable();
    protected final IPointable argPtr2 = new VoidPointable();
    protected final IScalarEvaluator firstStringEval;
    protected final IScalarEvaluator secondStringEval;
    protected final SourceLocation sourceLoc;
    protected final SimilarityMetricEditDistance ed = new SimilarityMetricEditDistance();
    protected final OrderedListIterator firstOrdListIter = new OrderedListIterator();
    protected final OrderedListIterator secondOrdListIter = new OrderedListIterator();
    protected int editDistance = 0;
    protected final AMutableInt64 aInt64 = new AMutableInt64(-1L);
    protected final ISerializerDeserializer<AInt64> int64Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
    protected ATypeTag itemTypeTag;
    protected ATypeTag firstTypeTag;
    protected ATypeTag secondTypeTag;

    public EditDistanceEvaluator(IScalarEvaluatorFactory[] args, IHyracksTaskContext context, SourceLocation sourceLoc) throws HyracksDataException {
        this.firstStringEval = args[0].createScalarEvaluator(context);
        this.secondStringEval = args[1].createScalarEvaluator(context);
        this.sourceLoc = sourceLoc;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        this.firstStringEval.evaluate(tuple, this.argPtr1);
        this.firstTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.argPtr1.getByteArray()[this.argPtr1.getStartOffset()]);
        this.secondStringEval.evaluate(tuple, this.argPtr2);
        this.secondTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.argPtr2.getByteArray()[this.argPtr2.getStartOffset()]);
        if (!this.checkArgTypes(this.firstTypeTag, this.secondTypeTag)) {
            result.set((IValueReference)this.resultStorage);
            return;
        }
        this.editDistance = this.computeResult(this.argPtr1, this.argPtr2, this.firstTypeTag);
        try {
            this.writeResult(this.editDistance);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        result.set((IValueReference)this.resultStorage);
    }

    protected int computeResult(IPointable left, IPointable right, ATypeTag argType) throws HyracksDataException {
        byte[] leftBytes = left.getByteArray();
        int leftStartOffset = left.getStartOffset();
        byte[] rightBytes = right.getByteArray();
        int rightStartOffset = right.getStartOffset();
        switch (argType) {
            case STRING: {
                return this.ed.getActualUTF8StringEditDistanceVal(leftBytes, leftStartOffset + 1, rightBytes, rightStartOffset + 1, -1);
            }
            case ARRAY: {
                this.firstOrdListIter.reset(leftBytes, leftStartOffset);
                this.secondOrdListIter.reset(rightBytes, rightStartOffset);
                return (int)this.ed.computeSimilarity((ISequenceIterator)this.firstOrdListIter, (ISequenceIterator)this.secondOrdListIter);
            }
        }
        throw new TypeMismatchException(this.sourceLoc, BuiltinFunctions.EDIT_DISTANCE, Integer.valueOf(0), argType.serialize(), new byte[]{ATypeTag.SERIALIZED_STRING_TYPE_TAG, ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG});
    }

    protected boolean checkArgTypes(ATypeTag typeTag1, ATypeTag typeTag2) throws HyracksDataException {
        if (typeTag1 != typeTag2) {
            throw new IncompatibleTypeException(this.sourceLoc, BuiltinFunctions.EDIT_DISTANCE, typeTag1.serialize(), typeTag2.serialize());
        }
        if (typeTag1 != ATypeTag.STRING && typeTag1 != ATypeTag.ARRAY) {
            throw new TypeMismatchException(this.sourceLoc, BuiltinFunctions.EDIT_DISTANCE, Integer.valueOf(0), typeTag1.serialize(), new byte[]{ATypeTag.SERIALIZED_STRING_TYPE_TAG, ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG});
        }
        if (typeTag1 == ATypeTag.ARRAY) {
            this.itemTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.argPtr1.getByteArray()[this.argPtr1.getStartOffset() + 1]);
            if (this.itemTypeTag == ATypeTag.ANY) {
                throw new UnsupportedItemTypeException(this.sourceLoc, BuiltinFunctions.EDIT_DISTANCE, this.itemTypeTag.serialize());
            }
            this.itemTypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.argPtr2.getByteArray()[this.argPtr2.getStartOffset() + 1]);
            if (this.itemTypeTag == ATypeTag.ANY) {
                throw new UnsupportedItemTypeException(this.sourceLoc, BuiltinFunctions.EDIT_DISTANCE, this.itemTypeTag.serialize());
            }
        }
        return true;
    }

    protected void writeResult(int ed) throws IOException {
        this.aInt64.setValue((long)ed);
        this.int64Serde.serialize((Object)this.aInt64, this.out);
    }
}

