/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.fuzzyjoin.similarity;

import java.util.TreeSet;
import org.apache.asterix.fuzzyjoin.similarity.IGenericSimilarityMetric;
import org.apache.asterix.fuzzyjoin.similarity.SimilarityMetric;
import org.apache.asterix.fuzzyjoin.tokenizer.Tokenizer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.util.ISequenceIterator;

public class SimilarityMetricJaccard
extends SimilarityMetric
implements IGenericSimilarityMetric {
    public static float getSimilarity(int intersectSize, int lengthX, int lengthY) {
        return (float)intersectSize / (float)(lengthX + lengthY - intersectSize);
    }

    public static float getSimilarityBag(int[] tokensX, int[] tokensY) {
        TreeSet<Integer> setX = new TreeSet<Integer>();
        for (int token : tokensX) {
            setX.add(token);
        }
        TreeSet<Integer> setY = new TreeSet<Integer>();
        for (int token : tokensY) {
            setY.add(token);
        }
        setX.retainAll(setY);
        return (float)setX.size() / (float)(tokensX.length + tokensY.length - setX.size());
    }

    @Override
    public float computeSimilarity(ISequenceIterator tokensX, ISequenceIterator tokensY) throws HyracksDataException {
        int intersectionSize = SimilarityMetric.getIntersectSize(tokensX, tokensY);
        int totalSize = tokensX.size() + tokensY.size();
        return (float)intersectionSize / (float)(totalSize - intersectionSize);
    }

    @Override
    public float computeSimilarity(ISequenceIterator firstList, ISequenceIterator secondList, float simThresh) throws HyracksDataException {
        boolean passesLengthFilter;
        int lengthLowerBound = (int)Math.ceil(simThresh * (float)firstList.size());
        boolean bl = passesLengthFilter = lengthLowerBound <= secondList.size() && (float)secondList.size() <= 1.0f / simThresh * (float)firstList.size();
        if (!passesLengthFilter) {
            return -1.0f;
        }
        float jacc = this.computeSimilarity(firstList, secondList);
        if (jacc < simThresh) {
            return -1.0f;
        }
        return jacc;
    }

    @Override
    public float getSimilarity(int[] tokensX, int startX, int lengthX, int[] tokensY, int startY, int lengthY) {
        int intersectionSize = SimilarityMetric.getIntersectSize(tokensX, startX, lengthX, tokensY, startY, lengthY);
        int totalSize = lengthX + lengthY;
        return (float)intersectionSize / (float)(totalSize - intersectionSize);
    }

    @Override
    public float getSimilarity(int[] tokensX, int[] tokensY) {
        return this.getSimilarity(tokensX, 0, tokensX.length, tokensY, 0, tokensY.length);
    }

    @Override
    public float getSimilarity(String stringX, String stringY, Tokenizer tokenizer) {
        TreeSet<String> setX = new TreeSet<String>();
        for (String string : tokenizer.tokenize(stringX)) {
            setX.add(string);
        }
        TreeSet<String> setY = new TreeSet<String>();
        for (String token : tokenizer.tokenize(stringY)) {
            setY.add(token);
        }
        int n = setX.size();
        int lengthY = setY.size();
        setX.retainAll(setY);
        return (float)setX.size() / (float)(n + lengthY - setX.size());
    }
}

