/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.util;

import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.expression.FieldAccessor;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.sqlpp.parser.ParseException;
import org.apache.asterix.lang.sqlpp.parser.SqlppParseException;
import org.apache.asterix.lang.sqlpp.util.SqlppFormatPrintUtil;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExpressionToVariableUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private ExpressionToVariableUtil() {
    }

    private static String getGeneratedIdentifier(Expression expr) throws ParseException {
        String exprText;
        if (expr.getKind() == Expression.Kind.VARIABLE_EXPRESSION) {
            VariableExpr bindingVarExpr = (VariableExpr)expr;
            VarIdentifier var = bindingVarExpr.getVar();
            return SqlppVariableUtil.isExternalVariableIdentifier(var) ? null : var.getValue();
        }
        if (expr.getKind() == Expression.Kind.FIELD_ACCESSOR_EXPRESSION) {
            FieldAccessor fa = (FieldAccessor)expr;
            return SqlppVariableUtil.toInternalVariableName(fa.getIdent().getValue());
        }
        try {
            exprText = SqlppFormatPrintUtil.toString((ILangExpression)expr);
        }
        catch (CompilationException e) {
            LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
            throw new SqlppParseException(expr.getSourceLocation(), e.getLocalizedMessage());
        }
        throw new SqlppParseException(expr.getSourceLocation(), "Need an alias for the enclosed expression:\n" + exprText);
    }

    public static String getGeneratedIdentifier(Expression expr, boolean raiseError) throws ParseException {
        try {
            return ExpressionToVariableUtil.getGeneratedIdentifier(expr);
        }
        catch (ParseException e) {
            if (raiseError) {
                throw e;
            }
            return null;
        }
    }

    public static VariableExpr getGeneratedVariable(Expression expr, boolean raiseError) throws ParseException {
        try {
            String varName = ExpressionToVariableUtil.getGeneratedIdentifier(expr);
            VarIdentifier var = new VarIdentifier(varName);
            VariableExpr varExpr = new VariableExpr();
            varExpr.setVar(var);
            varExpr.setSourceLocation(expr.getSourceLocation());
            return varExpr;
        }
        catch (ParseException e) {
            if (raiseError) {
                throw e;
            }
            return null;
        }
    }
}

