/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.ondisk;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.utils.TupleUtils;
import org.apache.hyracks.storage.am.btree.frames.BTreeLeafFrameType;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.DiskBTree;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.btree.util.BTreeUtils;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IPageManager;
import org.apache.hyracks.storage.am.common.api.IPageManagerFactory;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInPlaceInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexAccessor;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexSearcher;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListBuilder;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.InvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.impls.LSMInvertedIndexSearchCursorInitialState;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.FixedSizeElementInvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.FixedSizeElementInvertedListScanCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.OnDiskInvertedIndexOpContext;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.OnDiskInvertedIndexRangeSearchCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.OnDiskInvertedIndexSearchCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedIndexSearchPredicate;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.TOccurrenceSearcher;
import org.apache.hyracks.storage.am.lsm.invertedindex.tuples.TokenKeyPairTuple;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexBulkLoader;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IFIFOPageQueue;
import org.apache.hyracks.storage.common.buffercache.IPageWriteFailureCallback;
import org.apache.hyracks.storage.common.buffercache.PageWriteFailureCallback;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public class OnDiskInvertedIndex
implements IInPlaceInvertedIndex {
    protected final int invListStartPageIdField;
    protected final int invListEndPageIdField;
    protected final int invListStartOffField;
    protected final int invListNumElementsField;
    protected static final ITypeTraits[] btreeValueTypeTraits = new ITypeTraits[4];
    protected DiskBTree btree;
    protected int rootPageId = 0;
    protected IBufferCache bufferCache;
    protected int fileId = -1;
    protected final ITypeTraits[] invListTypeTraits;
    protected final IBinaryComparatorFactory[] invListCmpFactories;
    protected final ITypeTraits[] tokenTypeTraits;
    protected final IBinaryComparatorFactory[] tokenCmpFactories;
    protected final IInvertedListBuilder invListBuilder;
    protected final int numTokenFields;
    protected final int numInvListKeys;
    protected final FileReference invListsFile;
    protected int invListsMaxPageId = -1;
    protected boolean isOpen = false;
    protected boolean wasOpen = false;

    public OnDiskInvertedIndex(IBufferCache bufferCache, IInvertedListBuilder invListBuilder, ITypeTraits[] invListTypeTraits, IBinaryComparatorFactory[] invListCmpFactories, ITypeTraits[] tokenTypeTraits, IBinaryComparatorFactory[] tokenCmpFactories, FileReference btreeFile, FileReference invListsFile, IPageManagerFactory pageManagerFactory) throws HyracksDataException {
        this.bufferCache = bufferCache;
        this.invListBuilder = invListBuilder;
        this.invListTypeTraits = invListTypeTraits;
        this.invListCmpFactories = invListCmpFactories;
        this.tokenTypeTraits = tokenTypeTraits;
        this.tokenCmpFactories = tokenCmpFactories;
        this.btree = BTreeUtils.createDiskBTree((IBufferCache)bufferCache, (ITypeTraits[])OnDiskInvertedIndex.getBTreeTypeTraits(tokenTypeTraits), (IBinaryComparatorFactory[])tokenCmpFactories, (BTreeLeafFrameType)BTreeLeafFrameType.REGULAR_NSM, (FileReference)btreeFile, (IPageManager)pageManagerFactory.createPageManager(bufferCache), (boolean)false);
        this.numTokenFields = this.btree.getComparatorFactories().length;
        this.numInvListKeys = invListCmpFactories.length;
        this.invListsFile = invListsFile;
        this.invListStartPageIdField = this.numTokenFields;
        this.invListEndPageIdField = this.numTokenFields + 1;
        this.invListStartOffField = this.numTokenFields + 2;
        this.invListNumElementsField = this.numTokenFields + 3;
    }

    public synchronized void create() throws HyracksDataException {
        if (this.isOpen) {
            throw new HyracksDataException("Failed to create since index is already open.");
        }
        this.btree.create();
        this.fileId = this.bufferCache.createFile(this.invListsFile);
    }

    public synchronized void activate() throws HyracksDataException {
        if (this.isOpen) {
            throw new HyracksDataException("Failed to activate the index since it is already activated.");
        }
        this.btree.activate();
        if (this.fileId >= 0) {
            this.bufferCache.openFile(this.fileId);
        } else {
            this.fileId = this.bufferCache.openFile(this.invListsFile);
        }
        this.isOpen = true;
        this.wasOpen = true;
    }

    public synchronized void deactivate() throws HyracksDataException {
        if (!this.isOpen && this.wasOpen) {
            throw new HyracksDataException("Failed to deactivate the index since it is already deactivated.");
        }
        this.btree.deactivate();
        this.bufferCache.closeFile(this.fileId);
        this.isOpen = false;
    }

    public synchronized void destroy() throws HyracksDataException {
        if (this.isOpen) {
            throw new HyracksDataException("Failed to destroy since index is already open.");
        }
        this.btree.destroy();
        this.bufferCache.deleteFile(this.invListsFile);
    }

    public synchronized void clear() throws HyracksDataException {
        if (!this.isOpen) {
            throw new HyracksDataException("Failed to clear since index is not open.");
        }
        this.btree.clear();
        this.bufferCache.closeFile(this.fileId);
        this.bufferCache.deleteFile(this.fileId);
        this.fileId = this.bufferCache.createFile(this.invListsFile);
        this.bufferCache.openFile(this.fileId);
    }

    @Override
    public InvertedListCursor createInvertedListCursor(IHyracksTaskContext ctx) throws HyracksDataException {
        return new FixedSizeElementInvertedListCursor(this.bufferCache, this.fileId, this.invListTypeTraits, ctx);
    }

    @Override
    public InvertedListCursor createInvertedListRangeSearchCursor() throws HyracksDataException {
        return new FixedSizeElementInvertedListScanCursor(this.bufferCache, this.fileId, this.invListTypeTraits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openInvertedListCursor(InvertedListCursor listCursor, ITupleReference searchKey, IIndexOperationContext ictx) throws HyracksDataException {
        OnDiskInvertedIndexOpContext ctx = (OnDiskInvertedIndexOpContext)ictx;
        ctx.getBtreePred().setLowKeyComparator(ctx.getSearchCmp());
        ctx.getBtreePred().setHighKeyComparator(ctx.getSearchCmp());
        ctx.getBtreePred().setLowKey(searchKey, true);
        ctx.getBtreePred().setHighKey(searchKey, true);
        ctx.getBtreeAccessor().search(ctx.getBtreeCursor(), (ISearchPredicate)ctx.getBtreePred());
        try {
            if (ctx.getBtreeCursor().hasNext()) {
                ctx.getBtreeCursor().next();
                this.openInvertedListCursor(ctx.getBtreeCursor().getTuple(), listCursor, ctx);
            } else {
                LSMInvertedIndexSearchCursorInitialState initState = ctx.getCursorInitialState();
                initState.setInvertedListInfo(0, 0, 0, 0);
                listCursor.open(initState, null);
            }
        }
        finally {
            ctx.getBtreeCursor().close();
        }
    }

    public void openInvertedListCursor(ITupleReference btreeTuple, InvertedListCursor listCursor, OnDiskInvertedIndexOpContext opCtx) throws HyracksDataException {
        int startPageId = IntegerPointable.getInteger((byte[])btreeTuple.getFieldData(this.invListStartPageIdField), (int)btreeTuple.getFieldStart(this.invListStartPageIdField));
        int endPageId = IntegerPointable.getInteger((byte[])btreeTuple.getFieldData(this.invListEndPageIdField), (int)btreeTuple.getFieldStart(this.invListEndPageIdField));
        int startOff = IntegerPointable.getInteger((byte[])btreeTuple.getFieldData(this.invListStartOffField), (int)btreeTuple.getFieldStart(this.invListStartOffField));
        int numElements = IntegerPointable.getInteger((byte[])btreeTuple.getFieldData(this.invListNumElementsField), (int)btreeTuple.getFieldStart(this.invListNumElementsField));
        LSMInvertedIndexSearchCursorInitialState initState = opCtx.getCursorInitialState();
        initState.setInvertedListInfo(startPageId, endPageId, startOff, numElements);
        listCursor.open(initState, null);
    }

    public IBufferCache getBufferCache() {
        return this.bufferCache;
    }

    public int getInvListsFileId() {
        return this.fileId;
    }

    public int getInvListsMaxPageId() {
        return this.invListsMaxPageId;
    }

    @Override
    public IBinaryComparatorFactory[] getInvListCmpFactories() {
        return this.invListCmpFactories;
    }

    @Override
    public ITypeTraits[] getInvListTypeTraits() {
        return this.invListTypeTraits;
    }

    public BTree getBTree() {
        return this.btree;
    }

    public FileReference getInvListsFile() {
        return this.invListsFile;
    }

    public OnDiskInvertedIndexAccessor createAccessor(IIndexAccessParameters iap) throws HyracksDataException {
        return new OnDiskInvertedIndexAccessor(this, (IHyracksTaskContext)iap.getParameters().get("HYRACKS_TASK_CONTEXT"));
    }

    public IIndexBulkLoader createBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex) throws HyracksDataException {
        return new OnDiskInvertedIndexBulkLoader(fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex, this.rootPageId);
    }

    public IIndexBulkLoader createMergeBulkLoader(float fillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex) throws HyracksDataException {
        return new OnDiskInvertedIndexMergeBulkLoader(fillFactor, verifyInput, numElementsHint, checkIfEmptyIndex, this.rootPageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() throws HyracksDataException {
        this.btree.validate();
        BTree.BTreeAccessor btreeAccessor = this.btree.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
        try {
            MultiComparator btreeCmp = MultiComparator.create((IBinaryComparatorFactory[])this.btree.getComparatorFactories());
            RangePredicate rangePred = new RangePredicate(null, null, true, true, btreeCmp, btreeCmp);
            IIndexCursor btreeCursor = btreeAccessor.createSearchCursor(false);
            try {
                btreeAccessor.search(btreeCursor, (ISearchPredicate)rangePred);
                try {
                    this.doValidate(btreeCursor);
                }
                finally {
                    btreeCursor.close();
                }
            }
            finally {
                btreeCursor.destroy();
            }
        }
        finally {
            btreeAccessor.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doValidate(IIndexCursor btreeCursor) throws HyracksDataException {
        int[] fieldPermutation = new int[this.tokenTypeTraits.length];
        for (int i = 0; i < this.tokenTypeTraits.length; ++i) {
            fieldPermutation[i] = i;
        }
        PermutingTupleReference tokenTuple = new PermutingTupleReference(fieldPermutation);
        OnDiskInvertedIndexOpContext opCtx = new OnDiskInvertedIndexOpContext((BTree)this.btree);
        ArrayTupleBuilder prevBuilder = new ArrayTupleBuilder(this.invListTypeTraits.length);
        ArrayTupleReference prevTuple = new ArrayTupleReference();
        OnDiskInvertedIndexAccessor invIndexAccessor = this.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
        try {
            InvertedListCursor invListCursor = this.createInvertedListRangeSearchCursor();
            MultiComparator invListCmp = MultiComparator.create((IBinaryComparatorFactory[])this.invListCmpFactories);
            while (btreeCursor.hasNext()) {
                btreeCursor.next();
                tokenTuple.reset(btreeCursor.getTuple());
                this.openInvertedListCursor(invListCursor, (ITupleReference)tokenTuple, (IIndexOperationContext)opCtx);
                invListCursor.prepareLoadPages();
                invListCursor.loadPages();
                try {
                    ITupleReference invListElement;
                    if (invListCursor.hasNext()) {
                        invListCursor.next();
                        invListElement = invListCursor.getTuple();
                        TupleUtils.copyTuple((ArrayTupleBuilder)prevBuilder, (ITupleReference)invListElement, (int)invListElement.getFieldCount());
                        prevTuple.reset(prevBuilder.getFieldEndOffsets(), prevBuilder.getByteArray());
                    }
                    while (invListCursor.hasNext()) {
                        invListCursor.next();
                        invListElement = invListCursor.getTuple();
                        this.validateWithPrevious(invListCmp, invListElement, prevTuple);
                        TupleUtils.copyTuple((ArrayTupleBuilder)prevBuilder, (ITupleReference)invListElement, (int)invListElement.getFieldCount());
                        prevTuple.reset(prevBuilder.getFieldEndOffsets(), prevBuilder.getByteArray());
                    }
                }
                finally {
                    invListCursor.unloadPages();
                    invListCursor.close();
                }
            }
        }
        finally {
            invIndexAccessor.destroy();
        }
    }

    private void validateWithPrevious(MultiComparator invListCmp, ITupleReference invListElement, ArrayTupleReference prevTuple) throws HyracksDataException {
        if (invListCmp.compare(invListElement, (ITupleReference)prevTuple) <= 0) {
            throw new HyracksDataException("Index validation failed.");
        }
    }

    public long getMemoryAllocationSize() {
        return 0L;
    }

    protected static ITypeTraits[] getBTreeTypeTraits(ITypeTraits[] tokenTypeTraits) {
        int i;
        ITypeTraits[] btreeTypeTraits = new ITypeTraits[tokenTypeTraits.length + btreeValueTypeTraits.length];
        for (i = 0; i < tokenTypeTraits.length; ++i) {
            btreeTypeTraits[i] = tokenTypeTraits[i];
        }
        for (i = 0; i < btreeValueTypeTraits.length; ++i) {
            btreeTypeTraits[i + tokenTypeTraits.length] = btreeValueTypeTraits[i];
        }
        return btreeTypeTraits;
    }

    @Override
    public ITypeTraits[] getTokenTypeTraits() {
        return this.tokenTypeTraits;
    }

    @Override
    public IBinaryComparatorFactory[] getTokenCmpFactories() {
        return this.tokenCmpFactories;
    }

    public int getNumOfFilterFields() {
        return 0;
    }

    public synchronized void purge() throws HyracksDataException {
        if (this.isOpen) {
            throw HyracksDataException.create((int)77, (Serializable[])new Serializable[0]);
        }
        this.btree.purge();
        this.bufferCache.purgeHandle(this.fileId);
        this.fileId = -1;
    }

    static {
        OnDiskInvertedIndex.btreeValueTypeTraits[0] = IntegerPointable.TYPE_TRAITS;
        OnDiskInvertedIndex.btreeValueTypeTraits[1] = IntegerPointable.TYPE_TRAITS;
        OnDiskInvertedIndex.btreeValueTypeTraits[2] = IntegerPointable.TYPE_TRAITS;
        OnDiskInvertedIndex.btreeValueTypeTraits[3] = IntegerPointable.TYPE_TRAITS;
    }

    public class OnDiskInvertedIndexAccessor
    implements IInvertedIndexAccessor {
        protected final OnDiskInvertedIndex index;
        protected final IIndexOperationContext opCtx;
        protected final IHyracksTaskContext ctx;
        protected IInvertedIndexSearcher searcher;
        private boolean destroyed = false;

        public OnDiskInvertedIndexAccessor(OnDiskInvertedIndex index, IHyracksTaskContext ctx) throws HyracksDataException {
            this.index = index;
            this.ctx = ctx;
            this.opCtx = new OnDiskInvertedIndexOpContext((BTree)OnDiskInvertedIndex.this.btree);
        }

        public IIndexCursor createSearchCursor(boolean exclusive) throws HyracksDataException {
            if (this.searcher == null) {
                this.searcher = new TOccurrenceSearcher(this.index, this.ctx);
            }
            return new OnDiskInvertedIndexSearchCursor(this.searcher);
        }

        public void search(IIndexCursor cursor, ISearchPredicate searchPred) throws HyracksDataException {
            if (this.searcher == null) {
                this.searcher = new TOccurrenceSearcher(this.index, this.ctx);
            }
            this.searcher.search(cursor, (InvertedIndexSearchPredicate)searchPred, this.opCtx);
        }

        @Override
        public InvertedListCursor createInvertedListCursor() throws HyracksDataException {
            return this.index.createInvertedListCursor(this.ctx);
        }

        @Override
        public void openInvertedListCursor(InvertedListCursor listCursor, ITupleReference searchKey) throws HyracksDataException {
            this.index.openInvertedListCursor(listCursor, searchKey, this.opCtx);
        }

        @Override
        public IIndexCursor createRangeSearchCursor() throws HyracksDataException {
            return new OnDiskInvertedIndexRangeSearchCursor(this.index, this.opCtx);
        }

        @Override
        public void rangeSearch(IIndexCursor cursor, ISearchPredicate searchPred) throws HyracksDataException {
            OnDiskInvertedIndexRangeSearchCursor rangeSearchCursor = (OnDiskInvertedIndexRangeSearchCursor)cursor;
            rangeSearchCursor.open(null, searchPred);
        }

        public void insert(ITupleReference tuple) throws HyracksDataException {
            throw new UnsupportedOperationException("Insert not supported by inverted index.");
        }

        public void update(ITupleReference tuple) throws HyracksDataException {
            throw new UnsupportedOperationException("Update not supported by inverted index.");
        }

        public void delete(ITupleReference tuple) throws HyracksDataException {
            throw new UnsupportedOperationException("Delete not supported by inverted index.");
        }

        public void upsert(ITupleReference tuple) throws HyracksDataException {
            throw new UnsupportedOperationException("Upsert not supported by inverted index.");
        }

        public void destroy() throws HyracksDataException {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
            this.opCtx.destroy();
        }
    }

    public class OnDiskInvertedIndexBulkLoader
    extends AbstractOnDiskInvertedIndexBulkLoader {
        public OnDiskInvertedIndexBulkLoader(float btreeFillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, int startPageId) throws HyracksDataException {
            super(btreeFillFactor, verifyInput, numElementsHint, checkIfEmptyIndex, startPageId);
        }

        public void add(ITupleReference tuple) throws HyracksDataException {
            boolean firstElement;
            boolean startNewList = firstElement = this.btreeTupleBuilder.getSize() == 0;
            if (!firstElement) {
                boolean bl = startNewList = !TupleUtils.equalTuples((ITupleReference)tuple, (ITupleReference)this.lastTuple, (int)OnDiskInvertedIndex.this.numTokenFields);
            }
            if (startNewList) {
                if (!firstElement) {
                    this.insertBTreeTuple();
                }
                this.startNewList(tuple);
                this.copyTokenToBTreeTuple(tuple);
            } else if (this.invListCmp.compare(tuple, (ITupleReference)this.lastTuple, OnDiskInvertedIndex.this.numTokenFields) == 0) {
                return;
            }
            this.appendInvertedList(tuple, OnDiskInvertedIndex.this.numTokenFields);
            if (this.verifyInput) {
                this.verifyTuple(tuple);
            }
            this.saveLastTuple(tuple);
        }
    }

    public class OnDiskInvertedIndexMergeBulkLoader
    extends AbstractOnDiskInvertedIndexBulkLoader {
        public OnDiskInvertedIndexMergeBulkLoader(float btreeFillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, int startPageId) throws HyracksDataException {
            super(btreeFillFactor, verifyInput, numElementsHint, checkIfEmptyIndex, startPageId);
        }

        public void add(ITupleReference tuple) throws HyracksDataException {
            TokenKeyPairTuple pairTuple = (TokenKeyPairTuple)tuple;
            ITupleReference tokenTuple = pairTuple.getTokenTuple();
            ITupleReference keyTuple = pairTuple.getKeyTuple();
            boolean startNewList = pairTuple.isNewToken();
            if (startNewList) {
                if (this.btreeTupleBuilder.getSize() > 0) {
                    this.insertBTreeTuple();
                }
                this.startNewList(tokenTuple);
                this.copyTokenToBTreeTuple(tokenTuple);
            }
            this.appendInvertedList(keyTuple, 0);
            if (this.verifyInput) {
                this.verifyTuple(tuple);
                this.saveLastTuple(tuple);
            }
        }
    }

    public abstract class AbstractOnDiskInvertedIndexBulkLoader
    extends PageWriteFailureCallback
    implements IIndexBulkLoader {
        protected final ArrayTupleBuilder btreeTupleBuilder;
        protected final ArrayTupleReference btreeTupleReference;
        protected final IIndexBulkLoader btreeBulkloader;
        protected int currentInvListStartPageId;
        protected int currentInvListStartOffset;
        protected final ArrayTupleBuilder lastTupleBuilder;
        protected final ArrayTupleReference lastTuple;
        protected int currentPageId;
        protected ICachedPage currentPage;
        protected final MultiComparator invListCmp;
        protected final boolean verifyInput;
        protected final MultiComparator allCmp;
        protected final IFIFOPageQueue queue;

        public AbstractOnDiskInvertedIndexBulkLoader(float btreeFillFactor, boolean verifyInput, long numElementsHint, boolean checkIfEmptyIndex, int startPageId) throws HyracksDataException {
            this.verifyInput = verifyInput;
            this.invListCmp = MultiComparator.create((IBinaryComparatorFactory[])OnDiskInvertedIndex.this.invListCmpFactories);
            this.allCmp = verifyInput ? MultiComparator.create((IBinaryComparatorFactory[][])new IBinaryComparatorFactory[][]{OnDiskInvertedIndex.this.btree.getComparatorFactories(), OnDiskInvertedIndex.this.invListCmpFactories}) : null;
            this.btreeTupleBuilder = new ArrayTupleBuilder(OnDiskInvertedIndex.this.btree.getFieldCount());
            this.btreeTupleReference = new ArrayTupleReference();
            this.lastTupleBuilder = new ArrayTupleBuilder(OnDiskInvertedIndex.this.numTokenFields + OnDiskInvertedIndex.this.numInvListKeys);
            this.lastTuple = new ArrayTupleReference();
            this.btreeBulkloader = OnDiskInvertedIndex.this.btree.createBulkLoader(btreeFillFactor, verifyInput, numElementsHint, checkIfEmptyIndex);
            this.currentPageId = startPageId;
            this.currentPage = OnDiskInvertedIndex.this.bufferCache.confiscatePage(BufferedFileHandle.getDiskPageId((int)OnDiskInvertedIndex.this.fileId, (int)this.currentPageId));
            OnDiskInvertedIndex.this.invListBuilder.setTargetBuffer(this.currentPage.getBuffer().array(), 0);
            this.queue = OnDiskInvertedIndex.this.bufferCache.createFIFOQueue();
        }

        protected void pinNextPage() throws HyracksDataException {
            this.queue.put(this.currentPage, (IPageWriteFailureCallback)this);
            ++this.currentPageId;
            this.currentPage = OnDiskInvertedIndex.this.bufferCache.confiscatePage(BufferedFileHandle.getDiskPageId((int)OnDiskInvertedIndex.this.fileId, (int)this.currentPageId));
        }

        protected void insertBTreeTuple() throws HyracksDataException {
            DataOutput output = this.btreeTupleBuilder.getDataOutput();
            try {
                output.writeInt(this.currentInvListStartPageId);
                this.btreeTupleBuilder.addFieldEndOffset();
                output.writeInt(this.currentPageId);
                this.btreeTupleBuilder.addFieldEndOffset();
                output.writeInt(this.currentInvListStartOffset);
                this.btreeTupleBuilder.addFieldEndOffset();
                output.writeInt(OnDiskInvertedIndex.this.invListBuilder.getListSize());
                this.btreeTupleBuilder.addFieldEndOffset();
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            this.btreeTupleReference.reset(this.btreeTupleBuilder.getFieldEndOffsets(), this.btreeTupleBuilder.getByteArray());
            this.btreeBulkloader.add((ITupleReference)this.btreeTupleReference);
            this.btreeTupleBuilder.reset();
        }

        protected void startNewList(ITupleReference tokenTuple) throws HyracksDataException {
            if (!OnDiskInvertedIndex.this.invListBuilder.startNewList(tokenTuple, OnDiskInvertedIndex.this.numTokenFields)) {
                this.pinNextPage();
                OnDiskInvertedIndex.this.invListBuilder.setTargetBuffer(this.currentPage.getBuffer().array(), 0);
                if (!OnDiskInvertedIndex.this.invListBuilder.startNewList(tokenTuple, OnDiskInvertedIndex.this.numTokenFields)) {
                    throw new IllegalStateException("Failed to create first inverted list.");
                }
            }
            this.currentInvListStartPageId = this.currentPageId;
            this.currentInvListStartOffset = OnDiskInvertedIndex.this.invListBuilder.getPos();
        }

        protected void appendInvertedList(ITupleReference keyTuple, int startField) throws HyracksDataException {
            if (!OnDiskInvertedIndex.this.invListBuilder.appendElement(keyTuple, startField, OnDiskInvertedIndex.this.numInvListKeys)) {
                this.pinNextPage();
                OnDiskInvertedIndex.this.invListBuilder.setTargetBuffer(this.currentPage.getBuffer().array(), 0);
                if (!OnDiskInvertedIndex.this.invListBuilder.appendElement(keyTuple, startField, OnDiskInvertedIndex.this.numInvListKeys)) {
                    throw new IllegalStateException("Failed to append element to inverted list after switching to a new page.");
                }
            }
        }

        protected void verifyTuple(ITupleReference tuple) throws HyracksDataException {
            if (this.lastTupleBuilder.getSize() > 0 && this.allCmp.compare(tuple, (ITupleReference)this.lastTuple) <= 0) {
                HyracksDataException.create((int)46, (Serializable[])new Serializable[0]);
            }
        }

        protected void saveLastTuple(ITupleReference tuple) throws HyracksDataException {
            this.lastTupleBuilder.reset();
            for (int i = 0; i < tuple.getFieldCount(); ++i) {
                this.lastTupleBuilder.addField(tuple.getFieldData(i), tuple.getFieldStart(i), tuple.getFieldLength(i));
            }
            this.lastTuple.reset(this.lastTupleBuilder.getFieldEndOffsets(), this.lastTupleBuilder.getByteArray());
        }

        protected void copyTokenToBTreeTuple(ITupleReference tokenTuple) throws HyracksDataException {
            for (int i = 0; i < OnDiskInvertedIndex.this.numTokenFields; ++i) {
                this.btreeTupleBuilder.addField(tokenTuple.getFieldData(i), tokenTuple.getFieldStart(i), tokenTuple.getFieldLength(i));
            }
        }

        public void end() throws HyracksDataException {
            if (this.btreeTupleBuilder.getSize() != 0) {
                this.insertBTreeTuple();
            }
            this.btreeBulkloader.end();
            if (this.currentPage != null) {
                this.queue.put(this.currentPage, (IPageWriteFailureCallback)this);
            }
            OnDiskInvertedIndex.this.invListsMaxPageId = this.currentPageId;
            OnDiskInvertedIndex.this.bufferCache.finishQueue();
            if (this.hasFailed()) {
                throw HyracksDataException.create((Throwable)this.getFailure());
            }
        }

        public void abort() throws HyracksDataException {
            if (this.btreeBulkloader != null) {
                this.btreeBulkloader.abort();
            }
        }
    }
}

