/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.inmemory;

import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexAccessor;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexSearcher;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.InvertedListCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.inmemory.InMemoryInvertedIndex;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.OnDiskInvertedIndexSearchCursor;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedIndexSearchPredicate;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.TOccurrenceSearcher;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchPredicate;

public class InMemoryInvertedIndexAccessor
implements IInvertedIndexAccessor {
    protected final IHyracksTaskContext ctx;
    protected IInvertedIndexSearcher searcher;
    protected IIndexOperationContext opCtx;
    protected InMemoryInvertedIndex index;
    protected BTree.BTreeAccessor btreeAccessor;
    private boolean destroyed = false;

    public InMemoryInvertedIndexAccessor(InMemoryInvertedIndex index, IIndexOperationContext opCtx, IHyracksTaskContext ctx) throws HyracksDataException {
        this.ctx = ctx;
        this.opCtx = opCtx;
        this.index = index;
        this.searcher = null;
        this.btreeAccessor = index.getBTree().createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
    }

    public void insert(ITupleReference tuple) throws HyracksDataException {
        this.opCtx.setOperation(IndexOperation.INSERT);
        this.index.insert(tuple, this.btreeAccessor, this.opCtx);
    }

    public void delete(ITupleReference tuple) throws HyracksDataException {
        this.opCtx.setOperation(IndexOperation.DELETE);
        this.index.delete(tuple, this.btreeAccessor, this.opCtx);
    }

    public IIndexCursor createSearchCursor(boolean exclusive) throws HyracksDataException {
        if (this.searcher == null) {
            this.searcher = this.createSearcher();
        }
        return new OnDiskInvertedIndexSearchCursor(this.searcher);
    }

    public void search(IIndexCursor cursor, ISearchPredicate searchPred) throws HyracksDataException {
        if (this.searcher == null) {
            this.searcher = this.createSearcher();
        }
        this.searcher.search(cursor, (InvertedIndexSearchPredicate)searchPred, this.opCtx);
    }

    @Override
    public InvertedListCursor createInvertedListCursor() {
        return this.index.createInvertedListCursor(this.ctx);
    }

    @Override
    public void openInvertedListCursor(InvertedListCursor listCursor, ITupleReference searchKey) throws HyracksDataException {
        this.index.openInvertedListCursor(listCursor, searchKey, this.opCtx);
    }

    @Override
    public IIndexCursor createRangeSearchCursor() {
        IBTreeLeafFrame leafFrame = (IBTreeLeafFrame)this.index.getBTree().getLeafFrameFactory().createFrame();
        return new BTreeRangeSearchCursor(leafFrame, false);
    }

    @Override
    public void rangeSearch(IIndexCursor cursor, ISearchPredicate searchPred) throws HyracksDataException {
        this.btreeAccessor.search(cursor, searchPred);
    }

    public BTree.BTreeAccessor getBTreeAccessor() {
        return this.btreeAccessor;
    }

    public void update(ITupleReference tuple) throws HyracksDataException {
        throw new UnsupportedOperationException("Update not supported by in-memory inverted index.");
    }

    public void upsert(ITupleReference tuple) throws HyracksDataException {
        throw new UnsupportedOperationException("Upsert not supported by in-memory inverted index.");
    }

    protected IInvertedIndexSearcher createSearcher() throws HyracksDataException {
        if (this.ctx != null) {
            return new TOccurrenceSearcher(this.index, this.ctx);
        }
        return null;
    }

    public void destroy() throws HyracksDataException {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        this.doDestroy();
    }

    private void doDestroy() throws HyracksDataException {
        try {
            this.btreeAccessor.destroy();
        }
        finally {
            this.opCtx.destroy();
        }
    }
}

