/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.std.NestedTupleSourceRuntimeFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;

public class NestedTupleSourcePOperator
extends AbstractPhysicalOperator {
    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.NESTED_TUPLE_SOURCE;
    }

    @Override
    public boolean isMicroOperator() {
        return true;
    }

    @Override
    public void computeDeliveredProperties(ILogicalOperator op, IOptimizationContext context) {
        Mutable<ILogicalOperator> dataSource = ((NestedTupleSourceOperator)op).getDataSourceReference();
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)((ILogicalOperator)dataSource.getValue()).getInputs().get(0).getValue();
        IPhysicalPropertiesVector inheritedProps = op2.getDeliveredPhysicalProperties();
        AbstractLogicalOperator parent = (AbstractLogicalOperator)dataSource.getValue();
        if (parent.getOperatorTag() != LogicalOperatorTag.GROUP) {
            this.deliveredProperties = inheritedProps.clone();
            return;
        }
        GroupByOperator gby = (GroupByOperator)parent;
        List<ILocalStructuralProperty> originalLocalProperties = inheritedProps.getLocalProperties();
        ArrayList<ILocalStructuralProperty> newLocalProperties = null;
        if (originalLocalProperties != null) {
            newLocalProperties = new ArrayList<ILocalStructuralProperty>();
            for (ILocalStructuralProperty lsp : originalLocalProperties) {
                ILocalStructuralProperty groupLocalLsp = lsp.regardToGroup(gby.getGbyVarList());
                if (groupLocalLsp == null) continue;
                newLocalProperties.add(groupLocalLsp);
            }
            newLocalProperties.addAll(originalLocalProperties);
        }
        this.deliveredProperties = new StructuralPropertiesVector(inheritedProps.getPartitioningProperty(), newLocalProperties);
    }

    @Override
    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator op, IPhysicalPropertiesVector reqdByParent, IOptimizationContext context) {
        return null;
    }

    @Override
    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        propagatedSchema.addAllVariables(outerPlanSchema);
        NestedTupleSourceRuntimeFactory runtime = new NestedTupleSourceRuntimeFactory();
        RecordDescriptor recDesc = JobGenHelper.mkRecordDescriptor(context.getTypeEnvironment(op), propagatedSchema, context);
        builder.contributeMicroOperator(op, (IPushRuntimeFactory)runtime, recDesc);
    }

    @Override
    public boolean expensiveThanMaterialization() {
        return false;
    }
}

