/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.aggreg;

import java.nio.ByteBuffer;
import org.apache.hyracks.algebricks.runtime.base.AlgebricksPipeline;
import org.apache.hyracks.algebricks.runtime.base.EnforcePushRuntime;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntime;
import org.apache.hyracks.algebricks.runtime.base.IPushRuntimeFactory;
import org.apache.hyracks.algebricks.runtime.operators.std.NestedTupleSourceRuntimeFactory;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobFlag;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.std.group.AbstractAccumulatingAggregatorDescriptorFactory;
import org.apache.hyracks.dataflow.std.group.AggregateState;
import org.apache.hyracks.dataflow.std.group.IAggregatorDescriptor;

public class NestedPlansAccumulatingAggregatorFactory
extends AbstractAccumulatingAggregatorDescriptorFactory {
    private static final long serialVersionUID = 1L;
    private AlgebricksPipeline[] subplans;
    private int[] keyFieldIdx;
    private int[] decorFieldIdx;

    public NestedPlansAccumulatingAggregatorFactory(AlgebricksPipeline[] subplans, int[] keyFieldIdx, int[] decorFieldIdx) {
        this.subplans = subplans;
        this.keyFieldIdx = keyFieldIdx;
        this.decorFieldIdx = decorFieldIdx;
    }

    public IAggregatorDescriptor createAggregator(IHyracksTaskContext ctx, RecordDescriptor inRecordDesc, RecordDescriptor outRecordDescriptor, int[] keys, int[] partialKeys) throws HyracksDataException {
        final AggregatorOutput outputWriter = new AggregatorOutput(this.subplans, this.keyFieldIdx.length, this.decorFieldIdx.length);
        final NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime[] pipelines = new NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime[this.subplans.length];
        for (int i = 0; i < this.subplans.length; ++i) {
            pipelines[i] = (NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime)this.assemblePipeline(this.subplans[i], outputWriter, ctx);
        }
        return new IAggregatorDescriptor(){

            public void init(ArrayTupleBuilder tupleBuilder, IFrameTupleAccessor accessor, int tIndex, AggregateState state) throws HyracksDataException {
                int i;
                ArrayTupleBuilder tb = outputWriter.getTupleBuilder();
                tb.reset();
                for (i = 0; i < NestedPlansAccumulatingAggregatorFactory.this.keyFieldIdx.length; ++i) {
                    tb.addField(accessor, tIndex, NestedPlansAccumulatingAggregatorFactory.this.keyFieldIdx[i]);
                }
                for (i = 0; i < NestedPlansAccumulatingAggregatorFactory.this.decorFieldIdx.length; ++i) {
                    tb.addField(accessor, tIndex, NestedPlansAccumulatingAggregatorFactory.this.decorFieldIdx[i]);
                }
                for (i = 0; i < pipelines.length; ++i) {
                    pipelines[i].open();
                }
                for (i = 0; i < pipelines.length; ++i) {
                    pipelines[i].writeTuple(accessor.getBuffer(), tIndex);
                }
            }

            public void aggregate(IFrameTupleAccessor accessor, int tIndex, IFrameTupleAccessor stateAccessor, int stateTupleIndex, AggregateState state) throws HyracksDataException {
                for (int i = 0; i < pipelines.length; ++i) {
                    pipelines[i].writeTuple(accessor.getBuffer(), tIndex);
                }
            }

            public boolean outputFinalResult(ArrayTupleBuilder tupleBuilder, IFrameTupleAccessor stateAccessor, int tIndex, AggregateState state) throws HyracksDataException {
                for (int i = 0; i < pipelines.length; ++i) {
                    outputWriter.setInputIdx(i);
                    pipelines[i].close();
                }
                tupleBuilder.reset();
                ArrayTupleBuilder tb = outputWriter.getTupleBuilder();
                byte[] data = tb.getByteArray();
                int[] fieldEnds = tb.getFieldEndOffsets();
                int start = 0;
                for (int i = 0; i < fieldEnds.length; ++i) {
                    if (i > 0) {
                        start = fieldEnds[i - 1];
                    }
                    int offset = fieldEnds[i] - start;
                    tupleBuilder.addField(data, start, offset);
                }
                return true;
            }

            public AggregateState createAggregateStates() {
                return new AggregateState();
            }

            public void reset() {
            }

            public boolean outputPartialResult(ArrayTupleBuilder tupleBuilder, IFrameTupleAccessor accessor, int tIndex, AggregateState state) throws HyracksDataException {
                throw new IllegalStateException("this method should not be called");
            }

            public void close() {
            }
        };
    }

    private IFrameWriter assemblePipeline(AlgebricksPipeline subplan, IFrameWriter writer, IHyracksTaskContext ctx) throws HyracksDataException {
        IFrameWriter start = writer;
        IPushRuntimeFactory[] runtimeFactories = subplan.getRuntimeFactories();
        RecordDescriptor[] recordDescriptors = subplan.getRecordDescriptors();
        boolean enforce = ctx.getJobFlags().contains(JobFlag.ENFORCE_CONTRACT);
        for (int i = runtimeFactories.length - 1; i >= 0; --i) {
            IPushRuntime newRuntime = runtimeFactories[i].createPushRuntime(ctx);
            newRuntime = enforce ? EnforcePushRuntime.enforce(newRuntime) : newRuntime;
            start = enforce ? EnforcePushRuntime.enforce((IFrameWriter)start) : start;
            newRuntime.setOutputFrameWriter(0, start, recordDescriptors[i]);
            if (i > 0) {
                newRuntime.setInputRecordDescriptor(0, recordDescriptors[i - 1]);
            } else {
                newRuntime.setInputRecordDescriptor(0, recordDescriptors[0]);
            }
            start = newRuntime;
        }
        return start;
    }

    private static class AggregatorOutput
    implements IFrameWriter {
        private FrameTupleAccessor[] tAccess;
        private RecordDescriptor[] inputRecDesc;
        private int inputIdx;
        private ArrayTupleBuilder tb;
        private AlgebricksPipeline[] subplans;

        public AggregatorOutput(AlgebricksPipeline[] subplans, int numKeys, int numDecors) {
            int i;
            this.subplans = subplans;
            int totalAggFields = 0;
            this.inputRecDesc = new RecordDescriptor[subplans.length];
            for (i = 0; i < subplans.length; ++i) {
                RecordDescriptor[] rd = subplans[i].getRecordDescriptors();
                this.inputRecDesc[i] = rd[rd.length - 1];
                totalAggFields += subplans[i].getOutputWidth();
            }
            this.tb = new ArrayTupleBuilder(numKeys + numDecors + totalAggFields);
            this.tAccess = new FrameTupleAccessor[this.inputRecDesc.length];
            for (i = 0; i < this.inputRecDesc.length; ++i) {
                this.tAccess[i] = new FrameTupleAccessor(this.inputRecDesc[i]);
            }
        }

        public void open() throws HyracksDataException {
        }

        public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
            int tIndex = 0;
            int w = this.subplans[this.inputIdx].getOutputWidth();
            FrameTupleAccessor accessor = this.tAccess[this.inputIdx];
            accessor.reset(buffer);
            for (int f = 0; f < w; ++f) {
                this.tb.addField((IFrameTupleAccessor)accessor, tIndex, f);
            }
        }

        public void close() throws HyracksDataException {
        }

        public void setInputIdx(int inputIdx) {
            this.inputIdx = inputIdx;
        }

        public ArrayTupleBuilder getTupleBuilder() {
            return this.tb;
        }

        public void fail() throws HyracksDataException {
        }
    }
}

