/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.aggreg;

import java.nio.ByteBuffer;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputOneFramePushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputRuntimeFactory;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class AggregateRuntimeFactory
extends AbstractOneInputOneOutputRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private IAggregateEvaluatorFactory[] aggregFactories;

    public AggregateRuntimeFactory(IAggregateEvaluatorFactory[] aggregFactories) {
        super(null);
        this.aggregFactories = aggregFactories;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("assign [");
        for (int i = 0; i < this.aggregFactories.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.aggregFactories[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public AbstractOneInputOneOutputOneFramePushRuntime createOneOutputPushRuntime(final IHyracksTaskContext ctx) throws HyracksDataException {
        return new AbstractOneInputOneOutputOneFramePushRuntime(){
            private IAggregateEvaluator[] aggregs;
            private IPointable result;
            private ArrayTupleBuilder tupleBuilder;
            private boolean first;
            private boolean isOpen;
            {
                this.aggregs = new IAggregateEvaluator[AggregateRuntimeFactory.this.aggregFactories.length];
                this.result = VoidPointable.FACTORY.createPointable();
                this.tupleBuilder = new ArrayTupleBuilder(this.aggregs.length);
                this.first = true;
                this.isOpen = false;
            }

            public void open() throws HyracksDataException {
                int i;
                if (this.first) {
                    this.first = false;
                    this.initAccessAppendRef(ctx);
                    for (i = 0; i < AggregateRuntimeFactory.this.aggregFactories.length; ++i) {
                        this.aggregs[i] = AggregateRuntimeFactory.this.aggregFactories[i].createAggregateEvaluator(ctx);
                    }
                }
                for (i = 0; i < AggregateRuntimeFactory.this.aggregFactories.length; ++i) {
                    this.aggregs[i].init();
                }
                this.isOpen = true;
                this.writer.open();
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                this.tAccess.reset(buffer);
                int nTuple = this.tAccess.getTupleCount();
                for (int t = 0; t < nTuple; ++t) {
                    this.tRef.reset((IFrameTupleAccessor)this.tAccess, t);
                    this.processTuple(this.tRef);
                }
            }

            @Override
            public void close() throws HyracksDataException {
                if (this.isOpen) {
                    try {
                        this.computeAggregate();
                        this.appendToFrameFromTupleBuilder(this.tupleBuilder);
                    }
                    finally {
                        super.close();
                    }
                }
            }

            private void computeAggregate() throws HyracksDataException {
                this.tupleBuilder.reset();
                for (int f = 0; f < this.aggregs.length; ++f) {
                    this.aggregs[f].finish(this.result);
                    this.tupleBuilder.addField(this.result.getByteArray(), this.result.getStartOffset(), this.result.getLength());
                }
            }

            private void processTuple(FrameTupleReference tupleRef) throws HyracksDataException {
                for (int f = 0; f < this.aggregs.length; ++f) {
                    this.aggregs[f].step((IFrameTupleReference)tupleRef);
                }
            }

            @Override
            public void fail() throws HyracksDataException {
                this.failed = true;
                if (this.isOpen) {
                    this.writer.fail();
                }
            }
        };
    }
}

