/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.aql.statement;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.MetadataException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.external.feed.api.IFeed;
import org.apache.asterix.external.feed.management.FeedConnectionRequest;
import org.apache.asterix.lang.aql.parser.AQLParserFactory;
import org.apache.asterix.lang.common.base.IParser;
import org.apache.asterix.lang.common.base.IParserFactory;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.statement.InsertStatement;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.entities.Feed;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.feeds.FeedMetadataUtil;

public class SubscribeFeedStatement
implements Statement {
    public static final String WAIT_FOR_COMPLETION = "wait-for-completion-feed";
    private static final Integer INSERT_STATEMENT_POS = 3;
    private static final Logger LOGGER = Logger.getLogger(SubscribeFeedStatement.class.getName());
    private final int varCounter;
    private final String[] locations;
    private final FeedConnectionRequest connectionRequest;
    private final IParserFactory parserFactory = new AQLParserFactory();
    private Query query;

    public SubscribeFeedStatement(String[] locations, FeedConnectionRequest subscriptionRequest) {
        this.connectionRequest = subscriptionRequest;
        this.varCounter = 0;
        this.locations = locations;
    }

    public void initialize(MetadataTransactionContext mdTxnCtx) throws MetadataException {
        this.query = new Query(false);
        EntityId sourceFeedId = this.connectionRequest.getReceivingFeedId();
        Feed subscriberFeed = MetadataManager.INSTANCE.getFeed(mdTxnCtx, this.connectionRequest.getReceivingFeedId().getDataverse(), this.connectionRequest.getReceivingFeedId().getEntityName());
        if (subscriberFeed == null) {
            throw new IllegalStateException(" Subscriber feed " + subscriberFeed + " not found.");
        }
        String feedOutputType = this.getOutputType(mdTxnCtx);
        StringBuilder builder = new StringBuilder();
        builder.append("use dataverse " + sourceFeedId.getDataverse() + ";\n");
        builder.append("set import-private-functions '" + Boolean.TRUE + "';\n");
        builder.append("set feed-policy-name '" + this.connectionRequest.getPolicy() + "';\n");
        builder.append("insert into dataset " + this.connectionRequest.getTargetDataset() + " ");
        builder.append(" ( for $x in feed-collect ('" + sourceFeedId.getDataverse() + "','" + sourceFeedId.getEntityName() + "','" + this.connectionRequest.getReceivingFeedId().getEntityName() + "','" + this.connectionRequest.getSubscriptionLocation().name() + "','" + this.connectionRequest.getTargetDataset() + "','" + feedOutputType + "')");
        List functionsToApply = this.connectionRequest.getFunctionsToApply();
        if (functionsToApply != null && functionsToApply.isEmpty()) {
            builder.append(" return $x");
        } else {
            String rValueName = "x";
            String lValueName = "y";
            int variableIndex = 0;
            for (FunctionSignature appliedFunction : functionsToApply) {
                Function function = MetadataManager.INSTANCE.getFunction(mdTxnCtx, appliedFunction);
                ++variableIndex;
                switch (function.getLanguage().toUpperCase()) {
                    case "AQL": {
                        builder.append(" let $" + lValueName + variableIndex + ":=" + function.getName() + "($" + rValueName + ")");
                        rValueName = lValueName + variableIndex;
                        break;
                    }
                    case "JAVA": {
                        builder.append(" let $" + lValueName + variableIndex + ":=" + function.getName() + "($" + rValueName + ")");
                        rValueName = lValueName + variableIndex;
                    }
                }
                builder.append("\n");
            }
            builder.append("return $" + lValueName + variableIndex);
        }
        builder.append(")");
        builder.append(";");
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Connect feed statement translated to\n" + builder.toString());
        }
        IParser parser = this.parserFactory.createParser((Reader)new StringReader(builder.toString()));
        try {
            List statements = parser.parse();
            this.query = ((InsertStatement)statements.get(INSERT_STATEMENT_POS)).getQuery();
        }
        catch (CompilationException pe) {
            throw new MetadataException((Throwable)pe);
        }
    }

    public Query getQuery() {
        return this.query;
    }

    public int getVarCounter() {
        return this.varCounter;
    }

    public byte getKind() {
        return 36;
    }

    public String getPolicy() {
        return this.connectionRequest.getPolicy();
    }

    public FeedConnectionRequest getSubscriptionRequest() {
        return this.connectionRequest;
    }

    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return null;
    }

    public String getDataverseName() {
        return this.connectionRequest.getReceivingFeedId().getDataverse();
    }

    private String getOutputType(MetadataTransactionContext mdTxnCtx) throws MetadataException {
        EntityId feedId = this.connectionRequest.getReceivingFeedId();
        Feed feed = MetadataManager.INSTANCE.getFeed(mdTxnCtx, feedId.getDataverse(), feedId.getEntityName());
        try {
            String outputType = FeedMetadataUtil.getOutputType((IFeed)feed, (Map)feed.getAdapterConfiguration(), (String)"type-name").getTypeName();
            return outputType;
        }
        catch (MetadataException ae) {
            throw new MetadataException((Throwable)ae);
        }
    }

    public String[] getLocations() {
        return this.locations;
    }

    public byte getCategory() {
        return 8;
    }
}

