/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.metadata.MetadataManager;
import org.apache.asterix.metadata.MetadataTransactionContext;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;

public class FunctionUtil {
    public static final String IMPORT_PRIVATE_FUNCTIONS = "import-private-functions";

    public static IFunctionInfo getFunctionInfo(FunctionIdentifier fi) {
        return BuiltinFunctions.getAsterixFunctionInfo((FunctionIdentifier)fi);
    }

    public static IFunctionInfo getFunctionInfo(FunctionSignature fs) {
        return FunctionUtil.getFunctionInfo(new FunctionIdentifier(fs.getNamespace(), fs.getName(), fs.getArity()));
    }

    public static List<FunctionDecl> retrieveUsedStoredFunctions(MetadataProvider metadataProvider, Expression expression, List<FunctionSignature> declaredFunctions, List<FunctionDecl> inputFunctionDecls, IFunctionCollector functionCollector, IFunctionParser functionParser, IFunctionNormalizer functionNormalizer) throws CompilationException {
        List<FunctionDecl> functionDecls;
        ArrayList<FunctionDecl> arrayList = functionDecls = inputFunctionDecls == null ? new ArrayList<FunctionDecl>() : new ArrayList<FunctionDecl>(inputFunctionDecls);
        if (expression == null) {
            return functionDecls;
        }
        String value = (String)metadataProvider.getConfig().get(IMPORT_PRIVATE_FUNCTIONS);
        boolean includePrivateFunctions = value != null ? Boolean.valueOf(value.toLowerCase()) : false;
        Set<FunctionSignature> functionCalls = functionCollector.getFunctionCalls(expression);
        for (FunctionSignature signature : functionCalls) {
            FunctionDecl functionDecl;
            String namespace;
            if (declaredFunctions != null && declaredFunctions.contains(signature)) continue;
            if (signature.getNamespace() == null) {
                signature.setNamespace(metadataProvider.getDefaultDataverseName());
            }
            if (metadataProvider.findDataverse(namespace = signature.getNamespace()) == null && !namespace.equals("asterix")) {
                throw new CompilationException("In function call \"" + namespace + "." + signature.getName() + "(...)\", the dataverse \"" + namespace + "\" cannot be found!");
            }
            Function function = FunctionUtil.lookupUserDefinedFunctionDecl(metadataProvider.getMetadataTxnContext(), signature);
            if (function == null) {
                FunctionSignature normalizedSignature;
                FunctionSignature functionSignature = normalizedSignature = functionNormalizer == null ? signature : functionNormalizer.normalizeBuiltinFunctionSignature(signature);
                if (BuiltinFunctions.isBuiltinCompilerFunction((FunctionSignature)normalizedSignature, (boolean)includePrivateFunctions)) continue;
                StringBuilder messageBuilder = new StringBuilder();
                if (!functionDecls.isEmpty()) {
                    messageBuilder.append("function " + ((FunctionDecl)functionDecls.get(functionDecls.size() - 1)).getSignature() + " depends upon function " + signature + " which is undefined");
                } else {
                    messageBuilder.append("function " + signature + " is not defined");
                }
                throw new CompilationException(messageBuilder.toString());
            }
            if (!function.getLanguage().equalsIgnoreCase("AQL") || (functionDecl = functionParser.getFunctionDecl(function)) == null) continue;
            if (functionDecls.contains(functionDecl)) {
                throw new CompilationException("Recursive invocation " + ((FunctionDecl)functionDecls.get(functionDecls.size() - 1)).getSignature() + " <==> " + functionDecl.getSignature());
            }
            functionDecls.add(functionDecl);
            functionDecls = FunctionUtil.retrieveUsedStoredFunctions(metadataProvider, functionDecl.getFuncBody(), declaredFunctions, functionDecls, functionCollector, functionParser, functionNormalizer);
        }
        return functionDecls;
    }

    private static Function lookupUserDefinedFunctionDecl(MetadataTransactionContext mdTxnCtx, FunctionSignature signature) throws CompilationException {
        if (signature.getNamespace() == null) {
            return null;
        }
        return MetadataManager.INSTANCE.getFunction(mdTxnCtx, signature);
    }

    @FunctionalInterface
    public static interface IFunctionNormalizer {
        public FunctionSignature normalizeBuiltinFunctionSignature(FunctionSignature var1) throws CompilationException;
    }

    @FunctionalInterface
    public static interface IFunctionParser {
        public FunctionDecl getFunctionDecl(Function var1) throws CompilationException;
    }

    @FunctionalInterface
    public static interface IFunctionCollector {
        public Set<FunctionSignature> getFunctionCalls(Expression var1) throws CompilationException;
    }
}

