/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import java.util.Collections;
import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.IReturningStatement;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.commons.lang3.ObjectUtils;

public class Query
implements IReturningStatement {
    private final boolean explain;
    private boolean topLevel = true;
    private Expression body;
    private int varCounter;

    public Query(boolean explain) {
        this.explain = explain;
    }

    public Query(boolean explain, boolean topLevel, Expression body, int varCounter) {
        this.explain = explain;
        this.topLevel = topLevel;
        this.body = body;
        this.varCounter = varCounter;
    }

    @Override
    public Expression getBody() {
        return this.body;
    }

    @Override
    public void setBody(Expression body) {
        this.body = body;
    }

    @Override
    public int getVarCounter() {
        return this.varCounter;
    }

    @Override
    public void setVarCounter(int varCounter) {
        this.varCounter = varCounter;
    }

    @Override
    public List<Expression> getDirectlyEnclosedExpressions() {
        return Collections.singletonList(this.body);
    }

    public void setTopLevel(boolean topLevel) {
        this.topLevel = topLevel;
    }

    @Override
    public boolean isTopLevel() {
        return this.topLevel;
    }

    public boolean isExplain() {
        return this.explain;
    }

    @Override
    public byte getKind() {
        return 13;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.body, this.topLevel, this.explain});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Query)) {
            return false;
        }
        Query target = (Query)object;
        return this.explain == target.explain && ObjectUtils.equals((Object)this.body, (Object)target.body) && this.topLevel == target.topLevel;
    }

    @Override
    public byte getCategory() {
        return 1;
    }

    public String toString() {
        return this.body.toString();
    }
}

