/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.commons.lang3.ObjectUtils;

public class DeleteStatement
implements Statement {
    private VariableExpr vars;
    private Identifier dataverseName;
    private Identifier datasetName;
    private Expression condition;
    private int varCounter;
    private Query rewrittenQuery;

    public DeleteStatement(VariableExpr vars, Identifier dataverseName, Identifier datasetName, Expression condition, int varCounter) {
        this.vars = vars;
        this.dataverseName = dataverseName;
        this.datasetName = datasetName;
        this.condition = condition;
        this.varCounter = varCounter;
    }

    @Override
    public byte getKind() {
        return 4;
    }

    public VariableExpr getVariableExpr() {
        return this.vars;
    }

    public Identifier getDataverseName() {
        return this.dataverseName;
    }

    public Identifier getDatasetName() {
        return this.datasetName;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public int getVarCounter() {
        return this.varCounter;
    }

    public void setQuery(Query rewrittenQuery) {
        this.rewrittenQuery = rewrittenQuery;
    }

    public Query getQuery() {
        return this.rewrittenQuery;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.condition, this.datasetName, this.dataverseName, this.rewrittenQuery, this.vars});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DeleteStatement)) {
            return false;
        }
        DeleteStatement target = (DeleteStatement)object;
        boolean equals = ObjectUtils.equals((Object)this.condition, (Object)target.condition) && ObjectUtils.equals((Object)this.datasetName, (Object)target.datasetName) && ObjectUtils.equals((Object)this.dataverseName, (Object)target.dataverseName);
        return equals && ObjectUtils.equals((Object)this.rewrittenQuery, (Object)target.rewrittenQuery) && ObjectUtils.equals((Object)this.vars, (Object)target.vars);
    }

    @Override
    public byte getCategory() {
        return 2;
    }
}

