/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.expression;

import java.util.List;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.AbstractExpression;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.commons.lang3.ObjectUtils;

public class CallExpr
extends AbstractExpression {
    private FunctionSignature functionSignature;
    private List<Expression> exprList;
    private boolean isBuiltin;

    public CallExpr(FunctionSignature functionSignature, List<Expression> exprList) {
        this.functionSignature = functionSignature;
        this.exprList = exprList;
    }

    public FunctionSignature getFunctionSignature() {
        return this.functionSignature;
    }

    public List<Expression> getExprList() {
        return this.exprList;
    }

    public boolean isBuiltin() {
        return this.isBuiltin;
    }

    @Override
    public Expression.Kind getKind() {
        return Expression.Kind.CALL_EXPRESSION;
    }

    public void setFunctionSignature(FunctionSignature functionSignature) {
        this.functionSignature = functionSignature;
    }

    public void setExprList(List<Expression> exprList) {
        this.exprList = exprList;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public String toString() {
        return "call " + this.functionSignature;
    }

    public int hashCode() {
        return ObjectUtils.hashCodeMulti((Object[])new Object[]{this.exprList, this.functionSignature, this.isBuiltin});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CallExpr)) {
            return false;
        }
        CallExpr target = (CallExpr)object;
        return ObjectUtils.equals(this.exprList, target.exprList) && ObjectUtils.equals((Object)this.functionSignature, (Object)target.functionSignature) && this.isBuiltin == target.isBuiltin;
    }
}

