/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.transaction;

import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.transactions.DatasetId;
import org.apache.asterix.common.transactions.ILogRecord;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.ITransactionManager;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.common.transactions.JobId;
import org.apache.asterix.common.transactions.LogRecord;
import org.apache.asterix.common.utils.TransactionUtil;
import org.apache.asterix.transaction.management.service.transaction.TransactionContext;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponent;

public class TransactionManager
implements ITransactionManager,
ILifeCycleComponent {
    public static final boolean IS_DEBUG_MODE = false;
    private static final Logger LOGGER = Logger.getLogger(TransactionManager.class.getName());
    private final ITransactionSubsystem txnSubsystem;
    private Map<JobId, ITransactionContext> transactionContextRepository = new ConcurrentHashMap<JobId, ITransactionContext>();
    private AtomicInteger maxJobId = new AtomicInteger(0);

    public TransactionManager(ITransactionSubsystem provider) {
        this.txnSubsystem = provider;
    }

    public void abortTransaction(ITransactionContext txnCtx, DatasetId datasetId, int PKHashVal) throws ACIDException {
        if (txnCtx.getTxnState() != 2) {
            txnCtx.setTxnState(2);
        }
        try {
            if (txnCtx.isWriteTxn()) {
                LogRecord logRecord = ((TransactionContext)txnCtx).getLogRecord();
                TransactionUtil.formJobTerminateLogRecord((ITransactionContext)txnCtx, (LogRecord)logRecord, (boolean)false);
                this.txnSubsystem.getLogManager().log((ILogRecord)logRecord);
                this.txnSubsystem.getRecoveryManager().rollbackTransaction(txnCtx);
            }
        }
        catch (Exception ae) {
            String msg = "Could not complete rollback! System is in an inconsistent state";
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe(msg);
            }
            ae.printStackTrace();
            throw new ACIDException(msg, (Throwable)ae);
        }
        finally {
            ((TransactionContext)txnCtx).cleanupForAbort();
            this.txnSubsystem.getLockManager().releaseLocks(txnCtx);
            this.transactionContextRepository.remove(txnCtx.getJobId());
        }
    }

    public ITransactionContext beginTransaction(JobId jobId) throws ACIDException {
        return this.getTransactionContext(jobId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITransactionContext getTransactionContext(JobId jobId, boolean createIfNotExist) throws ACIDException {
        this.setMaxJobId(jobId.getId());
        ITransactionContext txnCtx = this.transactionContextRepository.get(jobId);
        if (txnCtx == null) {
            if (createIfNotExist) {
                TransactionManager transactionManager = this;
                synchronized (transactionManager) {
                    txnCtx = this.transactionContextRepository.get(jobId);
                    if (txnCtx == null) {
                        txnCtx = new TransactionContext(jobId);
                        this.transactionContextRepository.put(jobId, txnCtx);
                    }
                }
            } else {
                throw new ACIDException("TransactionContext of " + jobId + " doesn't exist.");
            }
        }
        return txnCtx;
    }

    public void commitTransaction(ITransactionContext txnCtx, DatasetId datasetId, int PKHashVal) throws ACIDException {
        try {
            if (txnCtx.isWriteTxn()) {
                LogRecord logRecord = ((TransactionContext)txnCtx).getLogRecord();
                TransactionUtil.formJobTerminateLogRecord((ITransactionContext)txnCtx, (LogRecord)logRecord, (boolean)true);
                this.txnSubsystem.getLogManager().log((ILogRecord)logRecord);
            }
        }
        catch (Exception ae) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe(" caused exception in commit !" + txnCtx.getJobId());
            }
            throw ae;
        }
        finally {
            this.txnSubsystem.getLockManager().releaseLocks(txnCtx);
            this.transactionContextRepository.remove(txnCtx.getJobId());
            txnCtx.setTxnState(1);
        }
    }

    public void completedTransaction(ITransactionContext txnContext, DatasetId datasetId, int PKHashVal, boolean success) throws ACIDException {
        if (!success) {
            this.abortTransaction(txnContext, datasetId, PKHashVal);
        } else {
            this.commitTransaction(txnContext, datasetId, PKHashVal);
        }
    }

    public ITransactionSubsystem getTransactionSubsystem() {
        return this.txnSubsystem;
    }

    public void setMaxJobId(int jobId) {
        int maxId = this.maxJobId.get();
        if (jobId > maxId) {
            this.maxJobId.compareAndSet(maxId, jobId);
        }
    }

    public int getMaxJobId() {
        return this.maxJobId.get();
    }

    public void start() {
    }

    public void stop(boolean dumpState, OutputStream os) {
        if (dumpState) {
            this.dumpState(os);
        }
    }

    public void dumpState(OutputStream os) {
        this.dumpTxnContext(os);
    }

    private void dumpTxnContext(OutputStream os) {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("\n>>dump_begin\t>>----- [ConfVars] -----");
            Set<Map.Entry<JobId, ITransactionContext>> entrySet = this.transactionContextRepository.entrySet();
            if (entrySet != null) {
                for (Map.Entry<JobId, ITransactionContext> entry : entrySet) {
                    if (entry == null) continue;
                    JobId jobId = entry.getKey();
                    if (jobId != null) {
                        sb.append("\n" + jobId);
                    } else {
                        sb.append("\nJID:null");
                    }
                    ITransactionContext txnCtx = entry.getValue();
                    if (txnCtx != null) {
                        sb.append(txnCtx.prettyPrint());
                        continue;
                    }
                    sb.append("\nTxnCtx:null");
                }
            }
            sb.append("\n>>dump_end\t>>----- [ConfVars] -----\n");
            os.write(sb.toString().getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

