/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.recovery;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.config.MetadataProperties;
import org.apache.asterix.common.replication.IReplicaResourcesManager;
import org.apache.asterix.common.replication.IReplicationManager;
import org.apache.asterix.common.transactions.CheckpointProperties;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.asterix.transaction.management.service.recovery.AbstractCheckpointManager;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class ReplicationCheckpointManager
extends AbstractCheckpointManager {
    private static final Logger LOGGER = Logger.getLogger(ReplicationCheckpointManager.class.getName());

    public ReplicationCheckpointManager(ITransactionSubsystem txnSubsystem, CheckpointProperties checkpointProperties) {
        super(txnSubsystem, checkpointProperties);
    }

    public synchronized void doSharpCheckpoint() throws HyracksDataException {
        Set deadReplicaIds;
        LOGGER.info("Starting sharp checkpoint...");
        IDatasetLifecycleManager datasetLifecycleManager = this.txnSubsystem.getAsterixAppRuntimeContextProvider().getDatasetLifecycleManager();
        datasetLifecycleManager.flushAllDatasets();
        long minFirstLSN = this.txnSubsystem.getAsterixAppRuntimeContextProvider().getAppContext().isShuttingdown() ? ((deadReplicaIds = this.txnSubsystem.getAsterixAppRuntimeContextProvider().getAppContext().getReplicationManager().getDeadReplicasIds()).isEmpty() ? -1L : this.getDeadReplicasMinFirstLSN(deadReplicaIds)) : this.txnSubsystem.getRecoveryManager().getMinFirstLSN();
        this.capture(minFirstLSN, true);
        if (minFirstLSN == -1L) {
            this.txnSubsystem.getLogManager().renewLogFiles();
        } else {
            this.txnSubsystem.getLogManager().deleteOldLogFiles(minFirstLSN);
        }
        LOGGER.info("Completed sharp checkpoint.");
    }

    public synchronized long tryCheckpoint(long checkpointTargetLSN) throws HyracksDataException {
        boolean checkpointSucceeded;
        LOGGER.info("Attemping soft checkpoint...");
        long minFirstLSN = this.txnSubsystem.getRecoveryManager().getMinFirstLSN();
        boolean bl = checkpointSucceeded = minFirstLSN >= checkpointTargetLSN;
        if (!checkpointSucceeded) {
            IDatasetLifecycleManager datasetLifecycleManager = this.txnSubsystem.getAsterixAppRuntimeContextProvider().getDatasetLifecycleManager();
            datasetLifecycleManager.scheduleAsyncFlushForLaggingDatasets(checkpointTargetLSN);
            IReplicationManager replicationManager = this.txnSubsystem.getAsterixAppRuntimeContextProvider().getAppContext().getReplicationManager();
            try {
                replicationManager.requestFlushLaggingReplicaIndexes(checkpointTargetLSN);
            }
            catch (IOException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
        this.capture(minFirstLSN, false);
        if (checkpointSucceeded) {
            this.txnSubsystem.getLogManager().deleteOldLogFiles(minFirstLSN);
            LOGGER.info(String.format("soft checkpoint succeeded with at LSN(%s)", minFirstLSN));
        }
        return minFirstLSN;
    }

    private long getDeadReplicasMinFirstLSN(Set<String> deadReplicaIds) {
        IReplicaResourcesManager remoteResourcesManager = this.txnSubsystem.getAsterixAppRuntimeContextProvider().getAppContext().getReplicaResourcesManager();
        INcApplicationContext propertiesProvider = this.txnSubsystem.getAsterixAppRuntimeContextProvider().getAppContext();
        MetadataProperties metadataProperties = propertiesProvider.getMetadataProperties();
        PersistentLocalResourceRepository localResourceRepository = (PersistentLocalResourceRepository)this.txnSubsystem.getAsterixAppRuntimeContextProvider().getLocalResourceRepository();
        HashSet<Integer> deadReplicasPartitions = new HashSet<Integer>();
        for (String deadReplicaId : deadReplicaIds) {
            ClusterPartition[] nodePartitons;
            for (ClusterPartition partition : nodePartitons = (ClusterPartition[])metadataProperties.getNodePartitions().get(deadReplicaId)) {
                if (localResourceRepository.getActivePartitions().contains(partition.getPartitionId())) continue;
                deadReplicasPartitions.add(partition.getPartitionId());
            }
        }
        return remoteResourcesManager.getPartitionsMinLSN(deadReplicasPartitions);
    }
}

