/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.unnestingfunctions.std;

import java.io.IOException;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.dataflow.data.nontagged.serde.AOrderedListSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AUnorderedListSerializerDeserializer;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.runtime.unnestingfunctions.base.AbstractUnnestingFunctionDynamicDescriptor;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.base.IUnnestingEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IUnnestingEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class SubsetCollectionDescriptor
extends AbstractUnnestingFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new SubsetCollectionDescriptor();
        }
    };

    public IUnnestingEvaluatorFactory createUnnestingEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IUnnestingEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IUnnestingEvaluator createUnnestingEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
                return new IUnnestingEvaluator(){
                    private IPointable inputVal = new VoidPointable();
                    private IScalarEvaluator evalList;
                    private IScalarEvaluator evalStart;
                    private IScalarEvaluator evalLen;
                    private ArrayBackedValueStorage resultStorage;
                    private int numItems;
                    private int numItemsMax;
                    private int posStart;
                    private int posCrt;
                    private ATypeTag itemTag;
                    private boolean selfDescList;
                    private boolean metUnknown;
                    {
                        this.evalList = args[0].createScalarEvaluator(ctx);
                        this.evalStart = args[1].createScalarEvaluator(ctx);
                        this.evalLen = args[2].createScalarEvaluator(ctx);
                        this.resultStorage = new ArrayBackedValueStorage();
                        this.selfDescList = false;
                        this.metUnknown = false;
                    }

                    public void init(IFrameTupleReference tuple) throws HyracksDataException {
                        try {
                            this.evalStart.evaluate(tuple, this.inputVal);
                            this.posStart = ATypeHierarchy.getIntegerValue((String)SubsetCollectionDescriptor.this.getIdentifier().getName(), (int)0, (byte[])this.inputVal.getByteArray(), (int)this.inputVal.getStartOffset());
                            this.evalLen.evaluate(tuple, this.inputVal);
                            this.numItems = ATypeHierarchy.getIntegerValue((String)SubsetCollectionDescriptor.this.getIdentifier().getName(), (int)1, (byte[])this.inputVal.getByteArray(), (int)this.inputVal.getStartOffset());
                            this.evalList.evaluate(tuple, this.inputVal);
                            byte[] serList = this.inputVal.getByteArray();
                            int offset = this.inputVal.getStartOffset();
                            this.metUnknown = false;
                            byte typeTag = serList[offset];
                            if (typeTag == ATypeTag.SERIALIZED_MISSING_TYPE_TAG || typeTag == ATypeTag.SERIALIZED_NULL_TYPE_TAG) {
                                this.metUnknown = true;
                                return;
                            }
                            if (typeTag != ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG && typeTag != ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG) {
                                throw new RuntimeDataException(12, new Serializable[]{SubsetCollectionDescriptor.this.getIdentifier()});
                            }
                            this.numItemsMax = typeTag == ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG ? AOrderedListSerializerDeserializer.getNumberOfItems((byte[])serList, (int)offset) : AUnorderedListSerializerDeserializer.getNumberOfItems((byte[])serList, (int)offset);
                            this.itemTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(serList[offset + 1]);
                            if (this.itemTag == ATypeTag.ANY) {
                                this.selfDescList = true;
                            }
                            this.posCrt = this.posStart;
                        }
                        catch (IOException e) {
                            throw new HyracksDataException((Throwable)e);
                        }
                    }

                    public boolean step(IPointable result) throws HyracksDataException {
                        if (!this.metUnknown && this.posCrt < this.posStart + this.numItems && this.posCrt < this.numItemsMax) {
                            this.resultStorage.reset();
                            byte[] serList = this.inputVal.getByteArray();
                            int offset = this.inputVal.getStartOffset();
                            int itemLength = 0;
                            try {
                                int itemOffset = AOrderedListSerializerDeserializer.getItemOffset((byte[])serList, (int)offset, (int)this.posCrt);
                                if (this.selfDescList) {
                                    this.itemTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(serList[itemOffset]);
                                }
                                itemLength = NonTaggedFormatUtil.getFieldValueLength((byte[])serList, (int)itemOffset, (ATypeTag)this.itemTag, (boolean)this.selfDescList);
                                if (!this.selfDescList) {
                                    this.resultStorage.getDataOutput().writeByte(this.itemTag.serialize());
                                }
                                this.resultStorage.getDataOutput().write(serList, itemOffset, itemLength + (!this.selfDescList ? 0 : 1));
                            }
                            catch (IOException e) {
                                throw HyracksDataException.create((Throwable)e);
                            }
                            result.set((IValueReference)this.resultStorage);
                            ++this.posCrt;
                            return true;
                        }
                        return false;
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.SUBSET_COLLECTION;
    }
}

