/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators;

import java.io.DataOutput;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.TypeTagUtil;
import org.apache.asterix.runtime.operators.AbstractLSMSecondaryIndexCreationNodePushable;
import org.apache.asterix.runtime.operators.LSMSecondaryUpsertOperatorNodePushable;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.state.IStateObject;
import org.apache.hyracks.api.dataflow.value.IMissingWriter;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.marshalling.BooleanSerializerDeserializer;
import org.apache.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import org.apache.hyracks.dataflow.common.utils.TupleUtils;
import org.apache.hyracks.dataflow.std.base.AbstractStateObject;

public class LSMSecondaryIndexCreationTupleProcessorNodePushable
extends AbstractLSMSecondaryIndexCreationNodePushable {
    private final FrameTupleReference tuple = new FrameTupleReference();
    private final ArrayTupleBuilder prevMatterTupleBuilder;
    private final ArrayTupleReference prevMatterTuple = new ArrayTupleReference();
    private boolean hasPrevMatterTuple;
    private FrameTupleAppender appender;
    private ArrayTupleBuilder tb;
    private DataOutput dos;
    private final IMissingWriter missingWriter;
    private DeletedTupleCounter deletedTupleCounter;

    public LSMSecondaryIndexCreationTupleProcessorNodePushable(IHyracksTaskContext ctx, int partition, RecordDescriptor inputRecDesc, IMissingWriterFactory missingWriterFactory, int numTagFields, int numSecondaryKeys, int numPrimaryKeys, boolean hasBuddyBTree) throws HyracksDataException {
        super(ctx, partition, inputRecDesc, numTagFields, numSecondaryKeys, numPrimaryKeys, hasBuddyBTree);
        this.prevMatterTupleBuilder = new ArrayTupleBuilder(inputRecDesc.getFieldCount());
        this.missingWriter = this.hasBuddyBTree ? missingWriterFactory.createMissingWriter() : null;
    }

    @Override
    public void open() throws HyracksDataException {
        super.open();
        this.deletedTupleCounter = new DeletedTupleCounter(this.ctx.getJobletContext().getJobId(), this.partition);
        this.ctx.setStateObject((IStateObject)this.deletedTupleCounter);
        try {
            this.tb = new ArrayTupleBuilder(this.recordDesc.getFieldCount());
            this.dos = this.tb.getDataOutput();
            this.appender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)this.ctx), true);
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void close() throws HyracksDataException {
        HyracksDataException closeException = null;
        try {
            if (this.appender.getTupleCount() > 0) {
                this.appender.write(this.writer, true);
            }
        }
        catch (HyracksDataException e) {
            closeException = e;
        }
        try {
            this.writer.close();
        }
        catch (HyracksDataException th) {
            if (closeException == null) {
                closeException = th;
            }
            closeException.addSuppressed((Throwable)th);
        }
        if (closeException != null) {
            throw closeException;
        }
    }

    public void flush() throws HyracksDataException {
        this.appender.flush(this.writer);
    }

    @Override
    public void fail() throws HyracksDataException {
        this.writer.fail();
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        int tupleCount = this.accessor.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            try {
                this.tuple.reset((IFrameTupleAccessor)this.accessor, i);
                if (this.isAntiMatterTuple((ITupleReference)this.tuple)) {
                    this.processAntiMatterTuple((ITupleReference)this.tuple);
                    this.hasPrevMatterTuple = false;
                    continue;
                }
                this.processMatterTuple((ITupleReference)this.tuple);
                TupleUtils.copyTuple((ArrayTupleBuilder)this.prevMatterTupleBuilder, (ITupleReference)this.tuple, (int)this.recordDesc.getFieldCount());
                this.prevMatterTuple.reset(this.prevMatterTupleBuilder.getFieldEndOffsets(), this.prevMatterTupleBuilder.getByteArray());
                this.hasPrevMatterTuple = true;
                continue;
            }
            catch (Exception e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }

    private void processMatterTuple(ITupleReference tuple) throws HyracksDataException {
        boolean isOldValueMissing;
        boolean isNewValueMissing = this.isSecondaryKeyMissing(tuple);
        boolean bl = isOldValueMissing = !this.hasPrevMatterTuple || !this.equalPrimaryKeys(tuple, (ITupleReference)this.prevMatterTuple) || this.isSecondaryKeyMissing((ITupleReference)this.prevMatterTuple);
        if (isNewValueMissing && isOldValueMissing) {
            return;
        }
        if (!isOldValueMissing && this.equalSecondaryKeys((ITupleReference)this.prevMatterTuple, tuple)) {
            if (this.hasBuddyBTree) {
                this.writeAntiMatterTuple((ITupleReference)this.prevMatterTuple, this.getComponentPos(tuple));
            }
            this.writeMatterTuple(tuple);
            return;
        }
        if (!isOldValueMissing) {
            this.writeAntiMatterTuple((ITupleReference)this.prevMatterTuple, this.getComponentPos(tuple));
        }
        if (!isNewValueMissing) {
            this.writeMatterTuple(tuple);
        }
    }

    private void processAntiMatterTuple(ITupleReference tuple) throws HyracksDataException {
        boolean isNewValueMissing = this.isSecondaryKeyMissing(tuple);
        if (!isNewValueMissing) {
            this.writeAntiMatterTuple(tuple, this.getComponentPos(tuple));
        }
    }

    private void writeAntiMatterTuple(ITupleReference tuple, int componentPos) throws HyracksDataException {
        int i;
        this.deletedTupleCounter.inc(componentPos);
        this.tb.reset();
        this.tb.addField((ISerializerDeserializer)IntegerSerializerDeserializer.INSTANCE, (Object)componentPos);
        this.tb.addField((ISerializerDeserializer)BooleanSerializerDeserializer.INSTANCE, (Object)true);
        if (this.hasBuddyBTree) {
            for (i = 0; i < this.numSecondaryKeys; ++i) {
                this.missingWriter.writeMissing(this.dos);
                this.tb.addFieldEndOffset();
            }
        } else {
            for (i = this.numTagFields; i < this.numTagFields + this.numSecondaryKeys; ++i) {
                this.tb.addField(tuple.getFieldData(i), tuple.getFieldStart(i), tuple.getFieldLength(i));
            }
        }
        for (i = this.numTagFields + this.numSecondaryKeys; i < this.recordDesc.getFieldCount(); ++i) {
            this.tb.addField(tuple.getFieldData(i), tuple.getFieldStart(i), tuple.getFieldLength(i));
        }
        FrameUtils.appendToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)this.appender, (int[])this.tb.getFieldEndOffsets(), (byte[])this.tb.getByteArray(), (int)0, (int)this.tb.getSize());
    }

    private void writeMatterTuple(ITupleReference tuple) throws HyracksDataException {
        TupleUtils.copyTuple((ArrayTupleBuilder)this.tb, (ITupleReference)tuple, (int)this.recordDesc.getFieldCount());
        FrameUtils.appendToWriter((IFrameWriter)this.writer, (IFrameTupleAppender)this.appender, (int[])this.tb.getFieldEndOffsets(), (byte[])this.tb.getByteArray(), (int)0, (int)this.tb.getSize());
    }

    private boolean isSecondaryKeyMissing(ITupleReference tuple) {
        for (int i = this.numTagFields; i < this.numTagFields + this.numSecondaryKeys; ++i) {
            if (!TypeTagUtil.isType((ITupleReference)tuple, (int)i, (byte)ATypeTag.SERIALIZED_MISSING_TYPE_TAG) && !TypeTagUtil.isType((ITupleReference)tuple, (int)i, (byte)ATypeTag.SERIALIZED_NULL_TYPE_TAG)) continue;
            return true;
        }
        return false;
    }

    private boolean equalPrimaryKeys(ITupleReference tuple1, ITupleReference tuple2) {
        for (int i = this.numTagFields + this.numSecondaryKeys; i < this.numTagFields + this.numPrimaryKeys + this.numSecondaryKeys; ++i) {
            if (this.equalField(tuple1, tuple2, i)) continue;
            return false;
        }
        return true;
    }

    private boolean equalSecondaryKeys(ITupleReference tuple1, ITupleReference tuple2) {
        for (int i = this.numTagFields; i < this.numTagFields + this.numSecondaryKeys; ++i) {
            if (this.equalField(tuple1, tuple2, i)) continue;
            return false;
        }
        return true;
    }

    private boolean equalField(ITupleReference tuple1, ITupleReference tuple2, int fIdx) {
        return LSMSecondaryUpsertOperatorNodePushable.equals(tuple1.getFieldData(fIdx), tuple1.getFieldStart(fIdx), tuple1.getFieldLength(fIdx), tuple2.getFieldData(fIdx), tuple2.getFieldStart(fIdx), tuple2.getFieldLength(fIdx));
    }

    public static class DeletedTupleCounter
    extends AbstractStateObject {
        private final Map<Integer, Integer> map = new HashMap<Integer, Integer>();

        public DeletedTupleCounter(JobId jobId, int partition) {
            super(jobId, (Object)partition);
        }

        public int get(int componentPos) {
            Integer value = this.map.get(componentPos);
            return value != null ? value : 0;
        }

        public void inc(int componentPos) {
            this.map.put(componentPos, this.get(componentPos) + 1);
        }
    }
}

