/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.job.listener;

import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.transactions.DatasetId;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.ITransactionManager;
import org.apache.asterix.common.transactions.JobId;
import org.apache.hyracks.api.context.IHyracksJobletContext;
import org.apache.hyracks.api.job.IJobletEventListener;
import org.apache.hyracks.api.job.IJobletEventListenerFactory;
import org.apache.hyracks.api.job.JobStatus;

public class JobEventListenerFactory
implements IJobletEventListenerFactory {
    private static final long serialVersionUID = 1L;
    private final JobId jobId;
    private final boolean transactionalWrite;

    public JobEventListenerFactory(JobId jobId, boolean transactionalWrite) {
        this.jobId = jobId;
        this.transactionalWrite = transactionalWrite;
    }

    public JobId getJobId() {
        return this.jobId;
    }

    public IJobletEventListener createListener(final IHyracksJobletContext jobletContext) {
        return new IJobletEventListener(){

            public void jobletFinish(JobStatus jobStatus) {
                try {
                    ITransactionManager txnManager = ((INcApplicationContext)jobletContext.getServiceContext().getApplicationContext()).getTransactionSubsystem().getTransactionManager();
                    ITransactionContext txnContext = txnManager.getTransactionContext(JobEventListenerFactory.this.jobId, false);
                    txnContext.setWriteTxn(JobEventListenerFactory.this.transactionalWrite);
                    txnManager.completedTransaction(txnContext, DatasetId.NULL, -1, jobStatus != JobStatus.FAILURE);
                }
                catch (ACIDException e) {
                    throw new Error(e);
                }
            }

            public void jobletStart() {
                try {
                    ((INcApplicationContext)jobletContext.getServiceContext().getApplicationContext()).getTransactionSubsystem().getTransactionManager().getTransactionContext(JobEventListenerFactory.this.jobId, true);
                }
                catch (ACIDException e) {
                    throw new Error(e);
                }
            }
        };
    }
}

