/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.pointables.AListVisitablePointable;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.PointableAllocator;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.runtime.RuntimeRecordTypeInfo;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class RecordRemoveFieldsEvalFactory
implements IScalarEvaluatorFactory {
    private static final long serialVersionUID = 1L;
    private IScalarEvaluatorFactory inputRecordEvalFactory;
    private IScalarEvaluatorFactory removeFieldPathsFactory;
    private ARecordType requiredRecType;
    private ARecordType inputRecType;
    private AOrderedListType inputListType;

    public RecordRemoveFieldsEvalFactory(IScalarEvaluatorFactory inputRecordEvalFactory, IScalarEvaluatorFactory removeFieldPathsFactory, ARecordType requiredRecType, ARecordType inputRecType, AOrderedListType inputListType) {
        this.inputRecordEvalFactory = inputRecordEvalFactory;
        this.removeFieldPathsFactory = removeFieldPathsFactory;
        this.requiredRecType = requiredRecType;
        this.inputRecType = inputRecType;
        this.inputListType = inputListType;
    }

    public IScalarEvaluator createScalarEvaluator(IHyracksTaskContext ctx) throws HyracksDataException {
        PointableAllocator pa = new PointableAllocator();
        IVisitablePointable vp0 = pa.allocateRecordValue((IAType)this.inputRecType);
        IVisitablePointable vp1 = pa.allocateListValue((IAType)this.inputListType);
        VoidPointable inputArg0 = new VoidPointable();
        VoidPointable inputArg1 = new VoidPointable();
        final IScalarEvaluator eval0 = this.inputRecordEvalFactory.createScalarEvaluator(ctx);
        IScalarEvaluator eval1 = this.removeFieldPathsFactory.createScalarEvaluator(ctx);
        return new IScalarEvaluator((IPointable)inputArg0, eval1, (IPointable)inputArg1, vp0, vp1){
            private final RuntimeRecordTypeInfo runtimeRecordTypeInfo = new RuntimeRecordTypeInfo();
            private final List<RecordBuilder> rbStack = new ArrayList<RecordBuilder>();
            private final ArrayBackedValueStorage tabvs = new ArrayBackedValueStorage();
            private final Deque<IVisitablePointable> recordPath = new ArrayDeque<IVisitablePointable>();
            private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
            private DataOutput out = this.resultStorage.getDataOutput();
            final /* synthetic */ IPointable val$inputArg0;
            final /* synthetic */ IScalarEvaluator val$eval1;
            final /* synthetic */ IPointable val$inputArg1;
            final /* synthetic */ IVisitablePointable val$vp0;
            final /* synthetic */ IVisitablePointable val$vp1;
            {
                this.val$inputArg0 = iPointable;
                this.val$eval1 = iScalarEvaluator2;
                this.val$inputArg1 = iPointable2;
                this.val$vp0 = iVisitablePointable;
                this.val$vp1 = iVisitablePointable2;
            }

            public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                this.resultStorage.reset();
                eval0.evaluate(tuple, this.val$inputArg0);
                this.val$eval1.evaluate(tuple, this.val$inputArg1);
                byte inputTypeTag0 = this.val$inputArg0.getByteArray()[this.val$inputArg0.getStartOffset()];
                if (inputTypeTag0 != ATypeTag.SERIALIZED_RECORD_TYPE_TAG) {
                    throw new TypeMismatchException(BuiltinFunctions.REMOVE_FIELDS, (Integer)0, inputTypeTag0, ATypeTag.SERIALIZED_INT32_TYPE_TAG);
                }
                byte inputTypeTag1 = this.val$inputArg1.getByteArray()[this.val$inputArg1.getStartOffset()];
                if (inputTypeTag1 != ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG) {
                    throw new TypeMismatchException(BuiltinFunctions.REMOVE_FIELDS, (Integer)1, inputTypeTag1, ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG);
                }
                this.val$vp0.set((IValueReference)this.val$inputArg0);
                this.val$vp1.set((IValueReference)this.val$inputArg1);
                ARecordVisitablePointable recordPointable = (ARecordVisitablePointable)this.val$vp0;
                AListVisitablePointable listPointable = (AListVisitablePointable)this.val$vp1;
                try {
                    this.recordPath.clear();
                    this.rbStack.clear();
                    this.processRecord(RecordRemoveFieldsEvalFactory.this.requiredRecType, recordPointable, listPointable, 0);
                    this.rbStack.get(0).write(this.out, true);
                }
                catch (IOException | AsterixException e) {
                    throw new HyracksDataException(e);
                }
                result.set((IValueReference)this.resultStorage);
            }

            private void processRecord(ARecordType requiredType, ARecordVisitablePointable srp, AListVisitablePointable inputList, int nestedLevel) throws IOException, AsterixException, HyracksDataException {
                if (this.rbStack.size() < nestedLevel + 1) {
                    this.rbStack.add(new RecordBuilder());
                }
                this.rbStack.get(nestedLevel).reset(requiredType);
                this.rbStack.get(nestedLevel).init();
                List fieldNames = srp.getFieldNames();
                List fieldValues = srp.getFieldValues();
                List fieldTypes = srp.getFieldTypeTags();
                for (int i = 0; i < fieldNames.size(); ++i) {
                    IVisitablePointable subRecFieldName = (IVisitablePointable)fieldNames.get(i);
                    this.recordPath.push(subRecFieldName);
                    if (this.isValidPath(inputList)) {
                        if (requiredType != null && requiredType.getTypeTag() != ATypeTag.ANY) {
                            this.addKeptFieldToSubRecord(requiredType, subRecFieldName, (IVisitablePointable)fieldValues.get(i), (IVisitablePointable)fieldTypes.get(i), inputList, nestedLevel);
                        } else {
                            this.addKeptFieldToSubRecord(DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE, subRecFieldName, (IVisitablePointable)fieldValues.get(i), (IVisitablePointable)fieldTypes.get(i), inputList, nestedLevel);
                        }
                    }
                    this.recordPath.pop();
                }
            }

            private void addKeptFieldToSubRecord(ARecordType requiredType, IVisitablePointable fieldNamePointable, IVisitablePointable fieldValuePointable, IVisitablePointable fieldTypePointable, AListVisitablePointable inputList, int nestedLevel) throws IOException, AsterixException, HyracksDataException {
                this.runtimeRecordTypeInfo.reset(requiredType);
                int pos = this.runtimeRecordTypeInfo.getFieldIndex(fieldNamePointable.getByteArray(), fieldNamePointable.getStartOffset() + 1, fieldNamePointable.getLength() - 1);
                if (pos >= 0) {
                    if (PointableHelper.sameType(ATypeTag.OBJECT, fieldTypePointable)) {
                        this.processRecord((ARecordType)requiredType.getFieldTypes()[pos], (ARecordVisitablePointable)fieldValuePointable, inputList, nestedLevel + 1);
                        this.tabvs.reset();
                        this.rbStack.get(nestedLevel + 1).write(this.tabvs.getDataOutput(), true);
                        this.rbStack.get(nestedLevel).addField(pos, (IValueReference)this.tabvs);
                    } else {
                        this.rbStack.get(nestedLevel).addField(pos, (IValueReference)fieldValuePointable);
                    }
                } else if (PointableHelper.sameType(ATypeTag.OBJECT, fieldTypePointable)) {
                    this.processRecord(null, (ARecordVisitablePointable)fieldValuePointable, inputList, nestedLevel + 1);
                    this.tabvs.reset();
                    this.rbStack.get(nestedLevel + 1).write(this.tabvs.getDataOutput(), true);
                    this.rbStack.get(nestedLevel).addField((IValueReference)fieldNamePointable, (IValueReference)this.tabvs);
                } else {
                    this.rbStack.get(nestedLevel).addField((IValueReference)fieldNamePointable, (IValueReference)fieldValuePointable);
                }
            }

            private boolean isValidPath(AListVisitablePointable inputList) throws HyracksDataException {
                List items = inputList.getItems();
                List typeTags = inputList.getItemTags();
                int pathLen = this.recordPath.size();
                for (int i = 0; i < items.size(); ++i) {
                    IVisitablePointable item = (IVisitablePointable)items.get(i);
                    if (PointableHelper.sameType(ATypeTag.ARRAY, (IVisitablePointable)typeTags.get(i))) {
                        List inputPathItems = ((AListVisitablePointable)item).getItems();
                        if (pathLen != inputPathItems.size()) continue;
                        boolean match = true;
                        Iterator<IVisitablePointable> fpi = this.recordPath.iterator();
                        for (int j = inputPathItems.size() - 1; j >= 0 && (match &= PointableHelper.isEqual((IValueReference)inputPathItems.get(j), (IValueReference)fpi.next())); --j) {
                        }
                        if (!match) continue;
                        return false;
                    }
                    if (!PointableHelper.isEqual((IValueReference)this.recordPath.getFirst(), (IValueReference)item)) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

