/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.builders.AbvsBuilderFactory;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.builders.ListBuilderFactory;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.RecordBuilderFactory;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.pointables.nonvisitor.AListPointable;
import org.apache.asterix.om.pointables.nonvisitor.ARecordPointable;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.container.IObjectFactory;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.asterix.om.util.container.ListObjectPool;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IMutableValueStorage;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public class RecordFieldsUtil {
    private static final AString fieldName = new AString("field-name");
    private static final AString typeName = new AString("field-type");
    private static final AString isOpenName = new AString("is-open");
    private static final AString nestedName = new AString("nested");
    private static final AString listName = new AString("list");
    private IObjectPool<IARecordBuilder, ATypeTag> recordBuilderPool = new ListObjectPool((IObjectFactory)new RecordBuilderFactory());
    private IObjectPool<IAsterixListBuilder, ATypeTag> listBuilderPool = new ListObjectPool((IObjectFactory)new ListBuilderFactory());
    private IObjectPool<IMutableValueStorage, ATypeTag> abvsBuilderPool = new ListObjectPool((IObjectFactory)new AbvsBuilderFactory());
    private IObjectPool<IPointable, ATypeTag> recordPointablePool = new ListObjectPool(ARecordPointable.ALLOCATOR);
    private IObjectPool<IPointable, ATypeTag> listPointablePool = new ListObjectPool(AListPointable.ALLOCATOR);
    private static final AOrderedListType listType = new AOrderedListType((IAType)BuiltinType.ANY, "fields");
    protected final ISerializerDeserializer<AString> stringSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
    protected final ISerializerDeserializer<ABoolean> booleanSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ABOOLEAN);
    private static final ARecordType openType = DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE;

    public void processRecord(ARecordPointable recordAccessor, ARecordType recType, DataOutput out, int level) throws IOException, AsterixException {
        ArrayBackedValueStorage tmpValue;
        IAType fieldType;
        byte tag;
        int i;
        if (level == 0) {
            this.resetPools();
        }
        ArrayBackedValueStorage itemValue = this.getTempBuffer();
        ArrayBackedValueStorage fieldName = this.getTempBuffer();
        OrderedListBuilder orderedListBuilder = this.getOrderedListBuilder();
        orderedListBuilder.reset((AbstractCollectionType)listType);
        IARecordBuilder fieldRecordBuilder = this.getRecordBuilder();
        fieldRecordBuilder.reset(null);
        int schemeFieldCount = recordAccessor.getSchemeFieldCount(recType);
        for (i = 0; i < schemeFieldCount; ++i) {
            itemValue.reset();
            fieldRecordBuilder.init();
            fieldName.reset();
            recordAccessor.getClosedFieldName(recType, i, fieldName.getDataOutput());
            this.addNameField((IValueReference)fieldName, fieldRecordBuilder);
            tag = recordAccessor.getClosedFieldTag(recType, i);
            this.addFieldType(tag, fieldRecordBuilder);
            this.addIsOpenField(false, fieldRecordBuilder);
            if (!(tag != ATypeTag.SERIALIZED_RECORD_TYPE_TAG && tag != ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG && tag != ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG || recordAccessor.isClosedFieldNull(recType, i))) {
                fieldType = recordAccessor.getClosedFieldType(recType, i);
                tmpValue = this.getTempBuffer();
                tmpValue.reset();
                recordAccessor.getClosedFieldValue(recType, i, tmpValue.getDataOutput());
                if (tag == ATypeTag.SERIALIZED_RECORD_TYPE_TAG) {
                    this.addNestedField((IValueReference)tmpValue, fieldType, fieldRecordBuilder, level + 1);
                } else if (tag == ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG || tag == ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG) {
                    this.addListField((IValueReference)tmpValue, fieldType, fieldRecordBuilder, level + 1);
                }
            }
            fieldRecordBuilder.write(itemValue.getDataOutput(), true);
            orderedListBuilder.addItem((IValueReference)itemValue);
        }
        for (i = recordAccessor.getOpenFieldCount(recType) - 1; i >= 0; --i) {
            itemValue.reset();
            fieldRecordBuilder.init();
            fieldName.reset();
            recordAccessor.getOpenFieldName(recType, i, fieldName.getDataOutput());
            this.addNameField((IValueReference)fieldName, fieldRecordBuilder);
            tag = recordAccessor.getOpenFieldTag(recType, i);
            this.addFieldType(tag, fieldRecordBuilder);
            this.addIsOpenField(true, fieldRecordBuilder);
            if (tag == ATypeTag.SERIALIZED_RECORD_TYPE_TAG || tag == ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG || tag == ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG) {
                fieldType = null;
                tmpValue = this.getTempBuffer();
                tmpValue.reset();
                recordAccessor.getOpenFieldValue(recType, i, tmpValue.getDataOutput());
                if (tag == ATypeTag.SERIALIZED_RECORD_TYPE_TAG) {
                    this.addNestedField((IValueReference)tmpValue, fieldType, fieldRecordBuilder, level + 1);
                } else if (tag == ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG || tag == ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG) {
                    this.addListField((IValueReference)tmpValue, fieldType, fieldRecordBuilder, level + 1);
                }
            }
            fieldRecordBuilder.write(itemValue.getDataOutput(), true);
            orderedListBuilder.addItem((IValueReference)itemValue);
        }
        orderedListBuilder.write(out, true);
    }

    public void addNameField(IValueReference nameArg, IARecordBuilder fieldRecordBuilder) throws HyracksDataException, AsterixException {
        ArrayBackedValueStorage fieldAbvs = this.getTempBuffer();
        fieldAbvs.reset();
        this.stringSerde.serialize((Object)fieldName, fieldAbvs.getDataOutput());
        fieldRecordBuilder.addField((IValueReference)fieldAbvs, nameArg);
    }

    public void addFieldType(byte tagId, IARecordBuilder fieldRecordBuilder) throws HyracksDataException, AsterixException {
        ArrayBackedValueStorage fieldAbvs = this.getTempBuffer();
        ArrayBackedValueStorage valueAbvs = this.getTempBuffer();
        fieldAbvs.reset();
        this.stringSerde.serialize((Object)typeName, fieldAbvs.getDataOutput());
        valueAbvs.reset();
        ATypeTag tag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(tagId);
        AMutableString aString = new AMutableString("");
        aString.setValue(tag.toString());
        this.stringSerde.serialize((Object)aString, valueAbvs.getDataOutput());
        fieldRecordBuilder.addField((IValueReference)fieldAbvs, (IValueReference)valueAbvs);
    }

    public void addIsOpenField(boolean isOpen, IARecordBuilder fieldRecordBuilder) throws HyracksDataException, AsterixException {
        ArrayBackedValueStorage fieldAbvs = this.getTempBuffer();
        ArrayBackedValueStorage valueAbvs = this.getTempBuffer();
        fieldAbvs.reset();
        this.stringSerde.serialize((Object)isOpenName, fieldAbvs.getDataOutput());
        valueAbvs.reset();
        if (isOpen) {
            this.booleanSerde.serialize((Object)ABoolean.TRUE, valueAbvs.getDataOutput());
        } else {
            this.booleanSerde.serialize((Object)ABoolean.FALSE, valueAbvs.getDataOutput());
        }
        fieldRecordBuilder.addField((IValueReference)fieldAbvs, (IValueReference)valueAbvs);
    }

    public void addListField(IValueReference listArg, IAType fieldType, IARecordBuilder fieldRecordBuilder, int level) throws AsterixException, IOException {
        ArrayBackedValueStorage fieldAbvs = this.getTempBuffer();
        ArrayBackedValueStorage valueAbvs = this.getTempBuffer();
        fieldAbvs.reset();
        this.stringSerde.serialize((Object)listName, fieldAbvs.getDataOutput());
        valueAbvs.reset();
        this.processListValue(listArg, fieldType, valueAbvs.getDataOutput(), level);
        fieldRecordBuilder.addField((IValueReference)fieldAbvs, (IValueReference)valueAbvs);
    }

    public void addNestedField(IValueReference recordArg, IAType fieldType, IARecordBuilder fieldRecordBuilder, int level) throws IOException, AsterixException {
        ArrayBackedValueStorage fieldAbvs = this.getTempBuffer();
        ArrayBackedValueStorage valueAbvs = this.getTempBuffer();
        fieldAbvs.reset();
        this.stringSerde.serialize((Object)nestedName, fieldAbvs.getDataOutput());
        valueAbvs.reset();
        ARecordType newType = fieldType == null ? openType : (ARecordType)fieldType;
        ARecordPointable recordP = this.getRecordPointable();
        recordP.set(recordArg);
        this.processRecord(recordP, newType, valueAbvs.getDataOutput(), level);
        fieldRecordBuilder.addField((IValueReference)fieldAbvs, (IValueReference)valueAbvs);
    }

    public void processListValue(IValueReference listArg, IAType fieldType, DataOutput out, int level) throws AsterixException, IOException {
        ArrayBackedValueStorage itemValue = this.getTempBuffer();
        IARecordBuilder listRecordBuilder = this.getRecordBuilder();
        AListPointable list = this.getListPointable();
        list.set(listArg);
        OrderedListBuilder innerListBuilder = this.getOrderedListBuilder();
        innerListBuilder.reset((AbstractCollectionType)listType);
        listRecordBuilder.reset(null);
        AbstractCollectionType act = (AbstractCollectionType)fieldType;
        int itemCount = list.getItemCount();
        for (int l = 0; l < itemCount; ++l) {
            itemValue.reset();
            listRecordBuilder.init();
            byte tagId = list.getItemTag(act, l);
            this.addFieldType(tagId, listRecordBuilder);
            if (tagId == ATypeTag.SERIALIZED_RECORD_TYPE_TAG) {
                ArrayBackedValueStorage tmpAbvs = this.getTempBuffer();
                list.getItemValue(act, l, tmpAbvs.getDataOutput());
                this.addNestedField((IValueReference)tmpAbvs, act.getItemType(), listRecordBuilder, level + 1);
            }
            listRecordBuilder.write(itemValue.getDataOutput(), true);
            innerListBuilder.addItem((IValueReference)itemValue);
        }
        innerListBuilder.write(out, true);
    }

    private ARecordPointable getRecordPointable() {
        return (ARecordPointable)this.recordPointablePool.allocate((Object)ATypeTag.OBJECT);
    }

    private AListPointable getListPointable() {
        return (AListPointable)this.listPointablePool.allocate((Object)ATypeTag.ARRAY);
    }

    private IARecordBuilder getRecordBuilder() {
        return (IARecordBuilder)this.recordBuilderPool.allocate((Object)ATypeTag.OBJECT);
    }

    private OrderedListBuilder getOrderedListBuilder() {
        return (OrderedListBuilder)this.listBuilderPool.allocate((Object)ATypeTag.ARRAY);
    }

    private ArrayBackedValueStorage getTempBuffer() {
        return (ArrayBackedValueStorage)this.abvsBuilderPool.allocate((Object)ATypeTag.BINARY);
    }

    private void resetPools() {
        this.abvsBuilderPool.reset();
        this.listBuilderPool.reset();
        this.recordBuilderPool.reset();
        this.recordPointablePool.reset();
        this.listPointablePool.reset();
    }
}

