/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions.records;

import java.io.DataOutput;
import java.io.Serializable;
import java.util.List;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.dataflow.data.nontagged.comparators.ListItemBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.hash.ListItemBinaryHashFunctionFactory;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.pointables.AListVisitablePointable;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.PointableAllocator;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.runtime.RuntimeRecordTypeInfo;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.functions.BinaryHashMap;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunction;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IMutableValueStorage;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.data.std.util.BinaryEntry;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class RecordAddFieldsDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new RecordAddFieldsDescriptor();
        }
    };
    private static final long serialVersionUID = 1L;
    private ARecordType outRecType;
    private ARecordType inRecType;
    private AOrderedListType inListType;
    private IAType inputFieldListItemType;

    public void setImmutableStates(Object ... states) {
        this.outRecType = TypeComputeUtils.extractRecordType((IAType)((IAType)states[0]));
        this.inRecType = TypeComputeUtils.extractRecordType((IAType)((IAType)states[1]));
        this.inListType = TypeComputeUtils.extractOrderedListType((IAType)((IAType)states[2]));
        this.inputFieldListItemType = this.inListType.getItemType();
        if (this.inputFieldListItemType == null || this.inputFieldListItemType.getTypeTag() == ATypeTag.ANY) {
            this.inputFieldListItemType = DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE;
        }
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IHyracksTaskContext ctx) throws HyracksDataException {
                final PointableAllocator allocator = new PointableAllocator();
                IVisitablePointable vp0 = allocator.allocateRecordValue((IAType)RecordAddFieldsDescriptor.this.inRecType);
                IVisitablePointable vp1 = allocator.allocateListValue((IAType)RecordAddFieldsDescriptor.this.inListType);
                VoidPointable argPtr0 = new VoidPointable();
                VoidPointable argPtr1 = new VoidPointable();
                final IScalarEvaluator eval0 = args[0].createScalarEvaluator(ctx);
                IScalarEvaluator eval1 = args[1].createScalarEvaluator(ctx);
                ArrayBackedValueStorage fieldNamePointable = new ArrayBackedValueStorage();
                ArrayBackedValueStorage fieldValuePointer = new ArrayBackedValueStorage();
                PointableHelper pointableHelper = new PointableHelper();
                try {
                    pointableHelper.serializeString("field-name", (IMutableValueStorage)fieldNamePointable, true);
                    pointableHelper.serializeString("field-value", (IMutableValueStorage)fieldValuePointer, true);
                }
                catch (AsterixException e) {
                    throw new HyracksDataException((Throwable)e);
                }
                return new IScalarEvaluator((IPointable)argPtr0, eval1, (IPointable)argPtr1, vp0, vp1, fieldNamePointable){
                    public static final int TABLE_FRAME_SIZE = 32768;
                    public static final int TABLE_SIZE = 100;
                    private final RecordBuilder recordBuilder = new RecordBuilder();
                    private final RuntimeRecordTypeInfo requiredRecordTypeInfo = new RuntimeRecordTypeInfo();
                    private final IBinaryHashFunction putHashFunc = ListItemBinaryHashFunctionFactory.INSTANCE.createBinaryHashFunction();
                    private final IBinaryHashFunction getHashFunc = ListItemBinaryHashFunctionFactory.INSTANCE.createBinaryHashFunction();
                    private final BinaryEntry keyEntry = new BinaryEntry();
                    private final BinaryEntry valEntry = new BinaryEntry();
                    private final IVisitablePointable tempValReference = allocator.allocateEmpty();
                    private final IBinaryComparator cmp = ListItemBinaryComparatorFactory.INSTANCE.createBinaryComparator();
                    private BinaryHashMap hashMap = new BinaryHashMap(100, 32768, this.putHashFunc, this.getHashFunc, this.cmp);
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput out = this.resultStorage.getDataOutput();
                    final /* synthetic */ IPointable val$argPtr0;
                    final /* synthetic */ IScalarEvaluator val$eval1;
                    final /* synthetic */ IPointable val$argPtr1;
                    final /* synthetic */ IVisitablePointable val$vp0;
                    final /* synthetic */ IVisitablePointable val$vp1;
                    final /* synthetic */ ArrayBackedValueStorage val$fieldNamePointable;
                    {
                        this.val$argPtr0 = iPointable;
                        this.val$eval1 = iScalarEvaluator2;
                        this.val$argPtr1 = iPointable2;
                        this.val$vp0 = iVisitablePointable;
                        this.val$vp1 = iVisitablePointable2;
                        this.val$fieldNamePointable = arrayBackedValueStorage;
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        this.recordBuilder.reset(RecordAddFieldsDescriptor.this.outRecType);
                        this.requiredRecordTypeInfo.reset(RecordAddFieldsDescriptor.this.outRecType);
                        eval0.evaluate(tuple, this.val$argPtr0);
                        this.val$eval1.evaluate(tuple, this.val$argPtr1);
                        byte typeTag0 = this.val$argPtr0.getByteArray()[this.val$argPtr0.getStartOffset()];
                        if (typeTag0 != ATypeTag.SERIALIZED_RECORD_TYPE_TAG) {
                            throw new TypeMismatchException(RecordAddFieldsDescriptor.this.getIdentifier(), (Integer)0, typeTag0, ATypeTag.SERIALIZED_RECORD_TYPE_TAG);
                        }
                        byte typeTag1 = this.val$argPtr1.getByteArray()[this.val$argPtr1.getStartOffset()];
                        if (typeTag1 != ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG) {
                            throw new TypeMismatchException(RecordAddFieldsDescriptor.this.getIdentifier(), (Integer)1, typeTag1, ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG);
                        }
                        this.val$vp0.set((IValueReference)this.val$argPtr0);
                        this.val$vp1.set((IValueReference)this.val$argPtr1);
                        ARecordVisitablePointable recordPointable = (ARecordVisitablePointable)this.val$vp0;
                        AListVisitablePointable listPointable = (AListVisitablePointable)this.val$vp1;
                        int tableSize = recordPointable.getFieldNames().size() + listPointable.getItems().size();
                        if (this.hashMap == null || tableSize > 100) {
                            this.hashMap = new BinaryHashMap(tableSize, 32768, this.putHashFunc, this.getHashFunc, this.cmp);
                        } else {
                            this.hashMap.clear();
                        }
                        this.addFields(recordPointable, listPointable);
                        this.recordBuilder.write(this.out, true);
                        result.set((IValueReference)this.resultStorage);
                    }

                    private void addFields(ARecordVisitablePointable inputRecordPointer, AListVisitablePointable listPointable) throws HyracksDataException {
                        List inputRecordFieldNames = inputRecordPointer.getFieldNames();
                        List inputRecordFieldValues = inputRecordPointer.getFieldValues();
                        List inputFields = listPointable.getItems();
                        IVisitablePointable namePointable = null;
                        IVisitablePointable valuePointable = null;
                        int numInputRecordFields = inputRecordFieldNames.size();
                        try {
                            int i;
                            for (i = 0; i < numInputRecordFields; ++i) {
                                IVisitablePointable fnp = (IVisitablePointable)inputRecordFieldNames.get(i);
                                IVisitablePointable fvp = (IVisitablePointable)inputRecordFieldValues.get(i);
                                int pos = this.requiredRecordTypeInfo.getFieldIndex(fnp.getByteArray(), fnp.getStartOffset() + 1, fnp.getLength() - 1);
                                if (pos >= 0) {
                                    this.recordBuilder.addField(pos, (IValueReference)fvp);
                                } else {
                                    this.recordBuilder.addField((IValueReference)fnp, (IValueReference)fvp);
                                }
                                this.keyEntry.set(fnp.getByteArray(), fnp.getStartOffset(), fnp.getLength());
                                this.valEntry.set(fvp.getByteArray(), fvp.getStartOffset(), fvp.getLength());
                                this.hashMap.put(this.keyEntry, this.valEntry);
                            }
                            for (i = 0; i < inputFields.size(); ++i) {
                                if (!PointableHelper.sameType(ATypeTag.OBJECT, (IVisitablePointable)inputFields.get(i))) {
                                    throw new AsterixException("Expected list of record, got " + PointableHelper.getTypeTag((IValueReference)inputFields.get(i)));
                                }
                                List names = ((ARecordVisitablePointable)inputFields.get(i)).getFieldNames();
                                List values = ((ARecordVisitablePointable)inputFields.get(i)).getFieldValues();
                                for (int j = 0; j < names.size(); ++j) {
                                    IVisitablePointable fieldName = (IVisitablePointable)names.get(j);
                                    if (PointableHelper.byteArrayEqual((IValueReference)this.val$fieldNamePointable, (IValueReference)fieldName)) {
                                        namePointable = (IVisitablePointable)values.get(j);
                                        continue;
                                    }
                                    valuePointable = (IVisitablePointable)values.get(j);
                                }
                                if (namePointable == null || valuePointable == null) {
                                    throw new InvalidDataFormatException(RecordAddFieldsDescriptor.this.getIdentifier(), "fields to be added");
                                }
                                int pos = this.requiredRecordTypeInfo.getFieldIndex(namePointable.getByteArray(), namePointable.getStartOffset() + 1, namePointable.getLength() - 1);
                                this.keyEntry.set(namePointable.getByteArray(), namePointable.getStartOffset(), namePointable.getLength());
                                BinaryEntry entry = this.hashMap.get(this.keyEntry);
                                if (entry != null) {
                                    this.tempValReference.set(entry.getBuf(), entry.getOffset(), entry.getLength());
                                    if (PointableHelper.byteArrayEqual((IValueReference)valuePointable, (IValueReference)this.tempValReference)) continue;
                                    throw new RuntimeDataException(13, new Serializable[]{RecordAddFieldsDescriptor.this.getIdentifier()});
                                }
                                if (pos > -1) {
                                    this.recordBuilder.addField(pos, (IValueReference)valuePointable);
                                } else {
                                    this.recordBuilder.addField((IValueReference)namePointable, (IValueReference)valuePointable);
                                }
                                this.valEntry.set(valuePointable.getByteArray(), valuePointable.getStartOffset(), valuePointable.getLength());
                                this.hashMap.put(this.keyEntry, this.valEntry);
                            }
                        }
                        catch (AsterixException e) {
                            throw new HyracksDataException((Throwable)e);
                        }
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ADD_FIELDS;
    }
}

