/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.functions.StringSplitDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.string.UTF8StringUtil;

class StringSplitDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private final IScalarEvaluator stringEval;
    private final IScalarEvaluator patternEval;
    private final IPointable argString;
    private final IPointable argPattern;
    private final UTF8StringPointable argStrPtr;
    private final UTF8StringPointable argPatternPtr;
    private final ArrayBackedValueStorage itemStorge;
    private final DataOutput itemOut;
    private final byte[] tempLengthArray;
    private final AOrderedListType intListType;
    private final OrderedListBuilder listBuilder;
    private final ArrayBackedValueStorage resultStorage;
    private final DataOutput out;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ StringSplitDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    StringSplitDescriptor$_EvaluatorGen(StringSplitDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
        this.stringEval = this.this$1.val$args[0].createScalarEvaluator(this.val$ctx);
        this.patternEval = this.this$1.val$args[1].createScalarEvaluator(this.val$ctx);
        this.argString = new VoidPointable();
        this.argPattern = new VoidPointable();
        this.argStrPtr = new UTF8StringPointable();
        this.argPatternPtr = new UTF8StringPointable();
        this.itemStorge = new ArrayBackedValueStorage();
        this.itemOut = this.itemStorge.getDataOutput();
        this.tempLengthArray = new byte[5];
        this.intListType = new AOrderedListType((IAType)BuiltinType.ASTRING, null);
        this.listBuilder = new OrderedListBuilder();
        this.resultStorage = new ArrayBackedValueStorage();
        this.out = this.resultStorage.getDataOutput();
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        try {
            int nextMatchStart;
            this.resultStorage.reset();
            this.stringEval.evaluate(tuple, this.argString);
            if (this.typeChecker.isMissing(this.argString, result)) {
                return;
            }
            this.patternEval.evaluate(tuple, this.argPattern);
            if (this.typeChecker.isMissing(this.argPattern, result)) {
                return;
            }
            if (this.typeChecker.isNull(result)) {
                return;
            }
            byte[] srcString = this.argString.getByteArray();
            int srcOffset = this.argString.getStartOffset();
            int srcLen = this.argString.getLength();
            if (srcString[srcOffset] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                throw new TypeMismatchException(this.this$1.this$0.getIdentifier(), (Integer)0, srcString[srcOffset], ATypeTag.SERIALIZED_STRING_TYPE_TAG);
            }
            byte[] patternString = this.argPattern.getByteArray();
            int patternOffset = this.argPattern.getStartOffset();
            int patternLen = this.argPattern.getLength();
            if (patternString[patternOffset] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                throw new TypeMismatchException(this.this$1.this$0.getIdentifier(), (Integer)1, patternString[patternOffset], ATypeTag.SERIALIZED_STRING_TYPE_TAG);
            }
            this.argStrPtr.set(srcString, srcOffset + 1, srcLen - 1);
            this.argPatternPtr.set(patternString, patternOffset + 1, patternLen - 1);
            int inputStringLen = UTF8StringUtil.getUTFLength((byte[])srcString, (int)(srcOffset + 1));
            int inputStringStart = srcOffset + 1 + UTF8StringUtil.getNumBytesToStoreLength((int)inputStringLen);
            int inputPatternLen = UTF8StringUtil.getUTFLength((byte[])patternString, (int)(patternOffset + 1));
            boolean emptyStringPattern = inputPatternLen == 0;
            this.listBuilder.reset((AbstractCollectionType)this.intListType);
            int itemStrStart = 0;
            while (itemStrStart < inputStringLen && (nextMatchStart = UTF8StringPointable.find((UTF8StringPointable)this.argStrPtr, (UTF8StringPointable)this.argPatternPtr, (boolean)false, (int)itemStrStart)) >= 0) {
                this.addItemString(srcString, inputStringStart, itemStrStart, emptyStringPattern ? nextMatchStart + 1 : nextMatchStart);
                itemStrStart = nextMatchStart + (emptyStringPattern ? 1 : inputPatternLen);
            }
            if (!emptyStringPattern) {
                this.addItemString(srcString, inputStringStart, itemStrStart, inputStringLen);
            }
            this.listBuilder.write(this.out, true);
            result.set((IValueReference)this.resultStorage);
        }
        catch (IOException e1) {
            throw new HyracksDataException((Throwable)e1);
        }
    }

    private void addItemString(byte[] srcString, int inputStringStart, int itemStartOffset, int nextMatchStart) throws IOException {
        int itemLen = nextMatchStart - itemStartOffset;
        int cbytes = UTF8StringUtil.encodeUTF8Length((int)itemLen, (byte[])this.tempLengthArray, (int)0);
        this.itemStorge.reset();
        this.itemOut.writeByte(ATypeTag.SERIALIZED_STRING_TYPE_TAG);
        this.itemOut.write(this.tempLengthArray, 0, cbytes);
        if (itemLen > 0) {
            this.itemOut.write(srcString, inputStringStart + itemStartOffset, itemLen);
        }
        this.listBuilder.addItem((IValueReference)this.itemStorge);
    }
}

