/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public final class IfMissingOrNullDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = IfMissingOrNullDescriptor::new;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) throws AlgebricksException {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IHyracksTaskContext ctx) throws HyracksDataException {
                return new AbstractIfEvaluator(ctx, args){

                    @Override
                    protected boolean skip(byte argTypeTag) {
                        return argTypeTag == ATypeTag.SERIALIZED_MISSING_TYPE_TAG || argTypeTag == ATypeTag.SERIALIZED_NULL_TYPE_TAG;
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.IF_MISSING_OR_NULL;
    }

    public static abstract class AbstractIfEvaluator
    implements IScalarEvaluator {
        private static final byte[] nullBytes = new byte[]{ATypeTag.SERIALIZED_NULL_TYPE_TAG};
        private final IScalarEvaluator[] argEvals;
        private final IPointable argPtr;

        AbstractIfEvaluator(IHyracksTaskContext ctx, IScalarEvaluatorFactory[] args) throws HyracksDataException {
            this.argEvals = new IScalarEvaluator[args.length];
            for (int i = 0; i < this.argEvals.length; ++i) {
                this.argEvals[i] = args[i].createScalarEvaluator(ctx);
            }
            this.argPtr = new VoidPointable();
        }

        public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
            for (IScalarEvaluator argEval : this.argEvals) {
                argEval.evaluate(tuple, this.argPtr);
                byte[] bytes = this.argPtr.getByteArray();
                int offset = this.argPtr.getStartOffset();
                if (this.skip(bytes[offset])) continue;
                result.set((IValueReference)this.argPtr);
                return;
            }
            result.set(nullBytes, 0, nullBytes.length);
        }

        protected abstract boolean skip(byte var1);
    }
}

