/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.AOrderedListSerializerDeserializer;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class GetItemDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new GetItemDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(IScalarEvaluatorFactory[] args) {
        return new GetItemEvalFactory(args);
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.GET_ITEM;
    }

    private static class GetItemEvalFactory
    implements IScalarEvaluatorFactory {
        private static final long serialVersionUID = 1L;
        private IScalarEvaluatorFactory listEvalFactory;
        private IScalarEvaluatorFactory indexEvalFactory;
        private byte serItemTypeTag;
        private ATypeTag itemTag;
        private boolean selfDescList = false;

        public GetItemEvalFactory(IScalarEvaluatorFactory[] args) {
            this.listEvalFactory = args[0];
            this.indexEvalFactory = args[1];
        }

        public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
            return new IScalarEvaluator(){
                private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                private final DataOutput output = this.resultStorage.getDataOutput();
                private IPointable inputArgList = new VoidPointable();
                private IPointable inputArgIdx = new VoidPointable();
                private IScalarEvaluator evalList = GetItemEvalFactory.access$000(this).createScalarEvaluator(ctx);
                private IScalarEvaluator evalIdx = GetItemEvalFactory.access$100(this).createScalarEvaluator(ctx);
                private byte[] missingBytes = new byte[]{ATypeTag.SERIALIZED_MISSING_TYPE_TAG};
                private int itemIndex;
                private int itemOffset;
                private int itemLength;

                public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                    try {
                        this.evalList.evaluate(tuple, this.inputArgList);
                        this.evalIdx.evaluate(tuple, this.inputArgIdx);
                        byte[] serOrderedList = this.inputArgList.getByteArray();
                        int offset = this.inputArgList.getStartOffset();
                        byte[] indexBytes = this.inputArgIdx.getByteArray();
                        int indexOffset = this.inputArgIdx.getStartOffset();
                        if (serOrderedList[offset] != ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG) {
                            throw new TypeMismatchException(BuiltinFunctions.GET_ITEM, (Integer)0, serOrderedList[offset], ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG);
                        }
                        this.itemIndex = ATypeHierarchy.getIntegerValue((String)BuiltinFunctions.GET_ITEM.getName(), (int)0, (byte[])indexBytes, (int)indexOffset);
                        if (this.itemIndex < 0 || this.itemIndex >= AOrderedListSerializerDeserializer.getNumberOfItems((byte[])serOrderedList, (int)offset)) {
                            result.set(this.missingBytes, 0, 1);
                            return;
                        }
                        itemTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(serOrderedList[offset + 1]);
                        if (itemTag == ATypeTag.ANY) {
                            selfDescList = true;
                        } else {
                            serItemTypeTag = serOrderedList[offset + 1];
                        }
                        this.itemOffset = AOrderedListSerializerDeserializer.getItemOffset((byte[])serOrderedList, (int)offset, (int)this.itemIndex);
                        if (selfDescList) {
                            itemTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(serOrderedList[this.itemOffset]);
                            this.itemLength = NonTaggedFormatUtil.getFieldValueLength((byte[])serOrderedList, (int)this.itemOffset, (ATypeTag)itemTag, (boolean)true) + 1;
                            result.set(serOrderedList, this.itemOffset, this.itemLength);
                        } else {
                            this.itemLength = NonTaggedFormatUtil.getFieldValueLength((byte[])serOrderedList, (int)this.itemOffset, (ATypeTag)itemTag, (boolean)false);
                            this.resultStorage.reset();
                            this.output.writeByte(serItemTypeTag);
                            this.output.write(serOrderedList, this.itemOffset, this.itemLength);
                            result.set((IValueReference)this.resultStorage);
                        }
                    }
                    catch (IOException e) {
                        throw HyracksDataException.create((Throwable)e);
                    }
                }
            };
        }

        static /* synthetic */ IScalarEvaluatorFactory access$000(GetItemEvalFactory x0) {
            return x0.listEvalFactory;
        }

        static /* synthetic */ IScalarEvaluatorFactory access$100(GetItemEvalFactory x0) {
            return x0.indexEvalFactory;
        }
    }
}

