/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.AOrderedListSerializerDeserializer;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.asterix.runtime.exceptions.UnsupportedTypeException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.string.UTF8StringUtil;

public class CodePointToStringDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new CodePointToStringDescriptor();
        }
    };

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IHyracksTaskContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private DataOutput out = this.resultStorage.getDataOutput();
                    private IScalarEvaluatorFactory listEvalFactory;
                    private IPointable inputArgList;
                    private IScalarEvaluator evalList;
                    private final byte[] currentUTF8;
                    private final byte[] tempStoreForLength;
                    private final byte stringTypeTag;
                    {
                        this.listEvalFactory = args[0];
                        this.inputArgList = new VoidPointable();
                        this.evalList = this.listEvalFactory.createScalarEvaluator(ctx);
                        this.currentUTF8 = new byte[6];
                        this.tempStoreForLength = new byte[5];
                        this.stringTypeTag = ATypeTag.SERIALIZED_STRING_TYPE_TAG;
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        try {
                            int codePoint;
                            int itemOffset;
                            int i;
                            int size;
                            this.resultStorage.reset();
                            this.evalList.evaluate(tuple, this.inputArgList);
                            byte[] serOrderedList = this.inputArgList.getByteArray();
                            int offset = this.inputArgList.getStartOffset();
                            if (ATypeTag.VALUE_TYPE_MAPPING[serOrderedList[offset]] != ATypeTag.ARRAY) {
                                throw new TypeMismatchException(CodePointToStringDescriptor.this.getIdentifier().getName(), (Integer)0, serOrderedList[offset], new byte[0]);
                            }
                            switch (ATypeTag.VALUE_TYPE_MAPPING[serOrderedList[offset + 1]]) {
                                case TINYINT: 
                                case SMALLINT: 
                                case INTEGER: 
                                case BIGINT: 
                                case FLOAT: 
                                case DOUBLE: 
                                case ANY: {
                                    size = AOrderedListSerializerDeserializer.getNumberOfItems((byte[])serOrderedList, (int)offset);
                                    break;
                                }
                                default: {
                                    throw new UnsupportedTypeException(CodePointToStringDescriptor.this.getIdentifier(), serOrderedList[offset]);
                                }
                            }
                            int utf_8_len = 0;
                            for (i = 0; i < size; ++i) {
                                itemOffset = AOrderedListSerializerDeserializer.getItemOffset((byte[])serOrderedList, (int)offset, (int)i);
                                codePoint = 0;
                                codePoint = ATypeHierarchy.getIntegerValueWithDifferentTypeTagPosition((String)CodePointToStringDescriptor.this.getIdentifier().getName(), (int)0, (byte[])serOrderedList, (int)itemOffset, (int)(offset + 1));
                                utf_8_len += UTF8StringUtil.codePointToUTF8((int)codePoint, (byte[])this.currentUTF8);
                            }
                            this.out.writeByte(this.stringTypeTag);
                            UTF8StringUtil.writeUTF8Length((int)utf_8_len, (byte[])this.tempStoreForLength, (DataOutput)this.out);
                            for (i = 0; i < size; ++i) {
                                itemOffset = AOrderedListSerializerDeserializer.getItemOffset((byte[])serOrderedList, (int)offset, (int)i);
                                codePoint = 0;
                                codePoint = ATypeHierarchy.getIntegerValueWithDifferentTypeTagPosition((String)CodePointToStringDescriptor.this.getIdentifier().getName(), (int)0, (byte[])serOrderedList, (int)itemOffset, (int)(offset + 1));
                                utf_8_len = UTF8StringUtil.codePointToUTF8((int)codePoint, (byte[])this.currentUTF8);
                                for (int j = 0; j < utf_8_len; ++j) {
                                    this.out.writeByte(this.currentUTF8[j]);
                                }
                            }
                            result.set((IValueReference)this.resultStorage);
                        }
                        catch (IOException e) {
                            throw HyracksDataException.create((Throwable)e);
                        }
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.CODEPOINT_TO_STRING;
    }
}

