/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.string.UTF8StringUtil;

public abstract class AbstractDoubleConstructorEvaluator$_EvaluatorGen
implements IScalarEvaluator {
    protected static final ISerializerDeserializer<ADouble> DOUBLE_SERDE = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
    protected static final IBinaryComparator UTF8_BINARY_CMP = BinaryComparatorFactoryProvider.UTF8STRING_POINTABLE_INSTANCE.createBinaryComparator();
    protected static final byte[] POSITIVE_INF = UTF8StringUtil.writeStringToBytes((String)"INF");
    protected static final byte[] NEGATIVE_INF = UTF8StringUtil.writeStringToBytes((String)"-INF");
    protected static final byte[] NAN = UTF8StringUtil.writeStringToBytes((String)"NaN");
    protected final IScalarEvaluator inputEval;
    protected final ArrayBackedValueStorage resultStorage;
    protected final DataOutput out;
    protected final IPointable inputArg;
    protected final AMutableDouble aDouble;
    protected final UTF8StringPointable utf8Ptr;
    private final TypeChecker typeChecker;

    protected AbstractDoubleConstructorEvaluator$_EvaluatorGen(IScalarEvaluator inputEval) {
        this.inputEval = inputEval;
        this.resultStorage = new ArrayBackedValueStorage();
        this.out = this.resultStorage.getDataOutput();
        this.inputArg = new VoidPointable();
        this.aDouble = new AMutableDouble(0.0);
        this.utf8Ptr = new UTF8StringPointable();
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        try {
            this.inputEval.evaluate(tuple, this.inputArg);
            if (this.typeChecker.isMissing(this.inputArg, result)) {
                return;
            }
            if (this.typeChecker.isNull(result)) {
                return;
            }
            this.resultStorage.reset();
            this.evaluateImpl(result);
        }
        catch (IOException e) {
            throw new InvalidDataFormatException(this.getIdentifier(), e, ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG);
        }
    }

    protected void evaluateImpl(IPointable result) throws IOException {
        int offset;
        byte[] bytes = this.inputArg.getByteArray();
        byte tt = bytes[offset = this.inputArg.getStartOffset()];
        if (tt == ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG) {
            result.set((IValueReference)this.inputArg);
        } else if (tt == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            int len = this.inputArg.getLength();
            if (UTF8_BINARY_CMP.compare(bytes, offset + 1, len - 1, POSITIVE_INF, 0, 5) == 0) {
                this.setDouble(result, Double.POSITIVE_INFINITY);
            } else if (UTF8_BINARY_CMP.compare(bytes, offset + 1, len - 1, NEGATIVE_INF, 0, 6) == 0) {
                this.setDouble(result, Double.NEGATIVE_INFINITY);
            } else if (UTF8_BINARY_CMP.compare(bytes, offset + 1, len - 1, NAN, 0, 5) == 0) {
                this.setDouble(result, Double.NaN);
            } else {
                this.utf8Ptr.set(bytes, offset + 1, len - 1);
                try {
                    this.setDouble(result, Double.parseDouble(this.utf8Ptr.toString()));
                }
                catch (NumberFormatException e) {
                    this.handleUparseableString(result, e);
                }
            }
        } else {
            throw new TypeMismatchException(this.getIdentifier(), (Integer)0, tt, ATypeTag.SERIALIZED_STRING_TYPE_TAG);
        }
    }

    protected void handleUparseableString(IPointable result, NumberFormatException e) throws HyracksDataException {
        throw new InvalidDataFormatException(this.getIdentifier(), e, ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG);
    }

    protected void setDouble(IPointable result, double value) throws HyracksDataException {
        this.aDouble.setValue(value);
        DOUBLE_SERDE.serialize((Object)this.aDouble, this.out);
        result.set((IValueReference)this.resultStorage);
    }

    protected abstract FunctionIdentifier getIdentifier();
}

