/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ADate;
import org.apache.asterix.om.base.AMutableDate;
import org.apache.asterix.om.base.temporal.ADateParserFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.constructors.ADateConstructorDescriptor$_EvaluatorFactoryGen;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

class ADateConstructorDescriptor$_EvaluatorGen
implements IScalarEvaluator {
    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private DataOutput out = this.resultStorage.getDataOutput();
    private IPointable inputArg = new VoidPointable();
    private IScalarEvaluator eval;
    private AMutableDate aDate;
    private ISerializerDeserializer<ADate> dateSerde;
    private final UTF8StringPointable utf8Ptr;
    final /* synthetic */ IHyracksTaskContext val$ctx;
    final /* synthetic */ ADateConstructorDescriptor$_EvaluatorFactoryGen this$1;
    private final TypeChecker typeChecker;

    ADateConstructorDescriptor$_EvaluatorGen(ADateConstructorDescriptor$_EvaluatorFactoryGen this$1, IHyracksTaskContext iHyracksTaskContext) throws HyracksDataException {
        this.this$1 = this$1;
        this.val$ctx = iHyracksTaskContext;
        this.eval = this.this$1.val$args[0].createScalarEvaluator(this.val$ctx);
        this.aDate = new AMutableDate(0);
        this.dateSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATE);
        this.utf8Ptr = new UTF8StringPointable();
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        block10: {
            try {
                this.resultStorage.reset();
                this.eval.evaluate(tuple, this.inputArg);
                if (this.typeChecker.isMissing(this.inputArg, result)) {
                    return;
                }
                if (this.typeChecker.isNull(result)) {
                    return;
                }
                byte[] serString = this.inputArg.getByteArray();
                int offset = this.inputArg.getStartOffset();
                int len = this.inputArg.getLength();
                byte tt = serString[offset];
                if (tt == ATypeTag.SERIALIZED_DATE_TYPE_TAG) {
                    result.set((IValueReference)this.inputArg);
                    break block10;
                }
                if (tt == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
                    this.utf8Ptr.set(serString, offset + 1, len - 1);
                    int stringLength = this.utf8Ptr.getUTF8Length();
                    if (stringLength < 8) {
                        throw new InvalidDataFormatException(this.this$1.this$0.getIdentifier(), ATypeTag.SERIALIZED_DATE_TYPE_TAG);
                    }
                    int startOffset = this.utf8Ptr.getCharStartOffset();
                    while (serString[startOffset] == 32) {
                        ++startOffset;
                    }
                    int endOffset = startOffset + stringLength - 1;
                    while (serString[endOffset] == 32) {
                        --endOffset;
                    }
                    long chrononTimeInMs = ADateParserFactory.parseDatePart((byte[])serString, (int)startOffset, (int)(endOffset - startOffset + 1));
                    int temp = 0;
                    if (chrononTimeInMs < 0L && chrononTimeInMs % 86400000L != 0L) {
                        temp = 1;
                    }
                    this.aDate.setValue((int)(chrononTimeInMs / 86400000L) - temp);
                    this.dateSerde.serialize((Object)this.aDate, this.out);
                    result.set((IValueReference)this.resultStorage);
                    break block10;
                }
                throw new TypeMismatchException(this.this$1.this$0.getIdentifier(), (Integer)0, tt, ATypeTag.SERIALIZED_STRING_TYPE_TAG);
            }
            catch (IOException e) {
                throw new InvalidDataFormatException(this.this$1.this$0.getIdentifier(), e, ATypeTag.SERIALIZED_DATE_TYPE_TAG);
            }
        }
    }
}

