/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.comparisons;

import java.io.Serializable;
import org.apache.asterix.dataflow.data.nontagged.comparators.ACirclePartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.ADurationPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.AIntervalAscPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.ALinePartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.APoint3DPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.APointPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.APolygonPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.ARectanglePartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.AUUIDPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.exceptions.IncompatibleTypeException;
import org.apache.asterix.runtime.exceptions.UnsupportedTypeException;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.accessors.PointableBinaryComparatorFactory;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.ByteArrayPointable;
import org.apache.hyracks.data.std.primitive.FloatPointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;

public class ComparisonHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final String COMPARISON = "comparison operations (>, >=, <, and <=)";
    private final IBinaryComparator strBinaryComp = BinaryComparatorFactoryProvider.UTF8STRING_POINTABLE_INSTANCE.createBinaryComparator();
    private final IBinaryComparator circleBinaryComp = ACirclePartialBinaryComparatorFactory.INSTANCE.createBinaryComparator();
    private final IBinaryComparator durationBinaryComp = ADurationPartialBinaryComparatorFactory.INSTANCE.createBinaryComparator();
    private final IBinaryComparator intervalBinaryComp = AIntervalAscPartialBinaryComparatorFactory.INSTANCE.createBinaryComparator();
    private final IBinaryComparator lineBinaryComparator = ALinePartialBinaryComparatorFactory.INSTANCE.createBinaryComparator();
    private final IBinaryComparator pointBinaryComparator = APointPartialBinaryComparatorFactory.INSTANCE.createBinaryComparator();
    private final IBinaryComparator point3DBinaryComparator = APoint3DPartialBinaryComparatorFactory.INSTANCE.createBinaryComparator();
    private final IBinaryComparator polygonBinaryComparator = APolygonPartialBinaryComparatorFactory.INSTANCE.createBinaryComparator();
    private final IBinaryComparator rectangleBinaryComparator = ARectanglePartialBinaryComparatorFactory.INSTANCE.createBinaryComparator();
    private final IBinaryComparator uuidBinaryComparator = AUUIDPartialBinaryComparatorFactory.INSTANCE.createBinaryComparator();
    private final IBinaryComparator byteArrayComparator = new PointableBinaryComparatorFactory(ByteArrayPointable.FACTORY).createBinaryComparator();

    public int compare(ATypeTag typeTag1, ATypeTag typeTag2, IPointable arg1, IPointable arg2) throws HyracksDataException {
        switch (typeTag1) {
            case TINYINT: {
                return this.compareInt8WithArg(typeTag2, arg1, arg2);
            }
            case SMALLINT: {
                return this.compareInt16WithArg(typeTag2, arg1, arg2);
            }
            case INTEGER: {
                return this.compareInt32WithArg(typeTag2, arg1, arg2);
            }
            case BIGINT: {
                return this.compareInt64WithArg(typeTag2, arg1, arg2);
            }
            case FLOAT: {
                return this.compareFloatWithArg(typeTag2, arg1, arg2);
            }
            case DOUBLE: {
                return this.compareDoubleWithArg(typeTag2, arg1, arg2);
            }
            case STRING: {
                return this.compareStringWithArg(typeTag2, arg1, arg2);
            }
            case BOOLEAN: {
                return this.compareBooleanWithArg(typeTag2, arg1, arg2);
            }
        }
        return this.compareStrongTypedWithArg(typeTag1, typeTag2, arg1, arg2);
    }

    private int compareStrongTypedWithArg(ATypeTag expectedTypeTag, ATypeTag actualTypeTag, IPointable arg1, IPointable arg2) throws HyracksDataException {
        int result;
        if (expectedTypeTag != actualTypeTag) {
            throw new IncompatibleTypeException(COMPARISON, actualTypeTag.serialize(), expectedTypeTag.serialize());
        }
        byte[] leftBytes = arg1.getByteArray();
        int leftOffset = arg1.getStartOffset();
        int leftLen = arg1.getLength() - 1;
        byte[] rightBytes = arg2.getByteArray();
        int rightOffset = arg2.getStartOffset();
        int rightLen = arg2.getLength() - 1;
        switch (actualTypeTag) {
            case YEARMONTHDURATION: 
            case TIME: 
            case DATE: {
                result = Integer.compare(AInt32SerializerDeserializer.getInt((byte[])leftBytes, (int)leftOffset), AInt32SerializerDeserializer.getInt((byte[])rightBytes, (int)rightOffset));
                break;
            }
            case DAYTIMEDURATION: 
            case DATETIME: {
                result = Long.compare(AInt64SerializerDeserializer.getLong((byte[])leftBytes, (int)leftOffset), AInt64SerializerDeserializer.getLong((byte[])rightBytes, (int)rightOffset));
                break;
            }
            case CIRCLE: {
                result = this.circleBinaryComp.compare(leftBytes, leftOffset, leftLen, rightBytes, rightOffset, rightLen);
                break;
            }
            case LINE: {
                result = this.lineBinaryComparator.compare(leftBytes, leftOffset, leftLen, rightBytes, rightOffset, rightLen);
                break;
            }
            case POINT: {
                result = this.pointBinaryComparator.compare(leftBytes, leftOffset, leftLen, rightBytes, rightOffset, rightLen);
                break;
            }
            case POINT3D: {
                result = this.point3DBinaryComparator.compare(leftBytes, leftOffset, leftLen, rightBytes, rightOffset, rightLen);
                break;
            }
            case POLYGON: {
                result = this.polygonBinaryComparator.compare(leftBytes, leftOffset, leftLen, rightBytes, rightOffset, rightLen);
                break;
            }
            case DURATION: {
                result = this.durationBinaryComp.compare(leftBytes, leftOffset, leftLen, rightBytes, rightOffset, rightLen);
                break;
            }
            case INTERVAL: {
                result = this.intervalBinaryComp.compare(leftBytes, leftOffset, leftLen, rightBytes, rightOffset, rightLen);
                break;
            }
            case RECTANGLE: {
                result = this.rectangleBinaryComparator.compare(leftBytes, leftOffset, leftLen, rightBytes, rightOffset, rightLen);
                break;
            }
            case BINARY: {
                result = this.byteArrayComparator.compare(leftBytes, leftOffset, leftLen, rightBytes, rightOffset, rightLen);
                break;
            }
            case UUID: {
                result = this.uuidBinaryComparator.compare(leftBytes, leftOffset, leftLen, rightBytes, rightOffset, rightLen);
                break;
            }
            default: {
                throw new UnsupportedTypeException(COMPARISON, actualTypeTag.serialize());
            }
        }
        return result;
    }

    private int compareBooleanWithArg(ATypeTag typeTag2, IPointable arg1, IPointable arg2) throws HyracksDataException {
        if (typeTag2 == ATypeTag.BOOLEAN) {
            byte b0 = arg1.getByteArray()[arg1.getStartOffset()];
            byte b1 = arg2.getByteArray()[arg2.getStartOffset()];
            return this.compareByte(b0, b1);
        }
        throw new IncompatibleTypeException(COMPARISON, ATypeTag.SERIALIZED_BOOLEAN_TYPE_TAG, typeTag2.serialize());
    }

    private int compareStringWithArg(ATypeTag typeTag2, IPointable arg1, IPointable arg2) throws HyracksDataException {
        if (typeTag2 == ATypeTag.STRING) {
            return this.strBinaryComp.compare(arg1.getByteArray(), arg1.getStartOffset(), arg1.getLength() - 1, arg2.getByteArray(), arg2.getStartOffset(), arg2.getLength() - 1);
        }
        throw new IncompatibleTypeException(COMPARISON, ATypeTag.SERIALIZED_STRING_TYPE_TAG, typeTag2.serialize());
    }

    private int compareDoubleWithArg(ATypeTag typeTag2, IPointable arg1, IPointable arg2) throws HyracksDataException {
        byte[] leftBytes = arg1.getByteArray();
        int leftOffset = arg1.getStartOffset();
        byte[] rightBytes = arg2.getByteArray();
        int rightOffset = arg2.getStartOffset();
        double s = ADoubleSerializerDeserializer.getDouble((byte[])leftBytes, (int)leftOffset);
        switch (typeTag2) {
            case TINYINT: {
                return this.compareDouble(s, AInt8SerializerDeserializer.getByte((byte[])rightBytes, (int)rightOffset));
            }
            case SMALLINT: {
                return this.compareDouble(s, AInt16SerializerDeserializer.getShort((byte[])rightBytes, (int)rightOffset));
            }
            case INTEGER: {
                return this.compareDouble(s, AInt32SerializerDeserializer.getInt((byte[])rightBytes, (int)rightOffset));
            }
            case BIGINT: {
                return this.compareDouble(s, AInt64SerializerDeserializer.getLong((byte[])rightBytes, (int)rightOffset));
            }
            case FLOAT: {
                return this.compareDouble(s, AFloatSerializerDeserializer.getFloat((byte[])rightBytes, (int)rightOffset));
            }
            case DOUBLE: {
                return this.compareDouble(s, ADoubleSerializerDeserializer.getDouble((byte[])rightBytes, (int)rightOffset));
            }
        }
        throw new IncompatibleTypeException(COMPARISON, ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG, typeTag2.serialize());
    }

    private int compareFloatWithArg(ATypeTag typeTag2, IPointable arg1, IPointable arg2) throws HyracksDataException {
        byte[] leftBytes = arg1.getByteArray();
        int leftOffset = arg1.getStartOffset();
        byte[] rightBytes = arg2.getByteArray();
        int rightOffset = arg2.getStartOffset();
        float s = FloatPointable.getFloat((byte[])leftBytes, (int)leftOffset);
        switch (typeTag2) {
            case TINYINT: {
                return this.compareFloat(s, AInt8SerializerDeserializer.getByte((byte[])rightBytes, (int)rightOffset));
            }
            case SMALLINT: {
                return this.compareFloat(s, AInt16SerializerDeserializer.getShort((byte[])rightBytes, (int)rightOffset));
            }
            case INTEGER: {
                return this.compareFloat(s, AInt32SerializerDeserializer.getInt((byte[])rightBytes, (int)rightOffset));
            }
            case BIGINT: {
                return this.compareFloat(s, AInt64SerializerDeserializer.getLong((byte[])rightBytes, (int)rightOffset));
            }
            case FLOAT: {
                return this.compareFloat(s, AFloatSerializerDeserializer.getFloat((byte[])rightBytes, (int)rightOffset));
            }
            case DOUBLE: {
                return this.compareDouble(s, ADoubleSerializerDeserializer.getDouble((byte[])rightBytes, (int)rightOffset));
            }
        }
        throw new IncompatibleTypeException(COMPARISON, ATypeTag.SERIALIZED_FLOAT_TYPE_TAG, typeTag2.serialize());
    }

    private int compareInt64WithArg(ATypeTag typeTag2, IPointable arg1, IPointable arg2) throws HyracksDataException {
        byte[] leftBytes = arg1.getByteArray();
        int leftOffset = arg1.getStartOffset();
        byte[] rightBytes = arg2.getByteArray();
        int rightOffset = arg2.getStartOffset();
        long s = AInt64SerializerDeserializer.getLong((byte[])leftBytes, (int)leftOffset);
        switch (typeTag2) {
            case TINYINT: {
                return this.compareLong(s, AInt8SerializerDeserializer.getByte((byte[])rightBytes, (int)rightOffset));
            }
            case SMALLINT: {
                return this.compareLong(s, AInt16SerializerDeserializer.getShort((byte[])rightBytes, (int)rightOffset));
            }
            case INTEGER: {
                return this.compareLong(s, AInt32SerializerDeserializer.getInt((byte[])rightBytes, (int)rightOffset));
            }
            case BIGINT: {
                return this.compareLong(s, AInt64SerializerDeserializer.getLong((byte[])rightBytes, (int)rightOffset));
            }
            case FLOAT: {
                return this.compareFloat(s, AFloatSerializerDeserializer.getFloat((byte[])rightBytes, (int)rightOffset));
            }
            case DOUBLE: {
                return this.compareDouble(s, ADoubleSerializerDeserializer.getDouble((byte[])rightBytes, (int)rightOffset));
            }
        }
        throw new IncompatibleTypeException(COMPARISON, ATypeTag.SERIALIZED_INT64_TYPE_TAG, typeTag2.serialize());
    }

    private int compareInt32WithArg(ATypeTag typeTag2, IPointable arg1, IPointable arg2) throws HyracksDataException {
        byte[] leftBytes = arg1.getByteArray();
        int leftOffset = arg1.getStartOffset();
        byte[] rightBytes = arg2.getByteArray();
        int rightOffset = arg2.getStartOffset();
        int s = IntegerPointable.getInteger((byte[])leftBytes, (int)leftOffset);
        switch (typeTag2) {
            case TINYINT: {
                byte v2 = AInt8SerializerDeserializer.getByte((byte[])rightBytes, (int)rightOffset);
                return this.compareInt(s, v2);
            }
            case SMALLINT: {
                short v2 = AInt16SerializerDeserializer.getShort((byte[])rightBytes, (int)rightOffset);
                return this.compareInt(s, v2);
            }
            case INTEGER: {
                int v2 = AInt32SerializerDeserializer.getInt((byte[])rightBytes, (int)rightOffset);
                return this.compareInt(s, v2);
            }
            case BIGINT: {
                long v2 = AInt64SerializerDeserializer.getLong((byte[])rightBytes, (int)rightOffset);
                return this.compareLong(s, v2);
            }
            case FLOAT: {
                float v2 = AFloatSerializerDeserializer.getFloat((byte[])rightBytes, (int)rightOffset);
                return this.compareFloat(s, v2);
            }
            case DOUBLE: {
                double v2 = ADoubleSerializerDeserializer.getDouble((byte[])rightBytes, (int)rightOffset);
                return this.compareDouble(s, v2);
            }
        }
        throw new IncompatibleTypeException(COMPARISON, ATypeTag.SERIALIZED_INT32_TYPE_TAG, typeTag2.serialize());
    }

    private int compareInt16WithArg(ATypeTag typeTag2, IPointable arg1, IPointable arg2) throws HyracksDataException {
        byte[] leftBytes = arg1.getByteArray();
        int leftOffset = arg1.getStartOffset();
        byte[] rightBytes = arg2.getByteArray();
        int rightOffset = arg2.getStartOffset();
        short s = AInt16SerializerDeserializer.getShort((byte[])leftBytes, (int)leftOffset);
        switch (typeTag2) {
            case TINYINT: {
                byte v2 = AInt8SerializerDeserializer.getByte((byte[])rightBytes, (int)rightOffset);
                return this.compareShort(s, v2);
            }
            case SMALLINT: {
                short v2 = AInt16SerializerDeserializer.getShort((byte[])rightBytes, (int)rightOffset);
                return this.compareShort(s, v2);
            }
            case INTEGER: {
                int v2 = AInt32SerializerDeserializer.getInt((byte[])rightBytes, (int)rightOffset);
                return this.compareInt(s, v2);
            }
            case BIGINT: {
                long v2 = AInt64SerializerDeserializer.getLong((byte[])rightBytes, (int)rightOffset);
                return this.compareLong(s, v2);
            }
            case FLOAT: {
                float v2 = AFloatSerializerDeserializer.getFloat((byte[])rightBytes, (int)rightOffset);
                return this.compareFloat(s, v2);
            }
            case DOUBLE: {
                double v2 = ADoubleSerializerDeserializer.getDouble((byte[])rightBytes, (int)rightOffset);
                return this.compareDouble(s, v2);
            }
        }
        throw new IncompatibleTypeException(COMPARISON, ATypeTag.SERIALIZED_INT16_TYPE_TAG, typeTag2.serialize());
    }

    private int compareInt8WithArg(ATypeTag typeTag2, IPointable arg1, IPointable arg2) throws HyracksDataException {
        byte[] leftBytes = arg1.getByteArray();
        int leftStart = arg1.getStartOffset();
        byte[] rightBytes = arg2.getByteArray();
        int rightStart = arg2.getStartOffset();
        byte s = AInt8SerializerDeserializer.getByte((byte[])leftBytes, (int)leftStart);
        switch (typeTag2) {
            case TINYINT: {
                return this.compareByte(s, AInt8SerializerDeserializer.getByte((byte[])rightBytes, (int)rightStart));
            }
            case SMALLINT: {
                return this.compareShort(s, AInt16SerializerDeserializer.getShort((byte[])rightBytes, (int)rightStart));
            }
            case INTEGER: {
                return this.compareInt(s, AInt32SerializerDeserializer.getInt((byte[])rightBytes, (int)rightStart));
            }
            case BIGINT: {
                return this.compareLong(s, AInt64SerializerDeserializer.getLong((byte[])rightBytes, (int)rightStart));
            }
            case FLOAT: {
                return this.compareFloat(s, AFloatSerializerDeserializer.getFloat((byte[])rightBytes, (int)rightStart));
            }
            case DOUBLE: {
                return this.compareDouble(s, ADoubleSerializerDeserializer.getDouble((byte[])rightBytes, (int)rightStart));
            }
        }
        throw new IncompatibleTypeException(COMPARISON, ATypeTag.SERIALIZED_INT8_TYPE_TAG, typeTag2.serialize());
    }

    private final int compareByte(int v1, int v2) {
        if (v1 == v2) {
            return 0;
        }
        if (v1 < v2) {
            return -1;
        }
        return 1;
    }

    private final int compareShort(int v1, int v2) {
        if (v1 == v2) {
            return 0;
        }
        if (v1 < v2) {
            return -1;
        }
        return 1;
    }

    private final int compareInt(int v1, int v2) {
        if (v1 == v2) {
            return 0;
        }
        if (v1 < v2) {
            return -1;
        }
        return 1;
    }

    private final int compareLong(long v1, long v2) {
        if (v1 == v2) {
            return 0;
        }
        if (v1 < v2) {
            return -1;
        }
        return 1;
    }

    private final int compareFloat(float v1, float v2) {
        if (v1 == v2) {
            return 0;
        }
        if (v1 < v2) {
            return -1;
        }
        return 1;
    }

    private final int compareDouble(double v1, double v2) {
        if (v1 == v2) {
            return 0;
        }
        if (v1 < v2) {
            return -1;
        }
        return 1;
    }
}

