/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.common;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AOrderedListSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AUnorderedListSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.fuzzyjoin.IntArray;
import org.apache.asterix.fuzzyjoin.similarity.PartialIntersect;
import org.apache.asterix.fuzzyjoin.similarity.SimilarityFiltersJaccard;
import org.apache.asterix.fuzzyjoin.similarity.SimilarityMetric;
import org.apache.asterix.om.base.AFloat;
import org.apache.asterix.om.base.AMutableFloat;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.staticcodegen.TypeChecker;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class SimilarityJaccardPrefixEvaluator$_EvaluatorGen
implements IScalarEvaluator {
    protected final int typeIndicatorSize = 1;
    protected final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    protected final DataOutput out = this.resultStorage.getDataOutput();
    protected final IPointable inputVal = new VoidPointable();
    protected final IScalarEvaluator evalLen1;
    protected final IScalarEvaluator evalTokens1;
    protected final IScalarEvaluator evalLen2;
    protected final IScalarEvaluator evalTokens2;
    protected final IScalarEvaluator evalTokenPrefix;
    protected final IScalarEvaluator evalThreshold;
    protected float similarityThresholdCache;
    protected SimilarityFiltersJaccard similarityFilters;
    protected final IntArray tokens1 = new IntArray();
    protected final IntArray tokens2 = new IntArray();
    protected final PartialIntersect parInter = new PartialIntersect();
    protected float sim = 0.0f;
    protected final AMutableFloat res = new AMutableFloat(0.0f);
    protected final ISerializerDeserializer<AFloat> reusSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AFLOAT);
    private final TypeChecker typeChecker;

    public SimilarityJaccardPrefixEvaluator$_EvaluatorGen(IScalarEvaluatorFactory[] args, IHyracksTaskContext context) throws HyracksDataException {
        this.evalLen1 = args[0].createScalarEvaluator(context);
        this.evalTokens1 = args[1].createScalarEvaluator(context);
        this.evalLen2 = args[2].createScalarEvaluator(context);
        this.evalTokens2 = args[3].createScalarEvaluator(context);
        this.evalTokenPrefix = args[4].createScalarEvaluator(context);
        this.evalThreshold = args[5].createScalarEvaluator(context);
        this.typeChecker = new TypeChecker();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        this.sim = 0.0f;
        this.evalThreshold.evaluate(tuple, this.inputVal);
        if (this.typeChecker.isMissing(this.inputVal, result)) {
            return;
        }
        float similarityThreshold = AFloatSerializerDeserializer.getFloat((byte[])this.inputVal.getByteArray(), (int)(this.inputVal.getStartOffset() + 1));
        if (similarityThreshold != this.similarityThresholdCache || this.similarityFilters == null) {
            this.similarityFilters = new SimilarityFiltersJaccard(similarityThreshold);
            this.similarityThresholdCache = similarityThreshold;
        }
        this.evalLen1.evaluate(tuple, this.inputVal);
        if (this.typeChecker.isMissing(this.inputVal, result)) {
            return;
        }
        int length1 = ATypeHierarchy.getIntegerValue((String)BuiltinFunctions.SIMILARITY_JACCARD.getName(), (int)0, (byte[])this.inputVal.getByteArray(), (int)this.inputVal.getStartOffset());
        this.evalLen2.evaluate(tuple, this.inputVal);
        if (this.typeChecker.isMissing(this.inputVal, result)) {
            return;
        }
        int length2 = ATypeHierarchy.getIntegerValue((String)BuiltinFunctions.SIMILARITY_JACCARD.getName(), (int)2, (byte[])this.inputVal.getByteArray(), (int)this.inputVal.getStartOffset());
        if (this.similarityFilters.passLengthFilter(length1, length2)) {
            int token;
            int itemOffset;
            int lengthTokens2;
            int token2;
            int itemOffset2;
            int i;
            int lengthTokens1;
            int startOffset;
            this.tokens1.reset();
            this.evalTokens1.evaluate(tuple, this.inputVal);
            if (this.typeChecker.isMissing(this.inputVal, result)) {
                return;
            }
            byte[] serList = this.inputVal.getByteArray();
            if (serList[startOffset = this.inputVal.getStartOffset()] != ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG && serList[startOffset] != ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG) {
                throw new TypeMismatchException(BuiltinFunctions.SIMILARITY_JACCARD, (Integer)1, serList[startOffset], ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG, ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG);
            }
            if (serList[startOffset] == ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG) {
                lengthTokens1 = AOrderedListSerializerDeserializer.getNumberOfItems((byte[])this.inputVal.getByteArray(), (int)startOffset);
                for (i = 0; i < lengthTokens1; ++i) {
                    itemOffset2 = AOrderedListSerializerDeserializer.getItemOffset((byte[])serList, (int)startOffset, (int)i);
                    token2 = ATypeHierarchy.getIntegerValueWithDifferentTypeTagPosition((String)BuiltinFunctions.SIMILARITY_JACCARD.getName(), (int)1, (byte[])serList, (int)itemOffset2, (int)(startOffset + 1));
                    this.tokens1.add(token2);
                }
            } else {
                lengthTokens1 = AUnorderedListSerializerDeserializer.getNumberOfItems((byte[])this.inputVal.getByteArray(), (int)startOffset);
                for (i = 0; i < lengthTokens1; ++i) {
                    itemOffset2 = AUnorderedListSerializerDeserializer.getItemOffset((byte[])serList, (int)startOffset, (int)i);
                    token2 = ATypeHierarchy.getIntegerValueWithDifferentTypeTagPosition((String)BuiltinFunctions.SIMILARITY_JACCARD.getName(), (int)1, (byte[])serList, (int)itemOffset2, (int)(startOffset + 1));
                    this.tokens1.add(token2);
                }
            }
            while (i < length1) {
                this.tokens1.add(Integer.MAX_VALUE);
                ++i;
            }
            this.tokens2.reset();
            this.evalTokens2.evaluate(tuple, this.inputVal);
            if (this.typeChecker.isMissing(this.inputVal, result)) {
                return;
            }
            serList = this.inputVal.getByteArray();
            if (serList[startOffset = this.inputVal.getStartOffset()] != ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG && serList[startOffset] != ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG) {
                throw new TypeMismatchException(BuiltinFunctions.SIMILARITY_JACCARD, (Integer)3, serList[startOffset], ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG, ATypeTag.SERIALIZED_UNORDEREDLIST_TYPE_TAG);
            }
            if (serList[startOffset] == ATypeTag.SERIALIZED_ORDEREDLIST_TYPE_TAG) {
                lengthTokens2 = AOrderedListSerializerDeserializer.getNumberOfItems((byte[])this.inputVal.getByteArray(), (int)startOffset);
                for (i = 0; i < lengthTokens2; ++i) {
                    itemOffset = AOrderedListSerializerDeserializer.getItemOffset((byte[])serList, (int)startOffset, (int)i);
                    token = ATypeHierarchy.getIntegerValueWithDifferentTypeTagPosition((String)BuiltinFunctions.SIMILARITY_JACCARD.getName(), (int)3, (byte[])serList, (int)itemOffset, (int)(startOffset + 1));
                    this.tokens2.add(token);
                }
            } else {
                lengthTokens2 = AUnorderedListSerializerDeserializer.getNumberOfItems((byte[])this.inputVal.getByteArray(), (int)startOffset);
                for (i = 0; i < lengthTokens2; ++i) {
                    itemOffset = AUnorderedListSerializerDeserializer.getItemOffset((byte[])serList, (int)startOffset, (int)i);
                    token = ATypeHierarchy.getIntegerValueWithDifferentTypeTagPosition((String)BuiltinFunctions.SIMILARITY_JACCARD.getName(), (int)3, (byte[])serList, (int)itemOffset, (int)(startOffset + 1));
                    this.tokens2.add(token);
                }
            }
            while (i < length2) {
                this.tokens2.add(Integer.MAX_VALUE);
                ++i;
            }
            this.evalTokenPrefix.evaluate(tuple, this.inputVal);
            if (this.typeChecker.isMissing(this.inputVal, result)) {
                return;
            }
            if (this.typeChecker.isNull(result)) {
                return;
            }
            int tokenPrefix = ATypeHierarchy.getIntegerValue((String)BuiltinFunctions.SIMILARITY_JACCARD.getName(), (int)4, (byte[])this.inputVal.getByteArray(), (int)this.inputVal.getStartOffset());
            SimilarityMetric.getPartialIntersectSize((int[])this.tokens1.get(), (int)0, (int)this.tokens1.length(), (int[])this.tokens2.get(), (int)0, (int)this.tokens2.length(), (int)tokenPrefix, (PartialIntersect)this.parInter);
            if (this.similarityFilters.passPositionFilter(this.parInter.intersectSize, this.parInter.posXStop, length1, this.parInter.posYStop, length2) && this.similarityFilters.passSuffixFilter(this.tokens1.get(), 0, this.tokens1.length(), this.parInter.posXStart, this.tokens2.get(), 0, this.tokens2.length(), this.parInter.posYStart)) {
                this.sim = this.similarityFilters.passSimilarityFilter(this.tokens1.get(), 0, this.tokens1.length(), this.parInter.posXStop + 1, this.tokens2.get(), 0, this.tokens2.length(), this.parInter.posYStop + 1, this.parInter.intersectSize);
            }
        }
        try {
            this.writeResult();
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
        result.set((IValueReference)this.resultStorage);
    }

    public void writeResult() throws IOException {
        this.res.setValue(this.sim);
        this.reusSerde.serialize((Object)this.res, this.out);
    }
}

