/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.std;

import java.io.IOException;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.asterix.runtime.exceptions.IncompatibleTypeException;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractMinMaxAggregateFunction
implements IAggregateEvaluator {
    private IPointable inputVal = new VoidPointable();
    private ArrayBackedValueStorage outputVal = new ArrayBackedValueStorage();
    private ArrayBackedValueStorage tempValForCasting = new ArrayBackedValueStorage();
    protected ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private IScalarEvaluator eval;
    protected ATypeTag aggType;
    private IBinaryComparator cmp;
    private ITypeConvertComputer tpc;
    private final boolean isMin;

    public AbstractMinMaxAggregateFunction(IScalarEvaluatorFactory[] args, IHyracksTaskContext context, boolean isMin) throws HyracksDataException {
        this.eval = args[0].createScalarEvaluator(context);
        this.isMin = isMin;
    }

    public void init() throws HyracksDataException {
        this.aggType = ATypeTag.SYSTEM_NULL;
        this.tempValForCasting.reset();
    }

    public void step(IFrameTupleReference tuple) throws HyracksDataException {
        if (this.skipStep()) {
            return;
        }
        this.eval.evaluate(tuple, this.inputVal);
        ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.inputVal.getByteArray()[this.inputVal.getStartOffset()]);
        if (typeTag == ATypeTag.MISSING || typeTag == ATypeTag.NULL) {
            this.processNull();
            return;
        }
        if (this.aggType == ATypeTag.SYSTEM_NULL) {
            if (typeTag == ATypeTag.SYSTEM_NULL) {
                return;
            }
            this.aggType = typeTag;
            IBinaryComparatorFactory cmpFactory = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory(this.aggType, this.isMin);
            this.cmp = cmpFactory.createBinaryComparator();
            this.outputVal.assign((IValueReference)this.inputVal);
        } else {
            if (typeTag != ATypeTag.SYSTEM_NULL && !ATypeHierarchy.isCompatible((ATypeTag)typeTag, (ATypeTag)this.aggType)) {
                throw new IncompatibleTypeException("min/max", typeTag.serialize(), this.aggType.serialize());
            }
            if (typeTag == ATypeTag.SYSTEM_NULL) {
                this.processSystemNull();
                return;
            }
            if (ATypeHierarchy.canPromote((ATypeTag)this.aggType, (ATypeTag)typeTag)) {
                this.tpc = ATypeHierarchy.getTypePromoteComputer((ATypeTag)this.aggType, (ATypeTag)typeTag);
                this.aggType = typeTag;
                this.cmp = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory(this.aggType, this.isMin).createBinaryComparator();
                if (this.tpc != null) {
                    this.tempValForCasting.reset();
                    try {
                        this.tpc.convertType(this.outputVal.getByteArray(), this.outputVal.getStartOffset() + 1, this.outputVal.getLength() - 1, this.tempValForCasting.getDataOutput());
                    }
                    catch (IOException e) {
                        throw new HyracksDataException((Throwable)e);
                    }
                    this.outputVal.assign((IValueReference)this.tempValForCasting);
                }
                if (this.cmp.compare(this.inputVal.getByteArray(), this.inputVal.getStartOffset(), this.inputVal.getLength(), this.outputVal.getByteArray(), this.outputVal.getStartOffset(), this.outputVal.getLength()) < 0) {
                    this.outputVal.assign((IValueReference)this.inputVal);
                }
            } else {
                this.tpc = ATypeHierarchy.getTypePromoteComputer((ATypeTag)typeTag, (ATypeTag)this.aggType);
                if (this.tpc != null) {
                    this.tempValForCasting.reset();
                    try {
                        this.tpc.convertType(this.inputVal.getByteArray(), this.inputVal.getStartOffset() + 1, this.inputVal.getLength() - 1, this.tempValForCasting.getDataOutput());
                    }
                    catch (IOException e) {
                        throw new HyracksDataException((Throwable)e);
                    }
                    if (this.cmp.compare(this.tempValForCasting.getByteArray(), this.tempValForCasting.getStartOffset(), this.tempValForCasting.getLength(), this.outputVal.getByteArray(), this.outputVal.getStartOffset(), this.outputVal.getLength()) < 0) {
                        this.outputVal.assign((IValueReference)this.tempValForCasting);
                    }
                } else if (this.cmp.compare(this.inputVal.getByteArray(), this.inputVal.getStartOffset(), this.inputVal.getLength(), this.outputVal.getByteArray(), this.outputVal.getStartOffset(), this.outputVal.getLength()) < 0) {
                    this.outputVal.assign((IValueReference)this.inputVal);
                }
            }
        }
    }

    public void finish(IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        try {
            switch (this.aggType) {
                case NULL: {
                    this.resultStorage.getDataOutput().writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
                    result.set((IValueReference)this.resultStorage);
                    break;
                }
                case SYSTEM_NULL: {
                    this.finishSystemNull();
                    result.set((IValueReference)this.resultStorage);
                    break;
                }
                default: {
                    result.set((IValueReference)this.outputVal);
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void finishPartial(IPointable result) throws HyracksDataException {
        this.finish(result);
    }

    protected boolean skipStep() {
        return false;
    }

    protected abstract void processNull();

    protected abstract void processSystemNull() throws HyracksDataException;

    protected abstract void finishSystemNull() throws IOException;
}

