/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.std;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.asterix.common.config.GlobalConfig;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ARecordSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.common.AccessibleByteArrayEval;
import org.apache.asterix.runtime.evaluators.common.ClosedRecordConstructorEvalFactory;
import org.apache.asterix.runtime.exceptions.IncompatibleTypeException;
import org.apache.asterix.runtime.exceptions.UnsupportedItemTypeException;
import org.apache.hyracks.algebricks.runtime.base.IAggregateEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.data.std.util.ByteArrayAccessibleOutputStream;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractAvgAggregateFunction
implements IAggregateEvaluator {
    private static final int SUM_FIELD_ID = 0;
    private static final int COUNT_FIELD_ID = 1;
    private final ARecordType recType;
    private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    private IPointable inputVal = new VoidPointable();
    private IScalarEvaluator eval;
    protected ATypeTag aggType;
    private double sum;
    private long count;
    private AMutableDouble aDouble = new AMutableDouble(0.0);
    private AMutableInt64 aInt64 = new AMutableInt64(0L);
    private IPointable avgBytes = new VoidPointable();
    private ByteArrayAccessibleOutputStream sumBytes = new ByteArrayAccessibleOutputStream();
    private DataOutput sumBytesOutput = new DataOutputStream((OutputStream)this.sumBytes);
    private ByteArrayAccessibleOutputStream countBytes = new ByteArrayAccessibleOutputStream();
    private DataOutput countBytesOutput = new DataOutputStream((OutputStream)this.countBytes);
    private IScalarEvaluator evalSum = new AccessibleByteArrayEval(this.sumBytes);
    private IScalarEvaluator evalCount = new AccessibleByteArrayEval(this.countBytes);
    private ClosedRecordConstructorEvalFactory.ClosedRecordConstructorEval recordEval;
    private ISerializerDeserializer<ADouble> doubleSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
    private ISerializerDeserializer<AInt64> longSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
    private ISerializerDeserializer<ANull> nullSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ANULL);

    public AbstractAvgAggregateFunction(IScalarEvaluatorFactory[] args, IHyracksTaskContext context) throws HyracksDataException {
        this.eval = args[0].createScalarEvaluator(context);
        this.recType = new ARecordType(null, new String[]{"sum", "count"}, new IAType[]{BuiltinType.ADOUBLE, BuiltinType.AINT64}, false);
        this.recordEval = new ClosedRecordConstructorEvalFactory.ClosedRecordConstructorEval(this.recType, new IScalarEvaluator[]{this.evalSum, this.evalCount});
    }

    public void init() throws HyracksDataException {
        this.aggType = ATypeTag.SYSTEM_NULL;
        this.sum = 0.0;
        this.count = 0L;
    }

    public abstract void step(IFrameTupleReference var1) throws HyracksDataException;

    public abstract void finish(IPointable var1) throws HyracksDataException;

    public abstract void finishPartial(IPointable var1) throws HyracksDataException;

    protected abstract void processNull();

    protected void processDataValues(IFrameTupleReference tuple) throws HyracksDataException {
        if (this.skipStep()) {
            return;
        }
        this.eval.evaluate(tuple, this.inputVal);
        byte[] data = this.inputVal.getByteArray();
        int offset = this.inputVal.getStartOffset();
        ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(data[offset]);
        if (typeTag == ATypeTag.MISSING || typeTag == ATypeTag.NULL) {
            this.processNull();
            return;
        }
        if (this.aggType == ATypeTag.SYSTEM_NULL) {
            this.aggType = typeTag;
        } else {
            if (typeTag != ATypeTag.SYSTEM_NULL && !ATypeHierarchy.isCompatible((ATypeTag)typeTag, (ATypeTag)this.aggType)) {
                throw new IncompatibleTypeException(BuiltinFunctions.AVG, data[offset], this.aggType.serialize());
            }
            if (ATypeHierarchy.canPromote((ATypeTag)this.aggType, (ATypeTag)typeTag)) {
                this.aggType = typeTag;
            }
        }
        ++this.count;
        switch (typeTag) {
            case TINYINT: {
                byte val = AInt8SerializerDeserializer.getByte((byte[])data, (int)(offset + 1));
                this.sum += (double)val;
                break;
            }
            case SMALLINT: {
                short val = AInt16SerializerDeserializer.getShort((byte[])data, (int)(offset + 1));
                this.sum += (double)val;
                break;
            }
            case INTEGER: {
                int val = AInt32SerializerDeserializer.getInt((byte[])data, (int)(offset + 1));
                this.sum += (double)val;
                break;
            }
            case BIGINT: {
                long val = AInt64SerializerDeserializer.getLong((byte[])data, (int)(offset + 1));
                this.sum += (double)val;
                break;
            }
            case FLOAT: {
                float val = AFloatSerializerDeserializer.getFloat((byte[])data, (int)(offset + 1));
                this.sum += (double)val;
                break;
            }
            case DOUBLE: {
                double val = ADoubleSerializerDeserializer.getDouble((byte[])data, (int)(offset + 1));
                this.sum += val;
                break;
            }
            default: {
                throw new UnsupportedItemTypeException(BuiltinFunctions.AVG, data[offset]);
            }
        }
    }

    protected void finishPartialResults(IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        try {
            if (this.aggType == ATypeTag.SYSTEM_NULL) {
                GlobalConfig.ASTERIX_LOGGER.finest("AVG aggregate ran over empty input.");
                this.resultStorage.getDataOutput().writeByte(ATypeTag.SERIALIZED_SYSTEM_NULL_TYPE_TAG);
                result.set((IValueReference)this.resultStorage);
            } else if (this.aggType == ATypeTag.NULL) {
                this.resultStorage.getDataOutput().writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
                result.set((IValueReference)this.resultStorage);
            } else {
                this.sumBytes.reset();
                this.aDouble.setValue(this.sum);
                this.doubleSerde.serialize((Object)this.aDouble, this.sumBytesOutput);
                this.countBytes.reset();
                this.aInt64.setValue(this.count);
                this.longSerde.serialize((Object)this.aInt64, this.countBytesOutput);
                this.recordEval.evaluate(null, this.avgBytes);
                result.set((IValueReference)this.avgBytes);
            }
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    protected void processPartialResults(IFrameTupleReference tuple) throws HyracksDataException {
        if (this.skipStep()) {
            return;
        }
        this.eval.evaluate(tuple, this.inputVal);
        byte[] serBytes = this.inputVal.getByteArray();
        int offset = this.inputVal.getStartOffset();
        ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(serBytes[offset]);
        switch (typeTag) {
            case NULL: {
                this.processNull();
                break;
            }
            case SYSTEM_NULL: {
                break;
            }
            case OBJECT: {
                this.aggType = ATypeTag.DOUBLE;
                int nullBitmapSize = 0;
                int offset1 = ARecordSerializerDeserializer.getFieldOffsetById((byte[])serBytes, (int)offset, (int)0, (int)nullBitmapSize, (boolean)false);
                this.sum += ADoubleSerializerDeserializer.getDouble((byte[])serBytes, (int)offset1);
                int offset2 = ARecordSerializerDeserializer.getFieldOffsetById((byte[])serBytes, (int)offset, (int)1, (int)nullBitmapSize, (boolean)false);
                this.count += AInt64SerializerDeserializer.getLong((byte[])serBytes, (int)offset2);
                break;
            }
            default: {
                throw new UnsupportedItemTypeException("intermediate/global-Avg", serBytes[offset]);
            }
        }
    }

    protected void finishFinalResults(IPointable result) throws HyracksDataException {
        this.resultStorage.reset();
        try {
            if (this.count == 0L || this.aggType == ATypeTag.NULL) {
                this.nullSerde.serialize((Object)ANull.NULL, this.resultStorage.getDataOutput());
            } else {
                this.aDouble.setValue(this.sum / (double)this.count);
                this.doubleSerde.serialize((Object)this.aDouble, this.resultStorage.getDataOutput());
            }
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
        result.set((IValueReference)this.resultStorage);
    }

    protected boolean skipStep() {
        return false;
    }
}

