/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser;

import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.IDataParser;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.external.api.IStreamDataParser;
import org.apache.asterix.external.parser.AbstractDataParser;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParser;
import org.apache.hyracks.dataflow.common.data.parsers.IValueParserFactory;
import org.apache.hyracks.dataflow.std.file.FieldCursorForDelimitedDataParser;

public class DelimitedDataParser
extends AbstractDataParser
implements IStreamDataParser,
IRecordDataParser<char[]> {
    private final char fieldDelimiter;
    private final char quote;
    private final boolean hasHeader;
    private ARecordType recordType;
    private IARecordBuilder recBuilder;
    private ArrayBackedValueStorage fieldValueBuffer;
    private DataOutput fieldValueBufferOutput;
    private IValueParser[] valueParsers;
    private FieldCursorForDelimitedDataParser cursor;
    private byte[] fieldTypeTags;
    private int[] fldIds;
    private ArrayBackedValueStorage[] nameBuffers;
    private boolean areAllNullFields;

    public DelimitedDataParser(IValueParserFactory[] valueParserFactories, char fieldDelimter, char quote, boolean hasHeader, ARecordType recordType, boolean isStreamParser) throws HyracksDataException {
        this.fieldDelimiter = fieldDelimter;
        this.quote = quote;
        this.hasHeader = hasHeader;
        this.recordType = recordType;
        this.valueParsers = new IValueParser[valueParserFactories.length];
        for (int i = 0; i < valueParserFactories.length; ++i) {
            this.valueParsers[i] = valueParserFactories[i].createValueParser();
        }
        this.fieldValueBuffer = new ArrayBackedValueStorage();
        this.fieldValueBufferOutput = this.fieldValueBuffer.getDataOutput();
        this.recBuilder = new RecordBuilder();
        this.recBuilder.reset(recordType);
        this.recBuilder.init();
        int n = recordType.getFieldNames().length;
        this.fieldTypeTags = new byte[n];
        for (int i = 0; i < n; ++i) {
            ATypeTag tag = recordType.getFieldTypes()[i].getTypeTag();
            this.fieldTypeTags[i] = tag.serialize();
        }
        this.fldIds = new int[n];
        this.nameBuffers = new ArrayBackedValueStorage[n];
        AMutableString str = new AMutableString(null);
        for (int i = 0; i < n; ++i) {
            String name = recordType.getFieldNames()[i];
            this.fldIds[i] = this.recBuilder.getFieldId(name);
            if (this.fldIds[i] >= 0) continue;
            if (!recordType.isOpen()) {
                throw new RuntimeDataException(3006, new Serializable[]{name, recordType});
            }
            this.nameBuffers[i] = new ArrayBackedValueStorage();
            str.setValue(name);
            IDataParser.toBytes(str, this.nameBuffers[i], this.stringSerde);
        }
        if (!isStreamParser) {
            this.cursor = new FieldCursorForDelimitedDataParser(null, this.fieldDelimiter, quote);
        }
    }

    @Override
    public boolean parse(DataOutput out) throws HyracksDataException {
        try {
            while (this.cursor.nextRecord()) {
                this.parseRecord();
                if (this.areAllNullFields) continue;
                this.recBuilder.write(out, true);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    private void parseRecord() throws HyracksDataException {
        this.recBuilder.reset(this.recordType);
        this.recBuilder.init();
        this.areAllNullFields = true;
        for (int i = 0; i < this.valueParsers.length; ++i) {
            try {
                if (!this.cursor.nextField()) {
                    break;
                }
            }
            catch (IOException e) {
                throw new HyracksDataException((Throwable)e);
            }
            this.fieldValueBuffer.reset();
            try {
                if (this.cursor.fStart == this.cursor.fEnd && this.recordType.getFieldTypes()[i].getTypeTag() != ATypeTag.STRING && this.recordType.getFieldTypes()[i].getTypeTag() != ATypeTag.NULL) {
                    if (!NonTaggedFormatUtil.isOptional((IAType)this.recordType.getFieldTypes()[i])) {
                        throw new RuntimeDataException(3005, new Serializable[]{Integer.valueOf(this.cursor.recordCount), Integer.valueOf(this.cursor.fieldCount)});
                    }
                    this.fieldValueBufferOutput.writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
                } else {
                    this.fieldValueBufferOutput.writeByte(this.fieldTypeTags[i]);
                    if (this.cursor.isDoubleQuoteIncludedInThisField) {
                        this.cursor.eliminateDoubleQuote(this.cursor.buffer, this.cursor.fStart, this.cursor.fEnd - this.cursor.fStart);
                        this.cursor.fEnd -= this.cursor.doubleQuoteCount;
                        this.cursor.isDoubleQuoteIncludedInThisField = false;
                    }
                    this.valueParsers[i].parse(this.cursor.buffer, this.cursor.fStart, this.cursor.fEnd - this.cursor.fStart, this.fieldValueBufferOutput);
                    this.areAllNullFields = false;
                }
                if (this.fldIds[i] < 0) {
                    this.recBuilder.addField((IValueReference)this.nameBuffers[i], (IValueReference)this.fieldValueBuffer);
                    continue;
                }
                this.recBuilder.addField(this.fldIds[i], (IValueReference)this.fieldValueBuffer);
                continue;
            }
            catch (IOException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
    }

    @Override
    public void parse(IRawRecord<? extends char[]> record, DataOutput out) throws HyracksDataException {
        try {
            this.cursor.nextRecord(record.get(), record.size());
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
        this.parseRecord();
        if (!this.areAllNullFields) {
            this.recBuilder.write(out, true);
        }
    }

    @Override
    public void setInputStream(InputStream in) throws IOException {
        this.cursor = new FieldCursorForDelimitedDataParser((Reader)new InputStreamReader(in), this.fieldDelimiter, this.quote);
        if (in != null && this.hasHeader) {
            this.cursor.nextRecord();
            while (this.cursor.nextField()) {
            }
        }
    }

    @Override
    public boolean reset(InputStream in) throws IOException {
        this.cursor = new FieldCursorForDelimitedDataParser((Reader)new InputStreamReader(in), this.fieldDelimiter, this.quote);
        return true;
    }
}

