/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.operators;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.active.ActiveManager;
import org.apache.asterix.active.ActiveRuntimeId;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.external.feed.dataflow.FeedRuntimeInputHandler;
import org.apache.asterix.external.feed.dataflow.SyncFeedRuntimeInputHandler;
import org.apache.asterix.external.feed.management.FeedConnectionId;
import org.apache.asterix.external.feed.policy.FeedPolicyAccessor;
import org.apache.asterix.external.operators.FeedMetaOperatorDescriptor;
import org.apache.asterix.external.util.FeedUtils;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.utils.TaskUtil;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;

public class FeedMetaComputeNodePushable
extends AbstractUnaryInputUnaryOutputOperatorNodePushable {
    private static final Logger LOGGER = Logger.getLogger(FeedMetaComputeNodePushable.class.getName());
    private AbstractUnaryInputUnaryOutputOperatorNodePushable coreOperator;
    private FeedPolicyAccessor policyAccessor;
    private FeedConnectionId connectionId;
    private int partition;
    private ActiveManager feedManager;
    private FrameTupleAccessor fta;
    private final IHyracksTaskContext ctx;
    private final FeedUtils.FeedRuntimeType runtimeType = FeedUtils.FeedRuntimeType.COMPUTE;
    private final VSizeFrame message;
    private final FeedMetaOperatorDescriptor opDesc;
    private final IRecordDescriptorProvider recordDescProvider;
    private boolean opened;

    public FeedMetaComputeNodePushable(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions, IOperatorDescriptor coreOperator, FeedConnectionId feedConnectionId, Map<String, String> feedPolicyProperties, FeedMetaOperatorDescriptor feedMetaOperatorDescriptor) throws HyracksDataException {
        this.ctx = ctx;
        this.coreOperator = (AbstractUnaryInputUnaryOutputOperatorNodePushable)((IActivity)coreOperator).createPushRuntime(ctx, recordDescProvider, partition, nPartitions);
        this.policyAccessor = new FeedPolicyAccessor(feedPolicyProperties);
        this.partition = partition;
        this.connectionId = feedConnectionId;
        this.feedManager = (ActiveManager)((INcApplicationContext)ctx.getJobletContext().getServiceContext().getApplicationContext()).getActiveManager();
        this.message = new VSizeFrame((IHyracksFrameMgrContext)ctx);
        TaskUtil.put((String)"HYX:MSG", (Object)this.message, (IHyracksTaskContext)ctx);
        this.opDesc = feedMetaOperatorDescriptor;
        this.recordDescProvider = recordDescProvider;
    }

    public void open() throws HyracksDataException {
        ActiveRuntimeId runtimeId = new ActiveRuntimeId(this.connectionId.getFeedId(), this.runtimeType.toString(), this.partition);
        try {
            this.initializeNewFeedRuntime(runtimeId);
            this.opened = true;
            this.writer.open();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HyracksDataException((Throwable)e);
        }
    }

    private void initializeNewFeedRuntime(ActiveRuntimeId runtimeId) throws Exception {
        this.fta = new FrameTupleAccessor(this.recordDescProvider.getInputRecordDescriptor(this.opDesc.getActivityId(), 0));
        FeedPolicyAccessor fpa = this.policyAccessor;
        this.coreOperator.setOutputFrameWriter(0, this.writer, this.recordDesc);
        this.writer = fpa.flowControlEnabled() ? new FeedRuntimeInputHandler(this.ctx, this.connectionId, runtimeId, (IFrameWriter)this.coreOperator, fpa, this.fta, this.feedManager.getFramePool()) : new SyncFeedRuntimeInputHandler(this.ctx, (IFrameWriter)this.coreOperator, this.fta);
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        try {
            FeedUtils.processFeedMessage(buffer, this.message, this.fta);
            this.writer.nextFrame(buffer);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void fail() throws HyracksDataException {
        this.writer.fail();
    }

    public void close() throws HyracksDataException {
        if (this.opened) {
            this.writer.close();
        }
    }

    public void flush() throws HyracksDataException {
        this.writer.flush();
    }
}

