/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.operators;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.asterix.active.ActiveManager;
import org.apache.asterix.active.ActiveRuntimeId;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.external.feed.dataflow.FeedRuntimeInputHandler;
import org.apache.asterix.external.feed.dataflow.SyncFeedRuntimeInputHandler;
import org.apache.asterix.external.feed.management.FeedConnectionId;
import org.apache.asterix.external.feed.policy.FeedPolicyAccessor;
import org.apache.asterix.external.util.FeedUtils;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;

public class FeedCollectOperatorNodePushable
extends AbstractUnaryInputUnaryOutputOperatorNodePushable {
    private final int partition;
    private final FeedConnectionId connectionId;
    private final FeedPolicyAccessor policyAccessor;
    private final ActiveManager activeManager;
    private final IHyracksTaskContext ctx;

    public FeedCollectOperatorNodePushable(IHyracksTaskContext ctx, FeedConnectionId feedConnectionId, Map<String, String> feedPolicy, int partition) {
        this.ctx = ctx;
        this.partition = partition;
        this.connectionId = feedConnectionId;
        this.policyAccessor = new FeedPolicyAccessor(feedPolicy);
        this.activeManager = (ActiveManager)((INcApplicationContext)ctx.getJobletContext().getServiceContext().getApplicationContext()).getActiveManager();
    }

    public void initialize() throws HyracksDataException {
        try {
            ActiveRuntimeId runtimeId = new ActiveRuntimeId(this.connectionId.getFeedId(), FeedUtils.FeedRuntimeType.COLLECT.toString(), this.partition);
            FrameTupleAccessor tAccessor = new FrameTupleAccessor(this.recordDesc);
            this.writer = this.policyAccessor.flowControlEnabled() ? new FeedRuntimeInputHandler(this.ctx, this.connectionId, runtimeId, this.writer, this.policyAccessor, tAccessor, this.activeManager.getFramePool()) : new SyncFeedRuntimeInputHandler(this.ctx, this.writer, tAccessor);
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void open() throws HyracksDataException {
        this.writer.open();
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.writer.nextFrame(buffer);
    }

    public void fail() throws HyracksDataException {
        this.writer.fail();
    }

    public void flush() throws HyracksDataException {
        this.writer.flush();
    }

    public void close() throws HyracksDataException {
        this.writer.close();
    }
}

