/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.operators;

import java.nio.ByteBuffer;
import org.apache.asterix.external.indexing.FilesIndexDescription;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ITwoPCIndexBulkLoader;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexBulkLoadOperatorNodePushable;
import org.apache.hyracks.storage.am.lsm.common.api.ITwoPCIndex;

public class ExternalIndexBulkModifyOperatorNodePushable
extends IndexBulkLoadOperatorNodePushable {
    private final int[] deletedFiles;
    private ArrayTupleBuilder buddyBTreeTupleBuilder = new ArrayTupleBuilder(FilesIndexDescription.FILE_BUDDY_BTREE_RECORD_DESCRIPTOR.getFieldCount());
    private AMutableInt32 fileNumber = new AMutableInt32(0);
    private ArrayTupleReference deleteTuple = new ArrayTupleReference();

    public ExternalIndexBulkModifyOperatorNodePushable(IIndexDataflowHelperFactory indexHelperFactory, IHyracksTaskContext ctx, int partition, int[] fieldPermutation, float fillFactor, boolean verifyInput, long numElementsHint, RecordDescriptor inputRecDesc, int[] deletedFiles) throws HyracksDataException {
        super(indexHelperFactory, ctx, partition, fieldPermutation, fillFactor, verifyInput, numElementsHint, false, inputRecDesc);
        this.deletedFiles = deletedFiles;
    }

    public void open() throws HyracksDataException {
        this.accessor = new FrameTupleAccessor(this.recDesc);
        this.indexHelper.open();
        this.index = this.indexHelper.getIndexInstance();
        try {
            this.writer.open();
            this.bulkLoader = ((ITwoPCIndex)this.index).createTransactionBulkLoader(this.fillFactor, this.verifyInput, (long)this.deletedFiles.length);
            for (int i = 0; i < this.deletedFiles.length; ++i) {
                this.fileNumber.setValue(this.deletedFiles[i]);
                FilesIndexDescription.getBuddyBTreeTupleFromFileNumber(this.deleteTuple, this.buddyBTreeTupleBuilder, this.fileNumber);
                ((ITwoPCIndexBulkLoader)this.bulkLoader).delete((ITupleReference)this.deleteTuple);
            }
        }
        catch (Throwable e) {
            throw new HyracksDataException(e);
        }
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.accessor.reset(buffer);
        int tupleCount = this.accessor.getTupleCount();
        for (int i = 0; i < tupleCount; ++i) {
            this.tuple.reset((IFrameTupleAccessor)this.accessor, i);
            this.bulkLoader.add((ITupleReference)this.tuple);
        }
    }

    public void close() throws HyracksDataException {
        if (this.index != null) {
            try {
                this.bulkLoader.end();
            }
            catch (Throwable th) {
                throw new HyracksDataException(th);
            }
            finally {
                try {
                    this.indexHelper.close();
                }
                finally {
                    this.writer.close();
                }
            }
        }
    }

    public void fail() throws HyracksDataException {
        if (this.index != null) {
            try {
                ((ITwoPCIndexBulkLoader)this.bulkLoader).abort();
            }
            finally {
                this.writer.fail();
            }
        }
    }
}

