/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.IFunctionHelper;
import org.apache.asterix.external.api.IJObject;
import org.apache.asterix.external.library.JTypeObjectFactory;
import org.apache.asterix.external.library.TypeInfo;
import org.apache.asterix.external.library.java.JObjectPointableVisitor;
import org.apache.asterix.external.library.java.JObjects;
import org.apache.asterix.external.library.java.JTypeTag;
import org.apache.asterix.om.functions.IExternalFunctionInfo;
import org.apache.asterix.om.pointables.AFlatValuePointable;
import org.apache.asterix.om.pointables.AListVisitablePointable;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.PointableAllocator;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.container.IObjectFactory;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.asterix.om.util.container.ListObjectPool;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IDataOutputProvider;
import org.apache.hyracks.data.std.api.IValueReference;

public class JavaFunctionHelper
implements IFunctionHelper {
    private final IExternalFunctionInfo finfo;
    private final IDataOutputProvider outputProvider;
    private final IJObject[] arguments;
    private IJObject resultHolder;
    private final IObjectPool<IJObject, IAType> objectPool = new ListObjectPool((IObjectFactory)JTypeObjectFactory.INSTANCE);
    private final JObjectPointableVisitor pointableVisitor;
    private final PointableAllocator pointableAllocator;
    private final Map<Integer, TypeInfo> poolTypeInfo;
    private boolean isValidResult = false;

    public JavaFunctionHelper(IExternalFunctionInfo finfo, IDataOutputProvider outputProvider) throws HyracksDataException {
        this.finfo = finfo;
        this.outputProvider = outputProvider;
        this.pointableVisitor = new JObjectPointableVisitor();
        this.pointableAllocator = new PointableAllocator();
        this.arguments = new IJObject[finfo.getParamList().size()];
        int index = 0;
        for (IAType param : finfo.getParamList()) {
            this.arguments[index++] = (IJObject)this.objectPool.allocate((Object)param);
        }
        this.resultHolder = (IJObject)this.objectPool.allocate((Object)finfo.getReturnType());
        this.poolTypeInfo = new HashMap<Integer, TypeInfo>();
    }

    @Override
    public IJObject getArgument(int index) {
        return this.arguments[index];
    }

    @Override
    public void setResult(IJObject result) throws HyracksDataException {
        if (result == null) {
            JObjects.JNull.INSTANCE.serialize(this.outputProvider.getDataOutput(), true);
            this.isValidResult = false;
        } else {
            this.isValidResult = true;
            result.serialize(this.outputProvider.getDataOutput(), true);
            result.reset();
        }
    }

    @Override
    public boolean isValidResult() {
        return this.isValidResult;
    }

    public void setArgument(int index, IValueReference valueReference) throws IOException, AsterixException {
        IVisitablePointable pointable = null;
        IJObject jObject = null;
        IAType type = (IAType)this.finfo.getParamList().get(index);
        switch (type.getTypeTag()) {
            case OBJECT: {
                pointable = this.pointableAllocator.allocateRecordValue(type);
                pointable.set(valueReference);
                jObject = this.pointableVisitor.visit((ARecordVisitablePointable)pointable, this.getTypeInfo(index, type));
                break;
            }
            case ARRAY: 
            case MULTISET: {
                pointable = this.pointableAllocator.allocateListValue(type);
                pointable.set(valueReference);
                jObject = this.pointableVisitor.visit((AListVisitablePointable)pointable, this.getTypeInfo(index, type));
                break;
            }
            case ANY: {
                throw new RuntimeDataException(3045, new Serializable[]{type.getTypeTag()});
            }
            default: {
                pointable = this.pointableAllocator.allocateFieldValue(type);
                pointable.set(valueReference);
                jObject = this.pointableVisitor.visit((AFlatValuePointable)pointable, this.getTypeInfo(index, type));
            }
        }
        this.arguments[index] = jObject;
    }

    private TypeInfo getTypeInfo(int index, IAType type) {
        TypeInfo typeInfo = this.poolTypeInfo.get(index);
        if (typeInfo == null) {
            typeInfo = new TypeInfo(this.objectPool, type, type.getTypeTag());
            this.poolTypeInfo.put(index, typeInfo);
        }
        return typeInfo;
    }

    @Override
    public IJObject getResultObject() {
        if (this.resultHolder == null) {
            this.resultHolder = (IJObject)this.objectPool.allocate((Object)this.finfo.getReturnType());
        }
        return this.resultHolder;
    }

    @Override
    public IJObject getObject(JTypeTag jtypeTag) throws RuntimeDataException {
        IJObject retValue = null;
        switch (jtypeTag) {
            case INT: {
                retValue = (IJObject)this.objectPool.allocate((Object)BuiltinType.AINT32);
                break;
            }
            case STRING: {
                retValue = (IJObject)this.objectPool.allocate((Object)BuiltinType.ASTRING);
                break;
            }
            case DOUBLE: {
                retValue = (IJObject)this.objectPool.allocate((Object)BuiltinType.ADOUBLE);
                break;
            }
            case NULL: {
                retValue = JObjects.JNull.INSTANCE;
                break;
            }
            default: {
                try {
                    throw new RuntimeDataException(3046, new Serializable[]{jtypeTag.name()});
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                }
            }
        }
        return retValue;
    }

    @Override
    public void reset() {
        this.pointableAllocator.reset();
        this.objectPool.reset();
    }
}

