/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs;

import java.io.IOException;
import org.apache.asterix.external.indexing.ExternalFileIndexAccessor;
import org.apache.asterix.external.indexing.RecordId;
import org.apache.asterix.external.input.record.reader.hdfs.AbstractCharRecordLookupReader;
import org.apache.asterix.external.input.record.reader.hdfs.HDFSTextLineReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class TextLookupReader
extends AbstractCharRecordLookupReader {
    private static final Logger LOGGER = Logger.getLogger((String)TextLookupReader.class.getName());
    private HDFSTextLineReader reader;

    public TextLookupReader(ExternalFileIndexAccessor snapshotAccessor, FileSystem fs, Configuration conf) {
        super(snapshotAccessor, fs, conf);
    }

    @Override
    protected void readRecord(RecordId rid) throws IOException {
        this.reader.seek(rid.getOffset());
        this.reader.readLine(this.value);
    }

    @Override
    protected void closeFile() {
        if (this.reader == null) {
            return;
        }
        try {
            this.reader.close();
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Error closing HDFS file ", (Throwable)e);
        }
    }

    @Override
    protected void openFile() throws IllegalArgumentException, IOException {
        if (this.reader == null) {
            this.reader = new HDFSTextLineReader();
        }
        this.reader.resetReader(this.fs.open(new Path(this.file.getFileName())));
    }
}

