/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.indexing;

import java.io.IOException;
import org.apache.asterix.external.api.IExternalIndexer;
import org.apache.asterix.external.api.IIndexingDatasource;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;

public class FileOffsetIndexer
implements IExternalIndexer {
    private static final long serialVersionUID = 1L;
    public static final int NUM_OF_FIELDS = 2;
    protected final AMutableInt32 fileNumber = new AMutableInt32(0);
    protected final AMutableInt64 offset = new AMutableInt64(0L);
    protected RecordReader<?, ? extends Writable> recordReader;
    private ISerializerDeserializer<IAObject> intSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
    private ISerializerDeserializer<IAObject> longSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);

    @Override
    public void reset(IIndexingDatasource dataSource) throws HyracksDataException {
        try {
            this.fileNumber.setValue(dataSource.getSnapshot().get(dataSource.getCurrentSplitIndex()).getFileNumber());
            this.recordReader = dataSource.getReader();
            this.offset.setValue(this.recordReader.getPos());
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    @Override
    public void index(ArrayTupleBuilder tb) throws HyracksDataException {
        try {
            tb.addField(this.intSerde, (Object)this.fileNumber);
            tb.addField(this.longSerde, (Object)this.offset);
            this.offset.setValue(this.recordReader.getPos());
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    @Override
    public int getNumberOfFields() {
        return 2;
    }
}

