/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.indexing;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.Serializable;
import java.util.Date;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.external.indexing.FilesIndexDescription;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ADateTime;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.btree.util.BTreeUtils;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.btree.impls.ExternalBTree;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;

public class ExternalFileIndexAccessor {
    private IIndexDataflowHelper indexDataflowHelper;
    private IHyracksTaskContext ctx;
    private ExternalBTree index;
    private ArrayTupleBuilder searchKeyTupleBuilder;
    private ArrayTupleReference searchKey;
    private AMutableInt32 currentFileNumber = new AMutableInt32(-1);
    private ISerializerDeserializer intSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
    private RangePredicate searchPredicate;
    private ILSMIndexAccessor fileIndexAccessor;
    private IIndexCursor fileIndexSearchCursor;
    private ISearchOperationCallbackFactory searchCallbackFactory;
    private int version;
    private ISerializerDeserializer externalFileRecordSerde = FilesIndexDescription.createExternalFileRecordSerde();

    public ExternalFileIndexAccessor(IIndexDataflowHelper indexDataflowHelper, ISearchOperationCallbackFactory searchCallbackFactory, int version) {
        this.indexDataflowHelper = indexDataflowHelper;
        this.searchCallbackFactory = searchCallbackFactory;
        this.version = version;
    }

    public void open() throws HyracksDataException {
        this.indexDataflowHelper.open();
        this.index = (ExternalBTree)this.indexDataflowHelper.getIndexInstance();
        this.searchKey = new ArrayTupleReference();
        this.searchKeyTupleBuilder = new ArrayTupleBuilder(1);
        this.searchKeyTupleBuilder.reset();
        this.searchKeyTupleBuilder.addField(this.intSerde, (Object)this.currentFileNumber);
        this.searchKey.reset(this.searchKeyTupleBuilder.getFieldEndOffsets(), this.searchKeyTupleBuilder.getByteArray());
        MultiComparator searchCmp = BTreeUtils.getSearchMultiComparator((IBinaryComparatorFactory[])this.index.getComparatorFactories(), (ITupleReference)this.searchKey);
        this.searchPredicate = new RangePredicate((ITupleReference)this.searchKey, (ITupleReference)this.searchKey, true, true, searchCmp, searchCmp);
        ISearchOperationCallback searchCallback = this.searchCallbackFactory.createSearchOperationCallback(this.indexDataflowHelper.getResource().getId(), this.ctx, null);
        this.fileIndexAccessor = this.index.createAccessor(searchCallback, this.version);
        this.fileIndexSearchCursor = this.fileIndexAccessor.createSearchCursor(false);
    }

    public void lookup(int fileId, ExternalFile file) throws HyracksDataException {
        this.currentFileNumber.setValue(fileId);
        this.searchKeyTupleBuilder.reset();
        this.searchKeyTupleBuilder.addField(this.intSerde, (Object)this.currentFileNumber);
        this.searchKey.reset(this.searchKeyTupleBuilder.getFieldEndOffsets(), this.searchKeyTupleBuilder.getByteArray());
        this.fileIndexSearchCursor.reset();
        this.fileIndexAccessor.search(this.fileIndexSearchCursor, (ISearchPredicate)this.searchPredicate);
        if (!this.fileIndexSearchCursor.hasNext()) {
            throw new RuntimeDataException(3052, new Serializable[0]);
        }
        this.fileIndexSearchCursor.next();
        ITupleReference tuple = this.fileIndexSearchCursor.getTuple();
        byte[] serRecord = tuple.getFieldData(1);
        int recordStartOffset = tuple.getFieldStart(1);
        int recordLength = tuple.getFieldLength(1);
        ByteArrayInputStream stream = new ByteArrayInputStream(serRecord, recordStartOffset, recordLength);
        DataInputStream in = new DataInputStream(stream);
        ARecord externalFileRecord = (ARecord)this.externalFileRecordSerde.deserialize((DataInput)in);
        this.setFile(externalFileRecord, file);
    }

    private void setFile(ARecord externalFileRecord, ExternalFile file) {
        file.setFileName(((AString)externalFileRecord.getValueByPos(0)).getStringValue());
        file.setSize(((AInt64)externalFileRecord.getValueByPos(1)).getLongValue());
        file.setLastModefiedTime(new Date(((ADateTime)externalFileRecord.getValueByPos(2)).getChrononTime()));
    }

    public void close() throws HyracksDataException {
        if (this.index != null) {
            try {
                this.fileIndexSearchCursor.close();
            }
            finally {
                this.indexDataflowHelper.close();
            }
        }
    }
}

