/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.feed.watch;

import java.util.Set;
import org.apache.asterix.active.ActiveEvent;
import org.apache.asterix.active.ActivityState;
import org.apache.asterix.active.IActiveEntityEventSubscriber;
import org.apache.asterix.active.IActiveEntityEventsListener;
import org.apache.asterix.external.feed.watch.AbstractSubscriber;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class WaitForStateSubscriber
extends AbstractSubscriber {
    private final Set<ActivityState> targetStates;

    public WaitForStateSubscriber(IActiveEntityEventsListener listener, Set<ActivityState> targetStates) throws HyracksDataException {
        super(listener);
        this.targetStates = targetStates;
        listener.subscribe((IActiveEntityEventSubscriber)this);
    }

    public void notify(ActiveEvent event) throws HyracksDataException {
        if (this.targetStates.contains(this.listener.getState())) {
            if (this.listener.getState() == ActivityState.PERMANENTLY_FAILED || this.listener.getState() == ActivityState.TEMPORARILY_FAILED) {
                this.complete(this.listener.getJobFailure());
            } else {
                this.complete(null);
            }
        } else if (event != null && event.getEventKind() == ActiveEvent.Kind.FAILURE) {
            try {
                this.complete((Exception)event.getEventObject());
            }
            catch (Exception e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }

    public void subscribed(IActiveEntityEventsListener eventsListener) throws HyracksDataException {
        if (this.targetStates.contains(this.listener.getState())) {
            this.complete(null);
        }
    }
}

