/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.feed.watch;

import org.apache.asterix.active.IActiveEntityEventSubscriber;
import org.apache.asterix.active.IActiveEntityEventsListener;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public abstract class AbstractSubscriber
implements IActiveEntityEventSubscriber {
    protected final IActiveEntityEventsListener listener;
    private volatile boolean done = false;
    private volatile Exception failure = null;

    public AbstractSubscriber(IActiveEntityEventsListener listener) {
        this.listener = listener;
    }

    public boolean isDone() {
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(Exception failure) {
        IActiveEntityEventsListener iActiveEntityEventsListener = this.listener;
        synchronized (iActiveEntityEventsListener) {
            if (failure != null) {
                this.failure = failure;
            }
            this.done = true;
            this.listener.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() throws HyracksDataException, InterruptedException {
        IActiveEntityEventsListener iActiveEntityEventsListener = this.listener;
        synchronized (iActiveEntityEventsListener) {
            while (!this.done) {
                if (this.failure != null) {
                    throw HyracksDataException.create((Throwable)this.failure);
                }
                this.listener.wait();
            }
        }
    }

    public Exception getFailure() {
        return this.failure;
    }
}

