/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.feed.runtime;

import org.apache.asterix.external.dataset.adapter.FeedAdapter;
import org.apache.asterix.external.feed.runtime.AdapterRuntimeManager;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.log4j.Logger;

public class AdapterExecutor
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger((String)AdapterExecutor.class.getName());
    private final IFrameWriter writer;
    private final FeedAdapter adapter;
    private final AdapterRuntimeManager adapterManager;
    private int restartCount = 0;

    public AdapterExecutor(IFrameWriter writer, FeedAdapter adapter, AdapterRuntimeManager adapterManager) {
        this.writer = writer;
        this.adapter = adapter;
        this.adapterManager = adapterManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Starting ingestion for partition:" + this.adapterManager.getPartition()));
        }
        boolean failed = false;
        try {
            failed = this.doRun();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            failed = true;
            LOGGER.error((Object)"Unhandled Exception", (Throwable)e);
        }
        finally {
            this.adapterManager.setFailed(failed);
            this.adapterManager.setDone(true);
            AdapterRuntimeManager e = this.adapterManager;
            synchronized (e) {
                this.adapterManager.notifyAll();
            }
        }
    }

    private boolean doRun() throws HyracksDataException, InterruptedException {
        boolean continueIngestion = true;
        boolean failedIngestion = false;
        while (continueIngestion) {
            try {
                this.adapter.start(this.adapterManager.getPartition(), this.writer);
                continueIngestion = false;
            }
            catch (InterruptedException e) {
                this.adapter.fail();
                throw e;
            }
            catch (Exception e) {
                LOGGER.error((Object)"Exception during feed ingestion ", (Throwable)e);
                continueIngestion = this.adapter.handleException(e);
                if (!continueIngestion) {
                    this.adapter.fail();
                }
                failedIngestion = !continueIngestion;
                ++this.restartCount;
            }
        }
        return failedIngestion;
    }

    public String getStats() {
        return "{\"adapter-stats\": " + this.adapter.getStats() + ", \"executor-restart-times\": " + this.restartCount + "}";
    }
}

