/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.dataset.adapter;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.asterix.external.api.ILookupRecordReader;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.external.indexing.RecordId;
import org.apache.asterix.external.indexing.RecordIdReader;
import org.apache.asterix.external.util.DataflowUtils;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IMissingWriter;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;

public final class LookupAdapter<T>
implements IFrameWriter {
    private boolean propagateInput;
    private boolean retainNull;
    private ArrayTupleBuilder tb;
    private FrameTupleAppender appender;
    private IRecordDataParser<T> dataParser;
    private ILookupRecordReader<? extends T> recordReader;
    private RecordIdReader ridReader;
    private FrameTupleAccessor tupleAccessor;
    private IFrameWriter writer;
    private FrameTupleReference frameTuple;
    private ArrayTupleBuilder missingTupleBuild;

    public LookupAdapter(IRecordDataParser<T> dataParser, ILookupRecordReader<? extends T> recordReader, RecordDescriptor inRecDesc, RecordIdReader ridReader, boolean propagateInput, boolean retainNull, IMissingWriterFactory iNullWriterFactory, IHyracksTaskContext ctx, IFrameWriter writer) throws HyracksDataException {
        this.dataParser = dataParser;
        this.recordReader = recordReader;
        this.propagateInput = propagateInput;
        this.retainNull = retainNull;
        this.tupleAccessor = new FrameTupleAccessor(inRecDesc);
        this.ridReader = ridReader;
        ridReader.set(this.tupleAccessor, inRecDesc);
        this.configurePropagation(iNullWriterFactory);
        this.appender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)ctx));
        this.writer = writer;
    }

    private void configurePropagation(IMissingWriterFactory iNullWriterFactory) {
        if (this.propagateInput) {
            this.tb = new ArrayTupleBuilder(this.tupleAccessor.getFieldCount() + 1);
            this.frameTuple = new FrameTupleReference();
        } else {
            this.tb = new ArrayTupleBuilder(1);
        }
        if (this.retainNull) {
            IMissingWriter missingWriter = iNullWriterFactory.createMissingWriter();
            this.missingTupleBuild = new ArrayTupleBuilder(1);
            DataOutput out = this.missingTupleBuild.getDataOutput();
            try {
                missingWriter.writeMissing(out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.missingTupleBuild = null;
        }
    }

    public void fail() throws HyracksDataException {
        try {
            this.recordReader.fail();
        }
        catch (Throwable th) {
            throw new HyracksDataException(th);
        }
        finally {
            this.writer.fail();
        }
    }

    public void open() throws HyracksDataException {
        this.writer.open();
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        try {
            this.tupleAccessor.reset(buffer);
            int tupleCount = this.tupleAccessor.getTupleCount();
            for (int tupleIndex = 0; tupleIndex < tupleCount; ++tupleIndex) {
                IRawRecord<? extends T> record = null;
                RecordId rid = this.ridReader.read(tupleIndex);
                if (rid != null) {
                    record = this.recordReader.read(rid);
                }
                this.tb.reset();
                if (this.propagateInput) {
                    this.propagateInputFields(tupleIndex);
                }
                if (record != null) {
                    this.dataParser.parse(record, this.tb.getDataOutput());
                    this.tb.addFieldEndOffset();
                    DataflowUtils.addTupleToFrame(this.appender, this.tb, this.writer);
                    continue;
                }
                if (!this.retainNull) continue;
                this.tb.getDataOutput().write(this.missingTupleBuild.getByteArray());
                this.tb.addFieldEndOffset();
                DataflowUtils.addTupleToFrame(this.appender, this.tb, this.writer);
            }
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    private void propagateInputFields(int idx) throws IOException {
        this.frameTuple.reset((IFrameTupleAccessor)this.tupleAccessor, idx);
        for (int i = 0; i < this.frameTuple.getFieldCount(); ++i) {
            this.tb.getDataOutput().write(this.frameTuple.getFieldData(i), this.frameTuple.getFieldStart(i), this.frameTuple.getFieldLength(i));
            this.tb.addFieldEndOffset();
        }
    }

    public void close() throws HyracksDataException {
        try {
            this.appender.write(this.writer, true);
        }
        catch (Exception e) {
            this.writer.fail();
            throw e;
        }
        finally {
            this.writer.close();
        }
    }

    public void flush() throws HyracksDataException {
        this.appender.flush(this.writer);
    }
}

