/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.api;

import java.io.DataOutput;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.builders.UnorderedListBuilder;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableOrderedList;
import org.apache.asterix.om.base.AMutableRecord;
import org.apache.asterix.om.base.AMutableUnorderedList;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public interface IDataParser {
    public static void writeRecord(AMutableRecord record, DataOutput dataOutput, IARecordBuilder recordBuilder) throws HyracksDataException {
        ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
        int numFields = record.getType().getFieldNames().length;
        for (int pos = 0; pos < numFields; ++pos) {
            fieldValue.reset();
            IAObject obj = record.getValueByPos(pos);
            IDataParser.writeObject(obj, fieldValue.getDataOutput());
            recordBuilder.addField(pos, (IValueReference)fieldValue);
        }
        recordBuilder.write(dataOutput, true);
    }

    public static void writeObject(IAObject obj, DataOutput dataOutput) throws HyracksDataException {
        switch (obj.getType().getTypeTag()) {
            case OBJECT: {
                RecordBuilder recordBuilder = new RecordBuilder();
                recordBuilder.reset((ARecordType)obj.getType());
                recordBuilder.init();
                IDataParser.writeRecord((AMutableRecord)obj, dataOutput, (IARecordBuilder)recordBuilder);
                break;
            }
            case ARRAY: {
                OrderedListBuilder listBuilder = new OrderedListBuilder();
                listBuilder.reset((AbstractCollectionType)((AOrderedListType)((AMutableOrderedList)obj).getType()));
                IACursor cursor = ((AMutableOrderedList)obj).getCursor();
                ArrayBackedValueStorage listItemValue = new ArrayBackedValueStorage();
                while (cursor.next()) {
                    listItemValue.reset();
                    IAObject item = cursor.get();
                    IDataParser.writeObject(item, listItemValue.getDataOutput());
                    listBuilder.addItem((IValueReference)listItemValue);
                }
                listBuilder.write(dataOutput, true);
                break;
            }
            case MULTISET: {
                UnorderedListBuilder listBuilder = new UnorderedListBuilder();
                listBuilder.reset((AbstractCollectionType)((AUnorderedListType)((AMutableUnorderedList)obj).getType()));
                IACursor cursor = ((AMutableUnorderedList)obj).getCursor();
                ArrayBackedValueStorage listItemValue = new ArrayBackedValueStorage();
                while (cursor.next()) {
                    listItemValue.reset();
                    IAObject item = cursor.get();
                    IDataParser.writeObject(item, listItemValue.getDataOutput());
                    listBuilder.addItem((IValueReference)listItemValue);
                }
                listBuilder.write(dataOutput, true);
                break;
            }
            default: {
                SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)obj.getType()).serialize((Object)obj, dataOutput);
            }
        }
    }

    public static <T> void toBytes(T serializable, ArrayBackedValueStorage buffer, ISerializerDeserializer<T> serde) throws HyracksDataException {
        buffer.reset();
        DataOutput out = buffer.getDataOutput();
        serde.serialize(serializable, out);
    }
}

