/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.entitytupletranslators;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.builders.UnorderedListBuilder;
import org.apache.asterix.common.exceptions.MetadataException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.metadata.entities.FeedPolicyEntity;
import org.apache.asterix.metadata.entitytupletranslators.AbstractTupleTranslator;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.AUnorderedList;
import org.apache.asterix.om.base.IACursor;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class FeedPolicyTupleTranslator
extends AbstractTupleTranslator<FeedPolicyEntity> {
    public static final int FEED_POLICY_DATAVERSE_NAME_FIELD_INDEX = 0;
    public static final int FEED_POLICY_POLICY_NAME_FIELD_INDEX = 1;
    public static final int FEED_POLICY_PAYLOAD_TUPLE_FIELD_INDEX = 2;
    private ISerializerDeserializer<ARecord> recordSerDes = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)MetadataRecordTypes.FEED_POLICY_RECORDTYPE);
    protected ISerializerDeserializer<AInt32> aInt32Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);

    protected FeedPolicyTupleTranslator(boolean getTuple) {
        super(getTuple, MetadataPrimaryIndexes.FEED_POLICY_DATASET.getFieldCount());
    }

    @Override
    public FeedPolicyEntity getMetadataEntityFromTuple(ITupleReference frameTuple) throws HyracksDataException {
        byte[] serRecord = frameTuple.getFieldData(2);
        int recordStartOffset = frameTuple.getFieldStart(2);
        int recordLength = frameTuple.getFieldLength(2);
        ByteArrayInputStream stream = new ByteArrayInputStream(serRecord, recordStartOffset, recordLength);
        DataInputStream in = new DataInputStream(stream);
        ARecord feedPolicyRecord = (ARecord)this.recordSerDes.deserialize((DataInput)in);
        return this.createFeedPolicyFromARecord(feedPolicyRecord);
    }

    private FeedPolicyEntity createFeedPolicyFromARecord(ARecord feedPolicyRecord) {
        FeedPolicyEntity feedPolicy = null;
        String dataverseName = ((AString)feedPolicyRecord.getValueByPos(0)).getStringValue();
        String policyName = ((AString)feedPolicyRecord.getValueByPos(1)).getStringValue();
        String description = ((AString)feedPolicyRecord.getValueByPos(2)).getStringValue();
        IACursor cursor = ((AUnorderedList)feedPolicyRecord.getValueByPos(3)).getCursor();
        HashMap<String, String> policyParamters = new HashMap<String, String>();
        while (cursor.next()) {
            ARecord field = (ARecord)cursor.get();
            String key = ((AString)field.getValueByPos(0)).getStringValue();
            String value = ((AString)field.getValueByPos(1)).getStringValue();
            policyParamters.put(key, value);
        }
        feedPolicy = new FeedPolicyEntity(dataverseName, policyName, description, policyParamters);
        return feedPolicy;
    }

    @Override
    public ITupleReference getTupleFromMetadataEntity(FeedPolicyEntity feedPolicy) throws HyracksDataException, MetadataException {
        ArrayBackedValueStorage itemValue = new ArrayBackedValueStorage();
        this.tupleBuilder.reset();
        this.aString.setValue(feedPolicy.getDataverseName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.aString.setValue(feedPolicy.getPolicyName());
        this.stringSerde.serialize((Object)this.aString, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(MetadataRecordTypes.FEED_POLICY_RECORDTYPE);
        this.fieldValue.reset();
        this.aString.setValue(feedPolicy.getDataverseName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(0, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(feedPolicy.getPolicyName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aString.setValue(feedPolicy.getDescription());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        Map properties = feedPolicy.getProperties();
        UnorderedListBuilder listBuilder = new UnorderedListBuilder();
        listBuilder.reset((AbstractCollectionType)((AUnorderedListType)MetadataRecordTypes.FEED_POLICY_RECORDTYPE.getFieldTypes()[3]));
        for (Map.Entry property : properties.entrySet()) {
            String name = (String)property.getKey();
            String value = (String)property.getValue();
            itemValue.reset();
            this.writePropertyTypeRecord(name, value, itemValue.getDataOutput());
            listBuilder.addItem((IValueReference)itemValue);
        }
        this.fieldValue.reset();
        listBuilder.write(this.fieldValue.getDataOutput(), true);
        this.recordBuilder.addField(3, (IValueReference)this.fieldValue);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }

    public void writePropertyTypeRecord(String name, String value, DataOutput out) throws HyracksDataException {
        RecordBuilder propertyRecordBuilder = new RecordBuilder();
        ArrayBackedValueStorage fieldValue = new ArrayBackedValueStorage();
        propertyRecordBuilder.reset(MetadataRecordTypes.POLICY_PARAMS_RECORDTYPE);
        AMutableString aString = new AMutableString("");
        ISerializerDeserializer stringSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
        fieldValue.reset();
        aString.setValue(name);
        stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        propertyRecordBuilder.addField(0, (IValueReference)fieldValue);
        fieldValue.reset();
        aString.setValue(value);
        stringSerde.serialize((Object)aString, fieldValue.getDataOutput());
        propertyRecordBuilder.addField(1, (IValueReference)fieldValue);
        propertyRecordBuilder.write(out, true);
    }
}

