/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.event.util;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.asterix.event.driver.EventDriver;
import org.apache.asterix.event.error.VerificationUtil;
import org.apache.asterix.event.model.AsterixInstance;
import org.apache.asterix.event.model.BackupInfo;
import org.apache.asterix.event.schema.cluster.Cluster;
import org.apache.asterix.event.schema.cluster.Node;
import org.apache.asterix.event.schema.pattern.Delay;
import org.apache.asterix.event.schema.pattern.Event;
import org.apache.asterix.event.schema.pattern.Nodeid;
import org.apache.asterix.event.schema.pattern.Pattern;
import org.apache.asterix.event.schema.pattern.Patterns;
import org.apache.asterix.event.schema.pattern.Value;
import org.apache.asterix.event.service.AsterixEventService;
import org.apache.asterix.installer.schema.conf.Backup;

public class PatternCreator {
    public static final PatternCreator INSTANCE = new PatternCreator();

    private PatternCreator() {
    }

    private void addInitialDelay(Pattern p, int delay, String unit) {
        Delay d = new Delay(new Value(null, Integer.toString(delay)), unit);
        p.setDelay(d);
    }

    public Patterns getAsterixBinaryTransferPattern(String asterixInstanceName, Cluster cluster) throws Exception {
        String ccLocationIp = cluster.getMasterNode().getClusterIp();
        String destDir = cluster.getWorkingDir().getDir() + File.separator + "asterix";
        ArrayList<Pattern> ps = new ArrayList<Pattern>();
        Pattern copyHyracks = this.createCopyHyracksPattern(asterixInstanceName, cluster, ccLocationIp, destDir);
        ps.add(copyHyracks);
        boolean copyHyracksToNC = !cluster.getWorkingDir().isNFS();
        for (Node node : cluster.getNode()) {
            if (!copyHyracksToNC) continue;
            Pattern copyHyracksForNC = this.createCopyHyracksPattern(asterixInstanceName, cluster, node.getClusterIp(), destDir);
            ps.add(copyHyracksForNC);
        }
        ps.addAll(this.createHadoopLibraryTransferPattern(cluster).getPattern());
        return new Patterns(ps);
    }

    public Patterns getStartAsterixPattern(String asterixInstanceName, Cluster cluster, boolean createCommand) throws Exception {
        String ccLocationId = cluster.getMasterNode().getId();
        ArrayList<Pattern> ps = new ArrayList<Pattern>();
        Pattern createCC = this.createCCStartPattern(ccLocationId);
        this.addInitialDelay(createCC, 3, "sec");
        ps.add(createCC);
        for (Node node : cluster.getNode()) {
            String iodevices = node.getIodevices() == null ? cluster.getIodevices() : node.getIodevices();
            Pattern createNC = this.createNCStartPattern(cluster.getMasterNode().getClusterIp(), node.getId(), asterixInstanceName + "_" + node.getId(), iodevices, createCommand);
            this.addInitialDelay(createNC, 5, "sec");
            ps.add(createNC);
        }
        return new Patterns(ps);
    }

    public Patterns getBackUpAsterixPattern(AsterixInstance instance, Backup backupConf) throws Exception {
        BackupInfo.BackupType backupType = BackupInfo.getBackupType(backupConf);
        Patterns patterns = null;
        switch (backupType) {
            case HDFS: {
                patterns = this.getHDFSBackUpAsterixPattern(instance, backupConf);
                break;
            }
            case LOCAL: {
                patterns = this.getLocalBackUpAsterixPattern(instance, backupConf);
            }
        }
        return patterns;
    }

    public Patterns getRestoreAsterixPattern(AsterixInstance instance, BackupInfo backupInfo) throws Exception {
        BackupInfo.BackupType backupType = backupInfo.getBackupType();
        Patterns patterns = null;
        switch (backupType) {
            case HDFS: {
                patterns = this.getHDFSRestoreAsterixPattern(instance, backupInfo);
                break;
            }
            case LOCAL: {
                patterns = this.getLocalRestoreAsterixPattern(instance, backupInfo);
            }
        }
        return patterns;
    }

    private Patterns getHDFSBackUpAsterixPattern(AsterixInstance instance, Backup backupConf) throws Exception {
        Cluster cluster = instance.getCluster();
        String hdfsUrl = backupConf.getHdfs().getUrl();
        String hadoopVersion = backupConf.getHdfs().getVersion();
        String hdfsBackupDir = backupConf.getBackupDir();
        VerificationUtil.verifyBackupRestoreConfiguration(hdfsUrl, hadoopVersion, hdfsBackupDir);
        String workingDir = cluster.getWorkingDir().getDir();
        String backupId = Integer.toString(instance.getBackupInfo().size());
        String store = cluster.getStore();
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        for (Node node : cluster.getNode()) {
            Nodeid nodeid = new Nodeid(new Value(null, node.getId()));
            String iodevices = node.getIodevices() == null ? instance.getCluster().getIodevices() : node.getIodevices();
            String pargs = workingDir + " " + instance.getName() + " " + iodevices + " " + store + " " + "root_metadata" + " " + "txnLogs" + " " + backupId + " " + hdfsBackupDir + " hdfs " + node.getId() + " " + hdfsUrl + " " + hadoopVersion;
            Event event = new Event("backup", nodeid, pargs);
            patternList.add(new Pattern(null, 1, null, event));
        }
        return new Patterns(patternList);
    }

    private Patterns getLocalBackUpAsterixPattern(AsterixInstance instance, Backup backupConf) throws Exception {
        Cluster cluster = instance.getCluster();
        String backupDir = backupConf.getBackupDir();
        String workingDir = cluster.getWorkingDir().getDir();
        String backupId = Integer.toString(instance.getBackupInfo().size());
        String store = cluster.getStore();
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        for (Node node : cluster.getNode()) {
            Nodeid nodeid = new Nodeid(new Value(null, node.getId()));
            String iodevices = node.getIodevices() == null ? instance.getCluster().getIodevices() : node.getIodevices();
            String txnLogDir = node.getTxnLogDir() == null ? instance.getCluster().getTxnLogDir() : node.getTxnLogDir();
            String pargs = workingDir + " " + instance.getName() + " " + iodevices + " " + store + " " + "root_metadata" + " " + txnLogDir + " " + backupId + " " + backupDir + " local " + node.getId();
            Event event = new Event("backup", nodeid, pargs);
            patternList.add(new Pattern(null, 1, null, event));
        }
        return new Patterns(patternList);
    }

    public Patterns getHDFSRestoreAsterixPattern(AsterixInstance instance, BackupInfo backupInfo) throws Exception {
        Cluster cluster = instance.getCluster();
        String clusterStore = instance.getCluster().getStore();
        String hdfsUrl = backupInfo.getBackupConf().getHdfs().getUrl();
        String hadoopVersion = backupInfo.getBackupConf().getHdfs().getVersion();
        String hdfsBackupDir = backupInfo.getBackupConf().getBackupDir();
        VerificationUtil.verifyBackupRestoreConfiguration(hdfsUrl, hadoopVersion, hdfsBackupDir);
        String workingDir = cluster.getWorkingDir().getDir();
        int backupId = backupInfo.getId();
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        for (Node node : cluster.getNode()) {
            Nodeid nodeid = new Nodeid(new Value(null, node.getId()));
            String iodevices = node.getIodevices() == null ? cluster.getIodevices() : node.getIodevices();
            String pargs = workingDir + " " + instance.getName() + " " + iodevices + " " + clusterStore + " " + "root_metadata" + " " + "txnLogs" + " " + backupId + "  " + hdfsBackupDir + " hdfs " + node.getId() + " " + hdfsUrl + " " + hadoopVersion;
            Event event = new Event("restore", nodeid, pargs);
            patternList.add(new Pattern(null, 1, null, event));
        }
        return new Patterns(patternList);
    }

    public Patterns getLocalRestoreAsterixPattern(AsterixInstance instance, BackupInfo backupInfo) throws Exception {
        Cluster cluster = instance.getCluster();
        String clusterStore = instance.getCluster().getStore();
        String backupDir = backupInfo.getBackupConf().getBackupDir();
        String workingDir = cluster.getWorkingDir().getDir();
        int backupId = backupInfo.getId();
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        for (Node node : cluster.getNode()) {
            Nodeid nodeid = new Nodeid(new Value(null, node.getId()));
            String iodevices = node.getIodevices() == null ? cluster.getIodevices() : node.getIodevices();
            String pargs = workingDir + " " + instance.getName() + " " + iodevices + " " + clusterStore + " " + "root_metadata" + " " + "txnLogs" + " " + backupId + " " + backupDir + " local " + node.getId();
            Event event = new Event("restore", nodeid, pargs);
            patternList.add(new Pattern(null, 1, null, event));
        }
        return new Patterns(patternList);
    }

    public Patterns createHadoopLibraryTransferPattern(Cluster cluster) throws Exception {
        boolean copyToNC;
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        String workingDir = cluster.getWorkingDir().getDir();
        String hadoopVersion = AsterixEventService.getConfiguration().getBackup().getHdfs().getVersion();
        File hadoopDir = new File(AsterixEventService.getEventHome() + File.separator + "hadoop-" + hadoopVersion);
        if (!hadoopDir.exists()) {
            throw new IllegalStateException("Hadoop version :" + hadoopVersion + " not supported");
        }
        Nodeid nodeid = new Nodeid(new Value(null, EventDriver.CLIENT_NODE.getId()));
        String username = cluster.getUsername() != null ? cluster.getUsername() : System.getProperty("user.name");
        String pargs = username + " " + hadoopDir.getAbsolutePath() + " " + cluster.getMasterNode().getClusterIp() + " " + workingDir;
        Event event = new Event("directory_transfer", nodeid, pargs);
        Pattern p = new Pattern(null, 1, null, event);
        this.addInitialDelay(p, 2, "sec");
        patternList.add(p);
        boolean bl = copyToNC = !cluster.getWorkingDir().isNFS();
        if (copyToNC) {
            for (Node node : cluster.getNode()) {
                nodeid = new Nodeid(new Value(null, node.getId()));
                pargs = cluster.getUsername() + " " + hadoopDir.getAbsolutePath() + " " + node.getClusterIp() + " " + workingDir;
                event = new Event("directory_transfer", nodeid, pargs);
                p = new Pattern(null, 1, null, event);
                this.addInitialDelay(p, 2, "sec");
                patternList.add(p);
            }
        }
        return new Patterns(patternList);
    }

    public Patterns createDeleteInstancePattern(AsterixInstance instance) throws Exception {
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        patternList.addAll(this.createRemoveAsterixStoragePattern(instance).getPattern());
        if (instance.getBackupInfo() != null && !instance.getBackupInfo().isEmpty()) {
            List<BackupInfo> backups = instance.getBackupInfo();
            HashSet<String> removedBackupDirsHDFS = new HashSet<String>();
            HashSet<String> removedBackupDirsLocal = new HashSet<String>();
            for (BackupInfo binfo : backups) {
                String backupDir = binfo.getBackupConf().getBackupDir();
                switch (binfo.getBackupType()) {
                    case HDFS: {
                        if (removedBackupDirsHDFS.contains(backupDir)) break;
                        patternList.addAll(this.createRemoveHDFSBackupPattern(instance, backupDir).getPattern());
                        removedBackupDirsHDFS.add(backupDir);
                        break;
                    }
                    case LOCAL: {
                        if (removedBackupDirsLocal.contains(backupDir)) break;
                        patternList.addAll(this.createRemoveLocalBackupPattern(instance, backupDir).getPattern());
                        removedBackupDirsLocal.add(backupDir);
                    }
                }
            }
        }
        patternList.addAll(this.createRemoveAsterixLogDirPattern(instance).getPattern());
        patternList.addAll(this.createRemoveAsterixRootMetadata(instance).getPattern());
        patternList.addAll(this.createRemoveAsterixTxnLogs(instance).getPattern());
        return new Patterns(patternList);
    }

    private Patterns createRemoveAsterixTxnLogs(AsterixInstance instance) throws Exception {
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        Cluster cluster = instance.getCluster();
        for (Node node : cluster.getNode()) {
            String txnLogDir = node.getTxnLogDir() == null ? cluster.getTxnLogDir() : node.getTxnLogDir();
            Nodeid nodeid = new Nodeid(new Value(null, node.getId()));
            Event event = new Event("file_delete", nodeid, txnLogDir);
            patternList.add(new Pattern(null, 1, null, event));
        }
        return new Patterns(patternList);
    }

    private Patterns createRemoveHDFSBackupPattern(AsterixInstance instance, String hdfsBackupDir) throws Exception {
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        Cluster cluster = instance.getCluster();
        String hdfsUrl = AsterixEventService.getConfiguration().getBackup().getHdfs().getUrl();
        String hadoopVersion = AsterixEventService.getConfiguration().getBackup().getHdfs().getVersion();
        String workingDir = cluster.getWorkingDir().getDir();
        Node launchingNode = (Node)cluster.getNode().get(0);
        Nodeid nodeid = new Nodeid(new Value(null, launchingNode.getId()));
        String pathToDelete = hdfsBackupDir + File.separator + instance.getName();
        String pargs = workingDir + " " + hadoopVersion + " " + hdfsUrl + " " + pathToDelete;
        Event event = new Event("hdfs_delete", nodeid, pargs);
        patternList.add(new Pattern(null, 1, null, event));
        return new Patterns(patternList);
    }

    private Patterns createRemoveLocalBackupPattern(AsterixInstance instance, String localBackupDir) throws Exception {
        String pathToDelete;
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        Cluster cluster = instance.getCluster();
        String pargs = pathToDelete = localBackupDir + File.separator + instance.getName();
        ArrayList<String> removedBackupDirs = new ArrayList<String>();
        for (Node node : cluster.getNode()) {
            if (removedBackupDirs.contains(node.getClusterIp())) continue;
            Nodeid nodeid = new Nodeid(new Value(null, node.getId()));
            Event event = new Event("file_delete", nodeid, pargs);
            patternList.add(new Pattern(null, 1, null, event));
            removedBackupDirs.add(node.getClusterIp());
        }
        return new Patterns(patternList);
    }

    public Patterns createRemoveAsterixWorkingDirPattern(AsterixInstance instance) throws Exception {
        String workingDir;
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        Cluster cluster = instance.getCluster();
        String pargs = workingDir = cluster.getWorkingDir().getDir();
        Nodeid nodeid = new Nodeid(new Value(null, cluster.getMasterNode().getId()));
        Event event = new Event("file_delete", nodeid, pargs);
        patternList.add(new Pattern(null, 1, null, event));
        if (!cluster.getWorkingDir().isNFS()) {
            for (Node node : cluster.getNode()) {
                nodeid = new Nodeid(new Value(null, node.getId()));
                event = new Event("file_delete", nodeid, pargs);
                patternList.add(new Pattern(null, 1, null, event));
            }
        }
        return new Patterns(patternList);
    }

    public Patterns getLibraryInstallPattern(AsterixInstance instance, String dataverse, String libraryName, String libraryPath) throws Exception {
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        Cluster cluster = instance.getCluster();
        Nodeid nodeid = new Nodeid(new Value(null, EventDriver.CLIENT_NODE.getId()));
        String username = cluster.getUsername() != null ? cluster.getUsername() : System.getProperty("user.name");
        String workingDir = cluster.getWorkingDir().getDir();
        String destDir = workingDir + File.separator + "library" + File.separator + dataverse + File.separator + libraryName;
        String fileToTransfer = new File(libraryPath).getAbsolutePath();
        Iterator installTargets = cluster.getNode().iterator();
        Node installNode = (Node)installTargets.next();
        String destinationIp = installNode.getClusterIp();
        String pargs = username + " " + fileToTransfer + " " + destinationIp + " " + destDir + " unpack";
        Event event = new Event("file_transfer", nodeid, pargs);
        Pattern p = new Pattern(null, 1, null, event);
        patternList.add(p);
        if (!cluster.getWorkingDir().isNFS()) {
            while (installTargets.hasNext()) {
                Node node = (Node)installTargets.next();
                pargs = username + " " + fileToTransfer + " " + node.getClusterIp() + " " + destDir + " unpack";
                event = new Event("file_transfer", nodeid, pargs);
                p = new Pattern(null, 1, null, event);
                patternList.add(p);
            }
            pargs = username + " " + fileToTransfer + " " + cluster.getMasterNode().getClusterIp() + " " + destDir + " unpack";
            event = new Event("file_transfer", nodeid, pargs);
            p = new Pattern(null, 1, null, event);
            patternList.add(p);
        }
        return new Patterns(patternList);
    }

    public Patterns getLibraryUninstallPattern(AsterixInstance instance, String dataverse, String libraryName) throws Exception {
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        Cluster cluster = instance.getCluster();
        String workingDir = cluster.getWorkingDir().getDir();
        String destFile = dataverse + "." + libraryName;
        String pargs = workingDir + File.separator + "uninstall " + destFile;
        String metadataNodeId = instance.getMetadataNodeId();
        Nodeid nodeid = new Nodeid(new Value(null, metadataNodeId));
        Event event = new Event("file_create", nodeid, pargs);
        Pattern p = new Pattern(null, 1, null, event);
        patternList.add(p);
        Iterator uninstallTargets = cluster.getNode().iterator();
        String libDir = workingDir + File.separator + "library" + File.separator + dataverse + File.separator + libraryName;
        Node uninstallNode = (Node)uninstallTargets.next();
        nodeid = new Nodeid(new Value(null, uninstallNode.getId()));
        event = new Event("file_delete", nodeid, libDir);
        p = new Pattern(null, 1, null, event);
        patternList.add(p);
        pargs = libDir;
        if (!cluster.getWorkingDir().isNFS()) {
            while (uninstallTargets.hasNext()) {
                uninstallNode = (Node)uninstallTargets.next();
                nodeid = new Nodeid(new Value(null, uninstallNode.getId()));
                event = new Event("file_delete", nodeid, pargs);
                p = new Pattern(null, 1, null, event);
                patternList.add(p);
            }
            nodeid = new Nodeid(new Value(null, cluster.getMasterNode().getId()));
            event = new Event("file_delete", nodeid, pargs);
            p = new Pattern(null, 1, null, event);
            patternList.add(p);
        }
        return new Patterns(patternList);
    }

    private Patterns createRemoveAsterixRootMetadata(AsterixInstance instance) throws Exception {
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        Cluster cluster = instance.getCluster();
        for (Node node : cluster.getNode()) {
            String iodevices = node.getIodevices() == null ? cluster.getIodevices() : node.getIodevices();
            String primaryIODevice = iodevices.split(",")[0].trim();
            String pargs = primaryIODevice + File.separator + "root_metadata";
            Nodeid nodeid = new Nodeid(new Value(null, node.getId()));
            Event event = new Event("file_delete", nodeid, pargs);
            patternList.add(new Pattern(null, 1, null, event));
        }
        return new Patterns(patternList);
    }

    private Patterns createRemoveAsterixLogDirPattern(AsterixInstance instance) throws Exception {
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        Cluster cluster = instance.getCluster();
        String pargs = instance.getCluster().getLogDir();
        Nodeid nodeid = new Nodeid(new Value(null, cluster.getMasterNode().getId()));
        Event event = new Event("file_delete", nodeid, pargs);
        patternList.add(new Pattern(null, 1, null, event));
        for (Node node : cluster.getNode()) {
            nodeid = new Nodeid(new Value(null, node.getId()));
            if (node.getLogDir() != null) {
                pargs = node.getLogDir();
            }
            event = new Event("file_delete", nodeid, pargs);
            patternList.add(new Pattern(null, 1, null, event));
        }
        return new Patterns(patternList);
    }

    private Patterns createRemoveAsterixStoragePattern(AsterixInstance instance) throws Exception {
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        Cluster cluster = instance.getCluster();
        for (Node node : cluster.getNode()) {
            Nodeid nodeid = new Nodeid(new Value(null, node.getId()));
            String iodevices = node.getIodevices() == null ? cluster.getIodevices() : node.getIodevices();
            String[] nodeIODevices = iodevices.trim().split(",");
            String nodeStore = cluster.getStore().trim();
            for (String nodeIODevice : nodeIODevices) {
                String pargs = nodeIODevice.trim() + File.separator + nodeStore;
                Event event = new Event("file_delete", nodeid, pargs);
                patternList.add(new Pattern(null, 1, null, event));
            }
        }
        return new Patterns(patternList);
    }

    private Pattern createCopyHyracksPattern(String instanceName, Cluster cluster, String destinationIp, String destDir) {
        Nodeid nodeid = new Nodeid(new Value(null, EventDriver.CLIENT_NODE.getId()));
        String username = cluster.getUsername() != null ? cluster.getUsername() : System.getProperty("user.name");
        String asterixZipName = AsterixEventService.getAsterixZip().substring(AsterixEventService.getAsterixZip().lastIndexOf(File.separator) + 1);
        String fileToTransfer = new File(AsterixEventService.getAsterixDir() + File.separator + instanceName + File.separator + asterixZipName).getAbsolutePath();
        String pargs = username + " " + fileToTransfer + " " + destinationIp + " " + destDir + " unpack";
        Event event = new Event("file_transfer", nodeid, pargs);
        return new Pattern(null, 1, null, event);
    }

    private Pattern createCCStartPattern(String hostId) {
        Nodeid nodeid = new Nodeid(new Value(null, hostId));
        Event event = new Event("cc_start", nodeid, "");
        return new Pattern(null, 1, null, event);
    }

    public Pattern createCCStopPattern(String hostId) {
        Nodeid nodeid = new Nodeid(new Value(null, hostId));
        Event event = new Event("cc_failure", nodeid, null);
        return new Pattern(null, 1, null, event);
    }

    public Pattern createNCStartPattern(String ccHost, String hostId, String nodeControllerId, String iodevices, boolean isInitialRun) {
        Nodeid nodeid = new Nodeid(new Value(null, hostId));
        String pargs = ccHost + " " + nodeControllerId + " " + iodevices;
        if (isInitialRun) {
            pargs = pargs + " -initial-run";
        }
        Event event = new Event("node_join", nodeid, pargs);
        return new Pattern(null, 1, null, event);
    }

    public Pattern createNCStopPattern(String hostId, String nodeControllerId) {
        Nodeid nodeid = new Nodeid(new Value(null, hostId));
        Event event = new Event("node_failure", nodeid, nodeControllerId);
        return new Pattern(null, 1, null, event);
    }

    public Patterns createPrepareNodePattern(String instanceName, Cluster cluster, Node nodeToBeAdded) {
        ArrayList<Pattern> ps = new ArrayList<Pattern>();
        boolean workingDirOnNFS = cluster.getWorkingDir().isNFS();
        if (!workingDirOnNFS) {
            String ccLocationIp = cluster.getMasterNode().getClusterIp();
            String destDir = cluster.getWorkingDir().getDir() + File.separator + "asterix";
            Pattern copyHyracks = this.createCopyHyracksPattern(instanceName, cluster, ccLocationIp, destDir);
            ps.add(copyHyracks);
            String workingDir = cluster.getWorkingDir().getDir();
            String hadoopVersion = AsterixEventService.getConfiguration().getBackup().getHdfs().getVersion();
            File hadoopDir = new File(AsterixEventService.getEventHome() + File.separator + "hadoop-" + hadoopVersion);
            if (!hadoopDir.exists()) {
                throw new IllegalStateException("Hadoop version :" + hadoopVersion + " not supported");
            }
            Nodeid nodeid = new Nodeid(new Value(null, EventDriver.CLIENT_NODE.getId()));
            String username = cluster.getUsername() != null ? cluster.getUsername() : System.getProperty("user.name");
            String pargs = username + " " + hadoopDir.getAbsolutePath() + " " + cluster.getMasterNode().getClusterIp() + " " + workingDir;
            Event event = new Event("directory_transfer", nodeid, pargs);
            Pattern p = new Pattern(null, 1, null, event);
            this.addInitialDelay(p, 2, "sec");
            ps.add(p);
            nodeid = new Nodeid(new Value(null, nodeToBeAdded.getId()));
            pargs = cluster.getUsername() + " " + hadoopDir.getAbsolutePath() + " " + nodeToBeAdded.getClusterIp() + " " + workingDir;
            event = new Event("directory_transfer", nodeid, pargs);
            p = new Pattern(null, 1, null, event);
            this.addInitialDelay(p, 2, "sec");
            ps.add(p);
        }
        return new Patterns(ps);
    }

    public Patterns getGenerateLogPattern(Cluster cluster, String outputDir) {
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        HashMap<String, String> nodeLogs = new HashMap<String, String>();
        String username = cluster.getUsername() == null ? System.getProperty("user.name") : cluster.getUsername();
        String srcHost = cluster.getMasterNode().getClientIp();
        Nodeid nodeid = new Nodeid(new Value(null, EventDriver.CLIENT_NODE.getId()));
        String srcDir = cluster.getMasterNode().getLogDir() == null ? cluster.getLogDir() : cluster.getMasterNode().getLogDir();
        String destDir = outputDir + File.separator + "cc";
        String pargs = username + " " + srcHost + " " + srcDir + " " + destDir;
        Event event = new Event("directory_copy", nodeid, pargs);
        Pattern p = new Pattern(null, 1, null, event);
        patternList.add(p);
        nodeLogs.put(cluster.getMasterNode().getClusterIp(), srcDir);
        for (Node node : cluster.getNode()) {
            srcHost = node.getClusterIp();
            String string = srcDir = node.getLogDir() == null ? cluster.getLogDir() : node.getLogDir();
            if (nodeLogs.get(node.getClusterIp()) != null && ((String)nodeLogs.get(node.getClusterIp())).equals(srcDir)) continue;
            destDir = outputDir + File.separator + node.getId();
            pargs = username + " " + srcHost + " " + srcDir + " " + destDir;
            event = new Event("directory_copy", nodeid, pargs);
            p = new Pattern(null, 1, null, event);
            patternList.add(p);
        }
        return new Patterns(patternList);
    }
}

