/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.config;

import java.util.function.Function;
import org.apache.asterix.common.config.AbstractProperties;
import org.apache.asterix.common.config.PropertiesAccessor;
import org.apache.hyracks.api.config.IApplicationConfig;
import org.apache.hyracks.api.config.IOption;
import org.apache.hyracks.api.config.IOptionType;
import org.apache.hyracks.api.config.Section;
import org.apache.hyracks.control.common.config.OptionTypes;
import org.apache.hyracks.util.StorageUtil;

public class StorageProperties
extends AbstractProperties {
    public StorageProperties(PropertiesAccessor accessor) {
        super(accessor);
    }

    public int getBufferCachePageSize() {
        return this.accessor.getInt(Option.STORAGE_BUFFERCACHE_PAGESIZE);
    }

    public long getBufferCacheSize() {
        return this.accessor.getLong(Option.STORAGE_BUFFERCACHE_SIZE);
    }

    public int getBufferCacheMaxOpenFiles() {
        return this.accessor.getInt(Option.STORAGE_BUFFERCACHE_MAXOPENFILES);
    }

    public int getMemoryComponentPageSize() {
        return this.accessor.getInt(Option.STORAGE_MEMORYCOMPONENT_PAGESIZE);
    }

    public int getMemoryComponentNumPages() {
        return this.accessor.getInt(Option.STORAGE_MEMORYCOMPONENT_NUMPAGES);
    }

    public int getMetadataMemoryComponentNumPages() {
        return this.accessor.getInt(Option.STORAGE_METADATA_MEMORYCOMPONENT_NUMPAGES);
    }

    public int getMemoryComponentsNum() {
        return this.accessor.getInt(Option.STORAGE_MEMORYCOMPONENT_NUMCOMPONENTS);
    }

    public long getMemoryComponentGlobalBudget() {
        return this.accessor.getLong(Option.STORAGE_MEMORYCOMPONENT_GLOBALBUDGET);
    }

    public double getBloomFilterFalsePositiveRate() {
        return this.accessor.getDouble(Option.STORAGE_LSM_BLOOMFILTER_FALSEPOSITIVERATE);
    }

    public int getBufferCacheNumPages() {
        return (int)(this.getBufferCacheSize() / (long)(this.getBufferCachePageSize() + 8));
    }

    public static enum Option implements IOption
    {
        STORAGE_BUFFERCACHE_PAGESIZE(OptionTypes.INTEGER_BYTE_UNIT, StorageUtil.getIntSizeInBytes((int)128, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.KILOBYTE)),
        STORAGE_BUFFERCACHE_SIZE(OptionTypes.LONG_BYTE_UNIT, Runtime.getRuntime().maxMemory() / 4L),
        STORAGE_BUFFERCACHE_MAXOPENFILES(OptionTypes.INTEGER, Integer.MAX_VALUE),
        STORAGE_MEMORYCOMPONENT_GLOBALBUDGET(OptionTypes.LONG_BYTE_UNIT, Runtime.getRuntime().maxMemory() / 4L),
        STORAGE_MEMORYCOMPONENT_PAGESIZE(OptionTypes.INTEGER_BYTE_UNIT, StorageUtil.getIntSizeInBytes((int)128, (StorageUtil.StorageUnit)StorageUtil.StorageUnit.KILOBYTE)),
        STORAGE_MEMORYCOMPONENT_NUMPAGES(OptionTypes.INTEGER, accessor -> (int)(accessor.getLong((IOption)STORAGE_MEMORYCOMPONENT_GLOBALBUDGET) / (long)(16 * accessor.getInt((IOption)STORAGE_MEMORYCOMPONENT_PAGESIZE)))),
        STORAGE_MEMORYCOMPONENT_NUMCOMPONENTS(OptionTypes.INTEGER, 2),
        STORAGE_METADATA_MEMORYCOMPONENT_NUMPAGES(OptionTypes.INTEGER, accessor -> Math.min((int)(accessor.getLong((IOption)STORAGE_MEMORYCOMPONENT_GLOBALBUDGET) / (long)(64 * accessor.getInt((IOption)STORAGE_MEMORYCOMPONENT_PAGESIZE))), 256)),
        STORAGE_LSM_BLOOMFILTER_FALSEPOSITIVERATE(OptionTypes.DOUBLE, 0.01);

        private final IOptionType interpreter;
        private final Object defaultValue;

        private <T> Option(IOptionType<T> interpreter, T defaultValue) {
            this.interpreter = interpreter;
            this.defaultValue = defaultValue;
        }

        private <T> Option(IOptionType<T> interpreter, Function<IApplicationConfig, T> defaultValueFunction) {
            this.interpreter = interpreter;
            this.defaultValue = defaultValueFunction;
        }

        public Section section() {
            return Section.NC;
        }

        public String description() {
            switch (this) {
                case STORAGE_BUFFERCACHE_PAGESIZE: {
                    return "The page size in bytes for pages in the buffer cache";
                }
                case STORAGE_BUFFERCACHE_SIZE: {
                    return "The size of memory allocated to the disk buffer cache.  The value should be a multiple of the buffer cache page size.";
                }
                case STORAGE_BUFFERCACHE_MAXOPENFILES: {
                    return "The maximum number of open files in the buffer cache";
                }
                case STORAGE_MEMORYCOMPONENT_GLOBALBUDGET: {
                    return "The size of memory allocated to the memory components.  The value should be a multiple of the memory component page size";
                }
                case STORAGE_MEMORYCOMPONENT_PAGESIZE: {
                    return "The page size in bytes for pages allocated to memory components";
                }
                case STORAGE_MEMORYCOMPONENT_NUMPAGES: {
                    return "The number of pages to allocate for a memory component.  This budget is shared by all the memory components of the primary index and all its secondary indexes across all I/O devices on a node.  Note: in-memory components usually has fill factor of 75% since the pages are 75% full and the remaining 25% is un-utilized";
                }
                case STORAGE_MEMORYCOMPONENT_NUMCOMPONENTS: {
                    return "The number of memory components to be used per lsm index";
                }
                case STORAGE_METADATA_MEMORYCOMPONENT_NUMPAGES: {
                    return "The number of pages to allocate for a metadata memory component";
                }
                case STORAGE_LSM_BLOOMFILTER_FALSEPOSITIVERATE: {
                    return "The maximum acceptable false positive rate for bloom filters associated with LSM indexes";
                }
            }
            throw new IllegalStateException("NYI: " + (Object)((Object)this));
        }

        public IOptionType type() {
            return this.interpreter;
        }

        public Object defaultValue() {
            return this.defaultValue;
        }

        public String usageDefaultOverride(IApplicationConfig accessor, Function<IOption, String> optionPrinter) {
            switch (this) {
                case STORAGE_MEMORYCOMPONENT_NUMPAGES: {
                    return "1/16th of the " + optionPrinter.apply(STORAGE_MEMORYCOMPONENT_GLOBALBUDGET) + " value";
                }
                case STORAGE_METADATA_MEMORYCOMPONENT_NUMPAGES: {
                    return "1/64th of the " + optionPrinter.apply(STORAGE_MEMORYCOMPONENT_GLOBALBUDGET) + " value or 256, whichever is larger";
                }
            }
            return null;
        }
    }
}

