/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.rtree.api.IRTreeInteriorFrame;
import org.apache.hyracks.storage.am.rtree.api.IRTreeLeafFrame;
import org.apache.hyracks.storage.am.rtree.impls.PathList;
import org.apache.hyracks.storage.am.rtree.impls.RTreeCursorInitialState;
import org.apache.hyracks.storage.am.rtree.impls.SearchPredicate;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public class RTreeSearchCursor
implements ITreeIndexCursor {
    private int fileId = -1;
    private ICachedPage page = null;
    private IRTreeInteriorFrame interiorFrame = null;
    protected IRTreeLeafFrame leafFrame = null;
    private IBufferCache bufferCache = null;
    private SearchPredicate pred;
    private PathList pathList;
    private int rootPage;
    protected ITupleReference searchKey;
    private int tupleIndex = 0;
    private int tupleIndexInc = 0;
    private int currentTupleIndex = 0;
    private int pageId = -1;
    protected MultiComparator cmp;
    private ITreeIndexTupleReference frameTuple;
    private boolean readLatched = false;

    public RTreeSearchCursor(IRTreeInteriorFrame interiorFrame, IRTreeLeafFrame leafFrame) {
        this.interiorFrame = interiorFrame;
        this.leafFrame = leafFrame;
        this.frameTuple = leafFrame.createTupleReference();
    }

    public void close() throws HyracksDataException {
        if (this.readLatched) {
            this.page.releaseReadLatch();
            this.bufferCache.unpin(this.page);
            this.readLatched = false;
        }
        this.tupleIndex = 0;
        this.tupleIndexInc = 0;
        this.page = null;
        this.pathList = null;
    }

    public ITupleReference getTuple() {
        return this.frameTuple;
    }

    public ITupleReference getFilterMinTuple() {
        return null;
    }

    public ITupleReference getFilterMaxTuple() {
        return null;
    }

    public int getTupleOffset() {
        return this.leafFrame.getTupleOffset(this.currentTupleIndex);
    }

    public int getPageId() {
        return this.pageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean fetchNextLeafPage() throws HyracksDataException {
        boolean succeeded = false;
        if (this.readLatched) {
            this.page.releaseReadLatch();
            this.bufferCache.unpin(this.page);
            this.readLatched = false;
        }
        while (!this.pathList.isEmpty()) {
            int pageId = this.pathList.getLastPageId();
            long parentLsn = this.pathList.getLastPageLsn();
            this.pathList.moveLast();
            if (pageId < 0) {
                throw new IllegalStateException();
            }
            if (this.fileId < 0) {
                throw new IllegalStateException();
            }
            ICachedPage node = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)pageId), false);
            node.acquireReadLatch();
            this.readLatched = true;
            try {
                int rightPage;
                this.interiorFrame.setPage(node);
                boolean isLeaf = this.interiorFrame.isLeaf();
                long pageLsn = this.interiorFrame.getPageLsn();
                if (pageId != this.rootPage && parentLsn < this.interiorFrame.getPageNsn() && (rightPage = this.interiorFrame.getRightPage()) != -1) {
                    this.pathList.add(rightPage, parentLsn, -1);
                }
                if (!isLeaf) {
                    int childPageId;
                    int i;
                    if (this.searchKey != null) {
                        for (i = this.interiorFrame.getTupleCount() - 1; i >= 0; --i) {
                            childPageId = this.interiorFrame.getChildPageIdIfIntersect(this.searchKey, i, this.cmp);
                            if (childPageId == -1) continue;
                            this.pathList.add(childPageId, pageLsn, -1);
                        }
                        continue;
                    }
                    for (i = this.interiorFrame.getTupleCount() - 1; i >= 0; --i) {
                        childPageId = this.interiorFrame.getChildPageId(i);
                        this.pathList.add(childPageId, pageLsn, -1);
                    }
                    continue;
                }
                this.page = node;
                this.pageId = pageId;
                this.leafFrame.setPage(this.page);
                this.tupleIndex = 0;
                succeeded = true;
                boolean bl = true;
                return bl;
            }
            finally {
                if (succeeded || !this.readLatched) continue;
                node.releaseReadLatch();
                this.readLatched = false;
                this.bufferCache.unpin(node);
            }
        }
        return false;
    }

    public boolean hasNext() throws HyracksDataException {
        if (this.page == null) {
            return false;
        }
        if (this.tupleIndex == this.leafFrame.getTupleCount() && !this.fetchNextLeafPage()) {
            return false;
        }
        do {
            for (int i = this.tupleIndex; i < this.leafFrame.getTupleCount(); ++i) {
                if (this.searchKey != null) {
                    if (!this.leafFrame.intersect(this.searchKey, i, this.cmp)) continue;
                    this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this.leafFrame, i);
                    this.currentTupleIndex = i;
                    this.tupleIndexInc = i + 1;
                    return true;
                }
                this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this.leafFrame, i);
                this.currentTupleIndex = i;
                this.tupleIndexInc = i + 1;
                return true;
            }
        } while (this.fetchNextLeafPage());
        return false;
    }

    public void next() throws HyracksDataException {
        this.tupleIndex = this.tupleIndexInc;
    }

    public void open(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        if (this.page != null) {
            this.page.releaseReadLatch();
            this.readLatched = false;
            this.bufferCache.unpin(this.page);
            this.pathList.clear();
        }
        this.pathList = ((RTreeCursorInitialState)initialState).getPathList();
        this.rootPage = ((RTreeCursorInitialState)initialState).getRootPage();
        this.pred = (SearchPredicate)searchPred;
        this.cmp = this.pred.getLowKeyComparator();
        this.searchKey = this.pred.getLowKey();
        if (this.searchKey != null) {
            int maxFieldPos = this.cmp.getKeyFieldCount() / 2;
            for (int i = 0; i < maxFieldPos; ++i) {
                int j = maxFieldPos + i;
                int c = this.cmp.getComparators()[i].compare(this.searchKey.getFieldData(i), this.searchKey.getFieldStart(i), this.searchKey.getFieldLength(i), this.searchKey.getFieldData(j), this.searchKey.getFieldStart(j), this.searchKey.getFieldLength(j));
                if (c <= 0) continue;
                throw new IllegalArgumentException("The low key point has larger coordinates than the high key point.");
            }
        }
        this.pathList.add(this.rootPage, -1L, -1);
        this.tupleIndex = 0;
        this.fetchNextLeafPage();
    }

    public void reset() throws HyracksDataException {
        this.close();
    }

    public void setBufferCache(IBufferCache bufferCache) {
        this.bufferCache = bufferCache;
    }

    public void setFileId(int fileId) {
        this.fileId = fileId;
    }

    public boolean isExclusiveLatchNodes() {
        return false;
    }
}

