/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree.impls;

import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexMetadataFrame;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.common.tuples.PermutingTupleReference;
import org.apache.hyracks.storage.am.rtree.api.IRTreeInteriorFrame;
import org.apache.hyracks.storage.am.rtree.api.IRTreeLeafFrame;
import org.apache.hyracks.storage.am.rtree.impls.PathList;
import org.apache.hyracks.storage.am.rtree.impls.RTreeCursorInitialState;
import org.apache.hyracks.storage.am.rtree.impls.RTreeSplitKey;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IExtraPageBlockHelper;

public class RTreeOpContext
implements IIndexOperationContext,
IExtraPageBlockHelper {
    private static final int INITIAL_TRAVERSE_LIST_SIZE = 100;
    private static final int INITIAL_HEIGHT = 8;
    private final MultiComparator cmp;
    private final IRTreeInteriorFrame interiorFrame;
    private final IRTreeLeafFrame leafFrame;
    private IndexOperation op;
    private ITreeIndexCursor cursor;
    private RTreeCursorInitialState cursorInitialState;
    private final IPageManager freePageManager;
    private final ITreeIndexMetadataFrame metaFrame;
    private RTreeSplitKey splitKey;
    private ITupleReference tuple;
    private PathList pathList;
    private PathList traverseList;
    private ArrayList<ICachedPage> NSNUpdates;
    private ArrayList<ICachedPage> LSNUpdates;
    private IModificationOperationCallback modificationCallback;
    private PermutingTupleReference tupleWithNonIndexFields;

    public RTreeOpContext(IRTreeLeafFrame leafFrame, IRTreeInteriorFrame interiorFrame, IPageManager freePageManager, IBinaryComparatorFactory[] cmpFactories, IModificationOperationCallback modificationCallback) {
        this.cmp = cmpFactories[0] != null ? MultiComparator.create((IBinaryComparatorFactory[])cmpFactories) : null;
        this.interiorFrame = interiorFrame;
        this.leafFrame = leafFrame;
        this.freePageManager = freePageManager;
        this.metaFrame = freePageManager.createMetadataFrame();
        this.modificationCallback = modificationCallback;
        this.pathList = new PathList(8, 8);
        this.NSNUpdates = new ArrayList();
        this.LSNUpdates = new ArrayList();
    }

    public RTreeOpContext(IRTreeLeafFrame leafFrame, IRTreeInteriorFrame interiorFrame, IPageManager freePageManager, IBinaryComparatorFactory[] cmpFactories, IModificationOperationCallback modificationCallback, int[] nonIndexFields) {
        this(leafFrame, interiorFrame, freePageManager, cmpFactories, modificationCallback);
        this.tupleWithNonIndexFields = new PermutingTupleReference(nonIndexFields);
    }

    public ITupleReference getTuple() {
        return this.tuple;
    }

    public void setTuple(ITupleReference tuple) {
        this.tuple = tuple;
    }

    public void reset() {
        if (this.pathList != null) {
            this.pathList.clear();
        }
        if (this.traverseList != null) {
            this.traverseList.clear();
        }
        this.NSNUpdates.clear();
        this.LSNUpdates.clear();
    }

    public void setOperation(IndexOperation newOp) {
        if (this.op != null && newOp == this.op) {
            return;
        }
        if (this.op != IndexOperation.SEARCH && this.op != IndexOperation.DISKORDERSCAN) {
            if (this.splitKey == null) {
                this.splitKey = new RTreeSplitKey(this.interiorFrame.getTupleWriter().createTupleReference(), this.interiorFrame.getTupleWriter().createTupleReference());
            }
            if (this.traverseList == null) {
                this.traverseList = new PathList(100, 100);
            }
        }
        if (this.cursorInitialState == null) {
            this.cursorInitialState = new RTreeCursorInitialState(this.pathList, 1);
        }
        this.op = newOp;
    }

    public IndexOperation getOperation() {
        return this.op;
    }

    public void setModificationCallback(IModificationOperationCallback modificationCallback) {
        this.modificationCallback = modificationCallback;
    }

    public int getFreeBlock(int size) throws HyracksDataException {
        return this.freePageManager.takeBlock(this.metaFrame, size);
    }

    public void returnFreePageBlock(int blockPageId, int size) throws HyracksDataException {
        this.freePageManager.releaseBlock(this.metaFrame, blockPageId, size);
    }

    public IRTreeInteriorFrame getInteriorFrame() {
        return this.interiorFrame;
    }

    public PathList getPathList() {
        return this.pathList;
    }

    public MultiComparator getCmp() {
        return this.cmp;
    }

    public IRTreeLeafFrame getLeafFrame() {
        return this.leafFrame;
    }

    public IModificationOperationCallback getModificationCallback() {
        return this.modificationCallback;
    }

    public List<ICachedPage> getLSNUpdates() {
        return this.LSNUpdates;
    }

    public RTreeSplitKey getSplitKey() {
        return this.splitKey;
    }

    public ITreeIndexMetadataFrame getMetaFrame() {
        return this.metaFrame;
    }

    public List<ICachedPage> getNSNUpdates() {
        return this.NSNUpdates;
    }

    public PathList getTraverseList() {
        return this.traverseList;
    }

    public ITreeIndexCursor getCursor() {
        return this.cursor;
    }

    public void setCursor(ITreeIndexCursor cursor) {
        this.cursor = cursor;
    }

    public RTreeCursorInitialState getCursorInitialState() {
        return this.cursorInitialState;
    }

    public ITupleReference getTupleWithNonIndexFields() {
        return this.tupleWithNonIndexFields;
    }

    public void resetNonIndexFieldsTuple(ITupleReference newValue) {
        this.tupleWithNonIndexFields.reset(newValue);
    }
}

