/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.dataset.ResultSetId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.common.work.AbstractWork;

public class RegisterResultPartitionLocationWork
extends AbstractWork {
    private final ClusterControllerService ccs;
    private final JobId jobId;
    private final ResultSetId rsId;
    private final boolean orderedResult;
    private final boolean emptyResult;
    private final int partition;
    private final int nPartitions;
    private final NetworkAddress networkAddress;

    public RegisterResultPartitionLocationWork(ClusterControllerService ccs, JobId jobId, ResultSetId rsId, boolean orderedResult, boolean emptyResult, int partition, int nPartitions, NetworkAddress networkAddress) {
        this.ccs = ccs;
        this.jobId = jobId;
        this.rsId = rsId;
        this.orderedResult = orderedResult;
        this.emptyResult = emptyResult;
        this.partition = partition;
        this.nPartitions = nPartitions;
        this.networkAddress = networkAddress;
    }

    public void run() {
        try {
            this.ccs.getDatasetDirectoryService().registerResultPartitionLocation(this.jobId, this.rsId, this.orderedResult, this.emptyResult, this.partition, this.nPartitions, this.networkAddress);
        }
        catch (HyracksDataException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.getName() + ": JobId@" + this.jobId + " ResultSetId@" + this.rsId + " Partition@" + this.partition + " NPartitions@" + this.nPartitions + " ResultPartitionLocation@" + this.networkAddress + " OrderedResult@" + this.orderedResult + " EmptyResult@" + this.emptyResult;
    }
}

